(ns atena.gui.AddressTableModel
  (:import (javax.swing.table DefaultTableModel)
           (java.util UUID Calendar Date)
           )
  (:gen-class
   :extends javax.swing.table.DefaultTableModel
   :init init
   :post-init after-ctor
   :state state
   :methods [[getRowData [int] Object]
             [setRowData [int Object String] void]
             [update [String Object] void]
             [remove [String] void]
             [searchIndexByUuid [String] int]
            ]
   ))

(defn -init []
  [[] []])

(defn -getRowData
  [this index]
  {:checked     (. this getValueAt index 0)
   :family-name (. this getValueAt index 1)
   :first-names (. this getValueAt index 2)
   :honer       (. this getValueAt index 3)
   :zcode       (. this getValueAt index 4)
   :address     (. this getValueAt index 5)
   :uuid        (. this getValueAt index 6)})

(defn -setRowData
  [this index data uuid]
  (. this setValueAt (data :family-name) index 1)
  (. this setValueAt (data :first-names) index 2)
  (. this setValueAt (data :honer)       index 3)
  (. this setValueAt (data :zcode)       index 4)
  (. this setValueAt (data :address)     index 5)
  (. this setValueAt (if (= nil uuid)
                         (data :uuid)
                         uuid)           index 6))

(defn -searchIndexByUuid
  [this
   uuid]
  (let [count (. this getRowCount)]
    (loop [i 0]
      (if (<= count i)
          -1
          (if (= uuid (. this getValueAt i 6))
              i
              (recur (+ i 1)))))))

(defn -update
  [this
   uuid
   data]
  (let [i (. this searchIndexByUuid uuid)]
    (if (= -1 i)
        (. this addRow (to-array [false
                                  (data :family-name)
                                  (data :first-names)
                                  (data :honer)
                                  (data :zcode)
                                  (data :address)
                                  uuid]))
        (. this setRowData i data uuid))))

(defn -remove
  [this
   uuid]
  (let [i (. this searchIndexByUuid uuid)]
    (when (not (= -1 i))
          (. this removeRow i))))

(defn -after-ctor [this]
  (doto this
    (.setColumnCount 7)
    (.setRowCount 0)
    )
  )
