(ns atena.gui.Config
  (:import (java.io File))
  (:use [clojure.contrib.duck-streams :only (reader read-lines writer write-lines with-out-writer)])
  (:gen-class))

(defn- get-parent
  ".settingsディレクトリを返却する。存在しない場合は生成する。"
  []
  (let [directory (File. ".settings")]
    (cond (not (. directory exists))      (do
                                            (. directory mkdir)
                                            directory)
          
          (not (. directory isDirectory)) (do
                                            (. directory delete)
                                            (. directory mkdir)
                                            directory)
          :else directory)))

(defn last-file-path
  ([]
    (let [file (File. (get-parent) "last-file-path")]
      (if (not (. file exists))
          nil
          (first (read-lines (. file getAbsolutePath))))))
  ([path]
    (let [file (File. (get-parent) "last-file-path")]
      (write-lines (writer (. file getAbsolutePath))
                   (list path)))))

(defn zipcode-data-file-url
  ([]
    (let [setting-file  ".last-file-path"
          file          (java.io.File. setting-file)]
      (if (not (. file exists))
          nil
          (first (read-lines setting-file)))))
  ([path]
    (write-lines (writer ".last-file-path")
                 (list path))))
