(ns atena.gui.FromInfoPanel
  (:import (java.awt BorderLayout GridLayout GridBagLayout Insets
                     Font Color Dimension FlowLayout)
           (java.awt.event  ActionListener)
           (javax.swing JPanel JLabel JTextField JButton JCheckBox JOptionPane)
           (javax.swing.border TitledBorder LineBorder)
           )
  (:require [atena.utils.gridbaglayout])
  (:gen-class
   :extends javax.swing.JPanel
   :init init
   :post-init after-ctor
   :state state
   :methods [[setData [Object] void]
             [getData [] Object]]
   ))


(defn -init []
  [[]
   (ref {:family-name-label (JLabel.)
         :first-names-label (JLabel.)
         :zip-code-label    (JLabel.)
         :address-label     (JLabel.)
        })])

(defn -setData
  ;差出人データ割り当て処理
  [this data]
  (let [{:keys [family-name-label
                first-names-label
                zip-code-label
                address-label
               ]} @(.state this)]
    (.setText family-name-label (data :family-name))
    (.setText first-names-label (data :first-names))
    (.setText zip-code-label (data :zcode))
    (.setText address-label (data :address))))

(defn -getData
  ;差出人データ割り当て処理
  [this]
  (let [{:keys [family-name-label
                first-names-label
                zip-code-label
                address-label
               ]} @(.state this)]
    {:family-name (.getText family-name-label)
     :first-names (.getText first-names-label)
     :zcode       (.getText zip-code-label)
     :address     (.getText address-label)}))

(defn -after-ctor [this]
  (let [{:keys [family-name-label
                first-names-label
                zip-code-label
                address-label
               ]} @(.state this)]

    (doto this
      (.setLayout (GridBagLayout.))
      (.setBorder (TitledBorder. (LineBorder. Color/GRAY 2)
                                 "差出人情報"
                                 TitledBorder/LEFT
                                 TitledBorder/TOP
                                 (Font. Font/MONOSPACED Font/BOLD 12)))
      (atena.utils.gridbaglayout/grid-bag-layout
        :insets (Insets. 5 5 5 5)
        :anchor :WEST
        :gridx 0, :gridy 1, :weightx 0.0, :fill :NONE
        (JLabel. "姓")
        :gridx 1, :gridy 1, :weightx 1.0, :fill :HORIZONTAL
        family-name-label
        :gridx 0, :gridy 2, :weightx 0.0, :fill :NONE
        (JLabel. "名")
        :gridx 1, :gridy 2, :weightx 1.0, :fill :HORIZONTAL
        first-names-label
        :gridx 0, :gridy 3, :weightx 0.0, :fill :NONE
        (JLabel. "郵便番号")
        :gridx 1, :gridy 3, :weightx 1.0, :fill :HORIZONTAL
        zip-code-label
        :gridx 0, :gridy 4, :weightx 0.0, :fill :NONE
        (JLabel. "住所")
        :gridx 1, :gridy 4, :weightx 1.0, :fill :HORIZONTAL
        address-label))))
  