(ns atena.gui.HistoryTableColumnModel
  (:import (javax.swing JCheckBox
                        DefaultCellEditor
                        JPanel)
           (javax.swing.table DefaultTableColumnModel
                              TableCellRenderer
                              TableCellEditor
                              TableColumn)
           )
  (:gen-class
   :extends javax.swing.table.DefaultTableColumnModel
   :init init
   :post-init after-ctor
   :state state
   :methods []
   ))

(defn -init []
  [[]
   (ref {:column0 (TableColumn.)
         :column1 (TableColumn.)
         :column2 (TableColumn.)
         :column3 (TableColumn.)
        })
   ])

(defn -after-ctor [this]
  (let [{:keys [column0
                column1
                column2
                column3
               ]} @(.state this)]
    (def renderer (doto (proxy [JCheckBox TableCellRenderer] []
                    (getTableCellRendererComponent [table value isSelected hasFocus row column]
                      (let [check (.getValueAt table row column)]
                        (.setSelected this check)
                        this)))))
    (doto column0
      (.setModelIndex 0)
      (.setHeaderValue "年")
      (.setResizable false)
      (.sizeWidthToFit)
      (.setPreferredWidth 60))
    (doto column1
      (.setModelIndex 1)
      (.setHeaderValue "喪中")
      (.setResizable false)
      (.setCellEditor (DefaultCellEditor. (JCheckBox.)))
      (.setCellRenderer renderer)
      (.setPreferredWidth 40))
    (doto column2
      (.setModelIndex 2)
      (.setHeaderValue "送付日")
      (.setResizable false)
      (.setPreferredWidth 90))
    (doto column3
      (.setModelIndex 3)
      (.setHeaderValue "受取日")
      (.setResizable false)
      (.setPreferredWidth 90))
    (doto this
      (.addColumn column0)
      (.addColumn column1)
      (.addColumn column2)
      (.addColumn column3)
      )))
  
