(ns atena.gui.HistoryTableModel
  (:import (javax.swing.table DefaultTableModel)
           (java.util UUID Calendar Date)
           )
  (:gen-class
   :extends javax.swing.table.DefaultTableModel
   :init init
   :post-init after-ctor
   :state state
   :methods [[setMournings [Object] void]
             [getMournings [] Object]
             [getHistories [] Object]
             [setData [Object] void]
            ]
   ))

(defn -init []
  [[] []])

(defn getData
  [model
   filter-proc
   creator-proc]
  (let [indexes (filter filter-proc
                        (range (. model getRowCount)))]
    (apply list (map creator-proc
                     indexes))))

(defn -setData
  [this
   data]
  (. this setRowCount 0)
  (doseq [entry data]
    (. this addRow (to-array entry))))

(defn -getMournings
  [this]
  (getData this
           (fn [index]
             (= true (. this (getValueAt index 1))))
           (fn [index]
             (. this getValueAt index 0))))

(defn -setMournings
  [this
   data]
  (. this setRowCount 0)
  (doseq [year data]
    (. this addRow (to-array [year true false false]))))

(defn -getHistories
  [this]
  (let [data (getData this
                (fn [index]
                  (not (and (= nil (. this (getValueAt index 2)))
                       (= nil (. this (getValueAt index 3))))))
                (fn [index]
                  [(. this getValueAt index 0)
                   (. this getValueAt index 2)
                   (. this getValueAt index 3)]))]
    (reduce #(assoc %1 (%2 0) (subvec %2 1))
            {}
            data)))

(defn -after-ctor [this]
  (doto this
    (.setColumnCount 4)
    (.setRowCount 0)
    )
  )
