(ns atena.postaldata
  (:import [java.sql SQLException])
  (:use [clojure.contrib.sql])
  (:gen-class))

(Class/forName "org.sqlite.JDBC")
(defn contrib-sql
  []
  (with-connection {:classname "org.sqlite.JDBC"
                    :subprotocol "sqlite"
                    :subname "test.db"}
    ;; テーブル削除
    (try
      (drop-table :program)
      (catch SQLException e (.toString e)))

    ;; テーブル作成
    (create-table :program [:name :text] [:extension :text])

    ;; レコード登録
    (try
      (transaction
       (println  (insert-rows :program ["Clojure" "clj"] ["Java" "java"]))
       ;; (println (insert-values :program
       ;;                [:name :extension]
       ;;                ["Clojure" "clj"]
       ;;                ["Java" "java"]))
       ;; (println  (insert-records :program {:name "clojure" :extension "clj"}))
       )
       (catch Exception e (.toString e)))

    ;; 結果表示
    (with-query-results results ["select * from program"]
      (doseq [record results]
        (println "name = " (:name record))
        (println "extension  = " (:extension record))))

    ;; レコード更新
    (try
      (transaction
       (println)
       (println  (update-values :program ["name=? or name=?" "Clojure" "Java"] {:extension "clj"})))
       (catch Exception e (.toString e)))

    ;; 結果表示
    (with-query-results results ["select * from program"]
      (doseq [record results]
        (println "name = " (:name record))
        (println "extension  = " (:extension record))))

    ;; レコード削除
    (try
      (transaction
       (println)
       (println  (delete-rows :program ["name=?" "Clojure"])))
       (catch Exception e (.toString e)))

    ;; 結果表示
    (with-query-results results ["select * from program"]
      (doseq [record results]
        (println "name = " (:name record))
        (println "extension  = " (:extension record))))

    ;; レコード削除
    (try
      (transaction
       (println)
       (println  (delete-rows :program ["name=?" "Java"]))
       (throw (SQLException. "ERROR")))
       (catch Exception e (.toString e)))

    ;; 結果表示
    (with-query-results results ["select * from program"]
      (doseq [record results]
        (println "name = " (:name record))
        (println "extension  = " (:extension record))))

    ))