#include	"trust.h"
#include	"shm.h"
#include	"repeater.h"


int Repeater(void)
{
	struct	repMsg	reqConMsg;
	
	int	ret;
	int	width;
	int	n;
	int	numrcv;
	int	opt;
        fd_set  readOk, Mask;
        struct  timeval timeout;

	char	line[20];

        FD_ZERO(&Mask);
        FD_SET(Acc,&Mask);
        FD_SET(0,&Mask);
        width = Acc+1;

	DB(fprintf(stderr,"Start Repeater\n"));

	if (login(Acc))
	{
        	// パケットの送信
	        send(Acc, "Port Number: ", 13, 0);
	
        	//パケットの受信
	        numrcv = recv(Acc, line, 10, 0);
        	line[numrcv] = 0x00;
		for (n = 0 ; n < numrcv ; n++)
        	{
                	if (line[n] == 0x0a) line[n] = 0x00;
                	if (line[n] == 0x0d) line[n] = 0x00;
        	}
        	Port = atoi (line);

		dbSock = socket(AF_INET, SOCK_DGRAM, 0);
        	opt=1;
        	if (setsockopt(dbSock,SOL_SOCKET,SO_REUSEADDR,&opt,sizeof(int)) != 0){
                	perror("setsockopt");
                	exit(-1);
        	}
        	DB(fprintf(stderr,"setsockopt:OK\n"));
		while(1){
			readOk = Mask;
			timeout.tv_sec = 0;
			timeout.tv_usec = 5000;
			switch (select(width, (fd_set *)&readOk, NULL, NULL, &timeout)){
                        	case    -1:
                                	perror("child select");
                                	break;

                       		case    0:
					for (n = 0 ; n < MAX_SHM ; n++)
					{
						if (shm_msg->shmem[n].type == 1)
						{ 
							if (memcmp(shm_msg->shmem[n].dstRep, RepeaterCall, 8) == 0) 
							{
								printf ("%d %8.8s %8.8s %8.8s\n", shm_msg->shmem[n].type, 
									shm_msg->shmem[n].srcCall, 
									shm_msg->shmem[n].dstCall,
									RepeaterCall);
								reqConMsg.reqType = ReqConnect;
								reqConMsg.reqConnect.protocol = shm_msg->shmem[n].protocol;
								reqConMsg.reqConnect.ip = shm_msg->shmem[n].srcIP;
								memcpy (reqConMsg.reqConnect.YourCall, 
									shm_msg->shmem[n].srcCall, 8);
								reqConMsg.reqConnect.port = shm_msg->shmem[n].srcPort;
								send(Acc, &reqConMsg, sizeof(reqConMsg), 0);
								shm_msg->shmem[n].srcIP = RepeaterIP;
								shm_msg->shmem[n].srcPort = Port;
								shm_msg->shmem[n].type = 2;
							}
						}
						else if (shm_msg->shmem[n].type == 2)
						{
							if (memcmp(shm_msg->shmem[n].Rep1Call, RepeaterCall, 8) == 0)
							{
								memcpy (reqConMsg.ackConnect.call, 
									shm_msg->shmem[n].dstCall, 8);
								reqConMsg.ackConnect.ip = shm_msg->shmem[n].srcIP;
								reqConMsg.ackConnect.port = shm_msg->shmem[n].srcPort;
								reqConMsg.reqType = Ack;
								printf ("%2.2x %8.8s %s\n", reqConMsg.reqType, 
									reqConMsg.ackConnect.call, 
									inet_ntoa(reqConMsg.ackConnect.ip));
								ret = send (Acc, &reqConMsg, sizeof(reqConMsg), 0);
								shm_msg->shmem[n].type = 0;
							}
						}
					}
                                	break;

                       	 	default:
                                	if(FD_ISSET(Acc, &readOk)){
						ret = recv(Acc, &reqConMsg, sizeof(reqConMsg), 0);
						if (ret == -1){
							perror("recv");
							goto exit_00;
						}
						if (ret > 0)
						{
							if (DoCommand(reqConMsg) == -1){
								/* end */
								goto exit_00;
							}
						}
					}
			}
		}
	}
exit_00:
	DB(fprintf(stderr,"Start Repeater [%8.8s]:end\n", RepeaterCall));

	return(0);
}

int DoCommand(struct repMsg com)
{
        int     ret;

        DB(fprintf(stderr,"%8.8s\n",RepeaterCall));
	ret = 0;

        if (com.reqType == ReqConnect)
	{
		memcpy (send_msg.Rep2Call, com.reqConnect.Rpt2Call, 32);
               	send_msg.srcIP = RepeaterIP;
               	send_msg.srcPort = Port;
		memcpy (send_msg.dstRep, com.reqConnect.YourCall, 8);
               	gettimeofday (&send_msg.e_time, NULL);
               	send_msg.type = 1;
               	send_msg.protocol = com.reqConnect.protocol;
                dbAddr.sin_family = AF_INET;
                dbAddr.sin_port = dbInPort;
                dbAddr.sin_addr.s_addr = inet_addr("127.0.0.1");
		ret =sendto (dbSock, &send_msg, sizeof (struct shm_form), 0,
				(struct sockaddr *)&dbAddr, sizeof(dbAddr));
        }
	else
	{
		shmdt (shm_msg);
		ret = -1;
	}
        return(ret);
}

