/*

*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netinet/ip.h>
#include	"dv_echo.h"

void	config(int argc, char **argv)
{
	char	buff[128];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	FILE	*config_file;
	int	len;

	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			logfile = fopen(LOGFILE, "a");
			now = time(NULL);
			fprintf (logfile, "%24.24s config file not found (%s)\n", ctime(&now), argv[1]);
			fclose (logfile);
			exit (1);
		}
	} 
	else
	{
		config_file = fopen ("/etc/dv_echo.conf","r");
		if (!config_file)
		{
			logfile = fopen (LOGFILE, "a");
			now = time(NULL);
			fprintf (logfile, "%24.24s config file not found (/etc/dv_echo.conf)\n", ctime(&now));
			fclose (logfile);
			exit (1);
		}
	}

	while (fgets (buff, 127, config_file))
	{
		if (buff[0] != '#')
		{
			pnt = strtok(buff, delmi);
			pnt = strtok(NULL,delmi);

			if (!memcmp (buff, "REPEATER_CALL", 13))
			{
                                memset (client_call, 0x20, 8);
				len = strlen(pnt);
				if (len > 8) len = 8;
                                memcpy (client_call, pnt, len);
			}
			else if (!memcmp (buff, "PASSWORD", 8))
			{
				memset (client_password, 0x00, 64);
				memcpy (client_password, pnt, strlen(pnt));
			}
                        else if (!memcmp (buff, "TRUST_DOMAIN_NAME", 17))
                        {
                                memset (TrustDomainName, 0x00, 128);
                                memcpy (TrustDomainName, pnt, strlen(pnt));
                        }
                        else if (!memcmp (buff, "TRUST_DB_DOMAIN_NAME", 20))
                        {
                                memset (TrustDbDomainName, 0x00, 128);
                                memcpy (TrustDbDomainName, pnt, strlen(pnt));
                        }
                        else if (!memcmp (buff, "AUDIO_DIRECTORY", 15))
                        {
                                memset (AudioDirectory, 0x00, 128);
				len = strlen(pnt);
                                memcpy (AudioDirectory, pnt, len);
				if (AudioDirectory[len-1] != '/') 
					AudioDirectory[len] = '/';
                        }
			else if (!memcmp (buff, "PORT", 4))
			{
				client_port = htons(atoi(pnt));
			}
                        else if (!memcmp (buff, "TRUST_PORT", 10))
                        {
                                trust_port = htons(atoi(pnt));
                        }
			else if (!memcmp (buff, "TRUST_DB_PORT", 13))
			{
				db_port = htons(atoi(pnt));
			} 
			else if (!memcmp (buff, "CMD_MODE", 8))
			{
				cmd_mode = atoi(pnt);
			}
		}
	}
	fclose (config_file);
}
