#include	"trustDB.h"

void	exit (int status);

void	MainLoop();
void	CloseSocket();
void	CloseChild();

void main(argc, argv)
int	argc;
char	*argv[];
{

	TrustDB_in = 0;
	TrustDB_out = 0;

	InitSocket();
	InitSignal();
	MainLoop();
}

int InitSocket(void)
{
	char	hostname[MAXHOSTNAMELEN];
	struct	hostent	*myhost;
	struct	servent	*se;
	int	opt;

	DB(fprintf(stderr,"InitSocket\n"));

	if (gethostname(hostname,MAXHOSTNAMELEN) == -1){
		perror("gethostname");
		exit(-1);
	}
	DB(fprintf(stderr,"hostname=%s\n",hostname));
	if ((se=getservbyname("AuthTrust","tcp")) == NULL){
		perror("getservbyname");
		exit(-1);
	}
	DB(fprintf(stderr,"getservbyname:OK\n"));
	if ((myhost=gethostbyname(hostname)) == NULL){
		perror("gethostbyname");
		exit(-1);
	}
	DB(fprintf(stderr,"gethostbyname:OK\n"));

        if ((se=getservbyname("TrustDB_in","udp")) == NULL){
                perror("getservbyname");
                exit(-1);
        }
        DB(fprintf(stderr,"getservbyname:TrustDB_in:OK\n"));
	dbInPort = se->s_port;

        if ((TrustDB_in = socket(AF_INET,SOCK_DGRAM,0)) < 0){
                perror("socket:TrustDB_in");
                exit(-1);
        }
        DB(fprintf(stderr,"socket:TrustDB_in:OK\n"));

        opt=1;
        if (setsockopt(TrustDB_in,SOL_SOCKET,SO_REUSEADDR,&opt,sizeof(int)) != 0){
                perror("setsockopt");
                exit(-1);
        }
        DB(fprintf(stderr,"setsockopt:OK\n"));

        if ((TrustDB_out = socket(AF_INET,SOCK_DGRAM,0)) < 0){
                perror("socket:TrustDB_out");
                exit(-1);
        }
        DB(fprintf(stderr,"socket:TrustDB_out:OK\n"));
        opt=1;
        if (setsockopt(TrustDB_out,SOL_SOCKET,SO_REUSEADDR,&opt,sizeof(int)) != 0){
                perror("setsockopt");
                exit(-1);
        }
        DB(fprintf(stderr,"setsockopt:OK\n"));
        if ((se=getservbyname("TrustDB_out","udp")) == NULL){
                perror("getservbyname");
                exit(-1);
        }
        DB(fprintf(stderr,"getservbyname:TrustDB_out:OK\n"));
	memset((char *)&db_out,0,sizeof(db_out));
	db_out.sin_family=AF_INET;
	db_out.sin_port=se->s_port;
	db_out.sin_addr.s_addr = inet_addr("127.0.0.1");
	if (bind(TrustDB_out,(struct sockaddr *)&db_out, sizeof(db_out)) == -1){
		perror("bind:db_out");
		exit(-1);
	}
	DB(fprintf(stderr,"bind:db:OK\n"));

	return(0);
}

void CloseSocket()
{
	DB(fprintf(stderr,"CloseSocket\n"));
        if(TrustDB_in != 0){
                close(TrustDB_in);
                DB(fprintf(stderr,"close(TrustDB_in)\n"));
                TrustDB_in = 0;
        }
        if(TrustDB_out != 0){
                close(TrustDB_out);
                DB(fprintf(stderr,"close(TrustDB_out)\n"));
                TrustDB_out = 0;
        }
	DB(fprintf(stderr,"CloseSocket:exit\n"));

	exit(0);
}

void CloseChild()
{
	int	pid;

	DB(fprintf(stderr,"CloseChild\n"));
	pid=wait(0);
	DB(fprintf(stderr,"wait:pid=%d:end\n",pid));
	signal(SIGCLD,CloseChild);
}

int InitSignal()
{
	DB(fprintf(stderr,"InitSignal\n"));
	signal(SIGINT,CloseSocket);
	signal(SIGTERM,CloseSocket);
	signal(SIGCLD,CloseChild);

	return(0);
}

void CheckEntry(void)
{
	int	ret;
	int	length;

	length = sizeof(struct sockaddr_in);
	ret = recvfrom(TrustDB_out, &send_msg, sizeof(struct shm_form), 0, 
		(struct sockaddr *)&db_out, &length);
	if (ret > 0)
	{
        	memset((char *)&db_in,0,sizeof(db_in));
        	db_in.sin_family=AF_INET;
        	db_in.sin_port = dbInPort;
        	db_in.sin_addr.s_addr = inet_addr("127.0.0.1");
		sendto (TrustDB_in, &send_msg, sizeof(struct shm_form), 0, 
			(struct sockaddr *)&db_in, sizeof(db_in));
	}
}


void MainLoop(void)
{
	int	n;
	int	len,width, pid;
	fd_set	readOk,Mask;
	struct	timeval	timeout;
	char	client[64];

	DB(fprintf(stderr,"MainLoop\n"));

	FD_ZERO(&Mask);
	FD_SET(TrustDB_out, &Mask);
	FD_SET(0, &Mask);
	width = TrustDB_out;
	width += 1;

	while(1){
		readOk = Mask;
		timeout.tv_sec = 1;
		timeout.tv_usec = 0;
		switch (select(width,(fd_set *)&readOk, NULL, NULL, &timeout)){
			case	-1:
				perror("select");
				break;
			case	0:
				break;
			default:
				if (FD_ISSET(TrustDB_out, &readOk)) {
					CheckEntry();
				}
				if(FD_ISSET(0,&readOk)){
					KeyIn();
				}
				break;
		}
	}
}

int KeyIn(void)
{
	char	buf[128];

	fgets(buf, sizeof(buf), stdin);

	DoKeyInCommand(buf);

	return(0);
}

int DoKeyInCommand(char *str)
{
	int	k, n;

	k = strlen(str);
	for (n = 0 ; n < k ; n++)
	{	
		if (str[n] == 0x0a) str[n] = 0x00;
		if (str[n] == 0x0d) str[n] = 0x00;
	}

	DB(fprintf(stderr,"(%s)\n",str));

	if (strlen(str))
	{
		if((strncmp(str,"end", strlen(str))==0) 
			|| strncmp(str, "exit", strlen(str)) == 0){
			killpg(getpid(),SIGTERM);
			CloseSocket();
			return(1);
		}
	}

	return(0);
}

