/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin;

import net.morilib.awk.builtin.a.AwkArrayBuiltInLoader;
import net.morilib.awk.builtin.mat.AwkMatBuiltInLoader;
import net.morilib.awk.builtin.rel.AwkRelBuiltInLoader;
import net.morilib.awk.builtin.s.AwkStrBuiltInLoader;
import net.morilib.awk.builtin.stat.AwkStatBuiltInLoader;
import net.morilib.awk.builtin.t.AwkTBuiltInLoader;
import net.morilib.awk.builtin.util.AwkUtilBuiltInLoader;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;

/**
 * 関数をロードするためのクラスです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkBuiltInLoader {

	/**
	 * 関数を名前空間にロードします。
	 * 
	 * @param ns 名前空間
	 */
	public static void load(AwkNamespace ns) {
		ns.assign("FS", AwkString.valueOf(" "));
		ns.assign("RS", AwkString.valueOf("\n"));
		ns.assign("OFS", AwkString.valueOf(" "));
		ns.assign("ORS", AwkString.valueOf("\n"));
		ns.assign("SUBSEP", AwkString.valueOf("\u001d"));
		ns.assign("OFMT", AwkString.valueOf("%.6g"));

		ns.bindFunction("gsub", new AwkGsub());
		ns.bindFunction("index", new AwkIndex());
		ns.bindFunction("length", new AwkLength());
		ns.bindFunction("match", new AwkMatch());
		ns.bindFunction("sprintf", new AwkSprintf());
		ns.bindFunction("sub", new AwkSub());
		ns.bindFunction("substr", new AwkSubstr());

		ns.bindFunction("atan2", new AwkAtan2());
		ns.bindFunction("cos", new AwkCos());
		ns.bindFunction("exp", new AwkExp());
		ns.bindFunction("int", new AwkInt());
		ns.bindFunction("log", new AwkLog());
		ns.bindFunction("rand", new AwkRand());
		ns.bindFunction("sin", new AwkSin());
		ns.bindFunction("sqrt", new AwkSqrt());
		ns.bindFunction("srand", new AwkSrand());
		ns.bindFunction("tan", new AwkTan());

		ns.bindFunction("system", new AwkSystem());

		AwkStatBuiltInLoader.load(ns);
		AwkArrayBuiltInLoader.load(ns);
		AwkRelBuiltInLoader.load(ns);
		AwkMatBuiltInLoader.load(ns);
		AwkStrBuiltInLoader.load(ns);
		AwkUtilBuiltInLoader.load(ns);
		AwkTBuiltInLoader.load(ns);
	}

}
