/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.mat;

import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.matrix.DoubleMatrix;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 関数mat.detの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/31
 */
public class MatDet extends AwkUnaryArgs {

	/**
	 * @param name
	 */
	protected MatDet() {
		super("det");
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.builtin.AwkUnaryArgs#apply(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles, net.morilib.awk.value.AwkValue)
	 */
	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		DoubleMatrix a;
		String sep;
		double r;

		sep = ns.getRoot().find(AwkMatrices.SUBSEP).toString(ns);
		if(!a1.isArray()) {
			return a1;
		} else if((a = AwkMatrices.toDoubleMatrix(a1, sep)) == null) {
			return AwkUndefined.UNDEF;
		} else {
			r = a.determinant();
			return AwkFloat.valueOf(r);
		}
	}

}
