/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.io;

import java.io.Closeable;
import java.io.IOException;

/**
 * 1行書き込みをあらわすインターフェースです。
 *
 * @author MORIGUCHI, Yuichiro 2013/04/02
 */
public interface LineWriter extends Closeable {

	/**
	 * 1行を改行なしで出力します。
	 * 
	 * @param s 出力する行
	 * @throws IOException
	 */
	public void print(String s);

	/**
	 * 1行を改行つきで出力します。
	 * 
	 * @param s 出力する行
	 * @throws IOException
	 */
	public void println(String s);

	/**
	 * 1行を書式を指定して出力します。
	 * 
	 * @param format 書式
	 * @param args 書式の引数
	 * @throws IOException
	 */
	public void printf(String format, Object... args);

	/**
	 * フラッシュします。
	 * 
	 * @throws IOException
	 */
	public void flush();

	/**
	 * ファイルを閉じます。
	 */
	public void close() throws IOException;

}
