/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class AwkArrayTest extends AwkTestCase {

	public void testArray001() {
		eqi("a[1] = 2;", 2);
		eqi("a[1];", 2);
		eqs("a[\"aaa\"] = \"bbb\";", "bbb");
		eqs("a[\"aaa\"];", "bbb");
	}

	public void testArray002() {
		eqi("a[2,2] = 3;", 3);
		eqi("a[2,2];", 3);
		eqi("a[3,2,1] = 4;", 4);
		eqi("a[3,2,1];", 4);
	}

	public void testArray003() {
		eqi("a[1,1] = 3;", 3);
		eqi("a[1,2] = 3;", 3);
		eqi("a[2,1] = 3;", 3);
		eqi("a[2,2] = 3;", 3);
	}

	public void testArray004() {
		exe("SUBSEP = \",\"");
		eqi("a[2,2] = 3;", 3);
		eqi("a[\"2,2\"];", 3);
		eqi("a[3,2,1] = 4;", 4);
		eqi("a[\"3,2,1\"];", 4);
		eqi("a[\"2,3\"] = 5;", 5);
		eqi("a[2,3];", 5);
		eqi("a[\"3,2,2\"] = 6;", 6);
		eqi("a[3,2,2] = 6;", 6);
	}

	public void testArray005() {
		eqi("a[1] = 2;", 2);
		eqb("1 in a;", true);
		eqb("2 in a;", false);
	}

	public void testArray006() {
		exe("SUBSEP = \",\"");
		eqi("a[1,2] = 2;", 2);
		eqb("(1,2) in a;", true);
		eqb("(1,1) in a;", false);
		eqb("(2,2) in a;", false);
		eqb("\"1,2\" in a;", true);
	}

	public void testForIn() {
		eqi("a[1] = 7;", 7);
		eqi("a[2] = 6;", 6);
		eqi("a[3] = 5;", 5);
		eqi("a[4] = 4;", 4);
		eqi("a[5] = 3;", 3);
		exe("for(i in a)  b = b i;");
		eqs("b;", "76543");
		exe("for(i = 1; i < 4; i++)\nfor(j = 1; j < 4; j++)\nc[i,j]=i*j;");
		eqi("c[1,1];", 1);  eqi("c[1,2];", 2);  eqi("c[1,3];", 3);
		eqi("c[2,1];", 2);  eqi("c[2,2];", 4);  eqi("c[2,3];", 6);
		eqi("c[3,1];", 3);  eqi("c[3,2];", 6);  eqi("c[3,3];", 9);
	}

	public void testDelete01() {
		eqi("a[1] = 2", 2);
		eqi("a[2] = 2", 2);
		eqi("a[3] = 2", 2);
		exe("delete a[1]");
		und("a[1]");
		eqi("a[2]", 2);
		eqi("a[3]", 2);
	}

	public void testDelete02() {
		eqi("a[1,2] = 2", 2);
		eqi("a[2,1] = 2", 2);
		eqi("a[2,2] = 2", 2);
		exe("delete a[1,2]");
		und("a[1,2]");
		eqi("a[2,1]", 2);
		eqi("a[2,2]", 2);
	}

}
