/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class AwkExpressionTest extends AwkTestCase {

	public void testIncdec() {
		eqi("a++", 0);  eqz("a", 1);
		eqi("a++", 1);  eqz("a", 2);
		eqi("++a", 3);  eqz("a", 3);
		eqi("a--", 3);  eqz("a", 2);
		eqi("--a", 1);  eqz("a", 1);
		eqf("a = 1.5", 1.5);
		eqf("a++", 1.5);  eqz("a", 2.5);
		eqf("++a", 3.5);  eqz("a", 3.5);
		eqf("a--", 3.5);  eqz("a", 2.5);
		eqf("--a", 1.5);  eqz("a", 1.5);
		eqs("a = \"1\"", "1");
		eqs("a++", "1");  eqz("a", 2);
		eqs("a = \"1\"", "1");
		eqi("++a", 2);  eqz("a", 2);
		eqs("a = \"1.5\"", "1.5");
		eqs("a++", "1.5");  eqz("a", 2.5);
		eqs("a = \"1.5\"", "1.5");
		eqf("++a", 2.5);  eqz("a", 2.5);
		eqs("a = \"1\"", "1");
		eqs("a--", "1");  eqz("a", 0);
		eqs("a = \"1\"", "1");
		eqi("--a", 0);  eqz("a", 0);
		eqs("a = \"1.5\"", "1.5");
		eqs("a--", "1.5");  eqz("a", 0.5);
		eqs("a = \"1.5\"", "1.5");
		eqf("--a", 0.5);  eqz("a", 0.5);
		eqf("b++", 0);  eqz("b", 1);
		eqf("++c", 1);  eqz("c", 1);
		eqf("d--", 0);  eqz("d", -1);
		eqf("--e", -1);  eqz("e", -1);
	}

	public void testPow() {
		eqi("2^4", 16);
		eqi("2^3^2", 512);
		eqi("-2^4", -16);
	}

	public void testUnaries() {
		eqi("-1", -1);
		eqi("+1",  1);
		eqi("!0",  1);
		eqi("-1+2", 1);
	}

	public void testId() {
		eqi("1", 1);
		eqf("3.0", 3.0);
		eqs("\"aaa\"", "aaa");
		eqs("\"\"", "");
		eqr("/aaa/", "aaa");
		eqr("/=v=/", "=v=");
		eqr("/   /", "   ");
		eqr("//", "");
	}

	public void testId2() {
		eqi("\"765production\"", 765);
		eqf("\"72.0cm\"", 72.0);
		eqf("\".72e1\"", 7.2);
		eqf("\"0.72e1\"", 7.2);
		eqf("\"72e1\"", 720);
		eqf("\"72e+1\"", 720);
		eqf("\"72e-1\"", 7.2);
		eqf("\"72e\"", 72.0);
		eqf("\"72\"", 72.0);
		eqi("\"+72\"", 72);
		eqf("\"+72\"", 72.0);
		eqf("\"+72e1\"", 720);
		eqf("\"+72e+1\"", 720);
		eqf("\"+72e-1\"", 7.2);
		eqf("\"+72e\"", 72.0);
		eqf("\"+72\"", 72.0);
		eqi("\"-72\"", -72);
		eqf("\"-72\"", -72.0);
		eqf("\"-72e1\"", -720);
		eqf("\"-72e+1\"", -720);
		eqf("\"-72e-1\"", -7.2);
		eqf("\"-72e\"", -72.0);
		eqf("\"-72\"", -72.0);
		eqf("\".\"", 0);
		eqf("\"1.\"", 1);
		eqf("\"1.1\"", 1.1);
		eqf("\"1.e\"", 1);
		eqi("\"i\"", 0);
		eqf("\"a\"", 0);
	}

	public void testFactor() {
		eqi("2*3", 6);
		eqi("2*3*4", 24);
		eqi("5%3", 2);
		eqi("4/2", 2);
		eqi("24/4/3", 2);
		eqi("24/4*3", 18);
		eqi("5%3%2", 0);
		eqf("2*3.0", 6.0);
		eqf("4/2.0", 2.0);
		eqi("2*\"3\"", 6);
		eqi("4/\"2\"", 2);
		eqi("5%\"3\"", 2);
		eqf("2*\"3.0\"", 6.0);
		eqf("4/\"2.0\"", 2.0);
		eqf("3/2", 1.5);
	}

	public void testTerm() {
		eqi("3+2", 5);
		eqi("3-2", 1);
		eqi("3-2-1", 0);
		eqi("3-2+1", 2);
		eqi("3*5+18/3", 21);
		eqf("3+2.0", 5.0);
		eqf("3-2.0", 1.0);
		eqi("3+\"2\"", 5);
		eqi("3-\"2\"", 1);
		eqf("3+\"2.0\"", 5.0);
		eqf("3-\"2.0\"", 1.0);
	}

	public void testConcat() {
		eqs("\"1\" \"2\"", "12");
		eqs("\"1\" \"2\" \"3\"", "123");
		eqs("1 + 2 \"2\"", "32");
		eqs("1 + 2 \".\" 7 * 2", "3.14");
		eqs("1 2", "12");
		eqs("1.0 2.0", "1.000002.00000");
	}

	public void testRelop() {
		eqi("7 >  2", 1);
		eqi("7 >= 2", 1);
		eqi("7 <  2", 0);
		eqi("7 <= 2", 0);
		eqi("7 == 2", 0);
		eqi("7 != 2", 1);
		eqi("7 >  7", 0);
		eqi("7 >= 7", 1);
		eqi("7 <  7", 0);
		eqi("7 <= 7", 1);
		eqi("7 == 7", 1);
		eqi("7 != 7", 0);
		eqi("7 >  8", 0);
		eqi("7 >= 8", 0);
		eqi("7 <  8", 1);
		eqi("7 <= 8", 1);
		eqi("7 == 8", 0);
		eqi("7 != 8", 1);
		eqi("\"aa\" >  \"ab\"", 0);
		eqi("\"aa\" >= \"ab\"", 0);
		eqi("\"aa\" <  \"ab\"", 1);
		eqi("\"aa\" <= \"ab\"", 1);
		eqi("\"aa\" == \"ab\"", 0);
		eqi("\"aa\" != \"ab\"", 1);
		eqi("\"aa\" >  \"aa\"", 0);
		eqi("\"aa\" >= \"aa\"", 1);
		eqi("\"aa\" <  \"aa\"", 0);
		eqi("\"aa\" <= \"aa\"", 1);
		eqi("\"aa\" == \"aa\"", 1);
		eqi("\"aa\" != \"aa\"", 0);
		eqi("\"ab\" >  \"aa\"", 1);
		eqi("\"ab\" >= \"aa\"", 1);
		eqi("\"ab\" <  \"aa\"", 0);
		eqi("\"ab\" <= \"aa\"", 0);
		eqi("\"ab\" == \"aa\"", 0);
		eqi("\"ab\" != \"aa\"", 1);
		eqi("7 >  2.0", 1);
		eqi("7 >= 2.0", 1);
		eqi("7 <  2.0", 0);
		eqi("7 <= 2.0", 0);
		eqi("7 == 2.0", 0);
		eqi("7 != 2.0", 1);
		eqi("7 >  7.0", 0);
		eqi("7 >= 7.0", 1);
		eqi("7 <  7.0", 0);
		eqi("7 <= 7.0", 1);
		eqi("7 == 7.0", 1);
		eqi("7 != 7.0", 0);
		eqi("7 >  8.0", 0);
		eqi("7 >= 8.0", 0);
		eqi("7 <  8.0", 1);
		eqi("7 <= 8.0", 1);
		eqi("7 == 8.0", 0);
		eqi("7 != 8.0", 1);
		eqi("72 >  \"8\"", 0);
		eqi("72 >= \"8\"", 0);
		eqi("72 <  \"8\"", 1);
		eqi("72 <= \"8\"", 1);
		eqi("72 == \"8\"", 0);
		eqi("72 != \"8\"", 1);
		eqi("8  >  \"72\"", 1);
		eqi("8  >= \"72\"", 1);
		eqi("8  <  \"72\"", 0);
		eqi("8  <= \"72\"", 0);
		eqi("8  == \"72\"", 0);
		eqi("8  != \"72\"", 1);
		eqi("72 >  \"72\"", 0);
		eqi("72 >= \"72\"", 1);
		eqi("72 <  \"72\"", 0);
		eqi("72 <= \"72\"", 1);
		eqi("72 == \"72\"", 1);
		eqi("72 != \"72\"", 0);
		eqi("1+6 >  2", 1);
		eqi("1+6 >= 2", 1);
		eqi("1+6 <  2", 0);
		eqi("1+6 <= 2", 0);
		eqi("1+6 == 2", 0);
		eqi("1+6 != 2", 1);
		eqi("72 >  \"7\" \"2\"", 0);
		eqi("72 >= \"7\" \"2\"", 1);
		eqi("72 <  \"7\" \"2\"", 0);
		eqi("72 <= \"7\" \"2\"", 1);
		eqi("72 == \"7\" \"2\"", 1);
		eqi("72 != \"7\" \"2\"", 0);
	}

	public void testMatchop() {
		eqi("\"aaa\" ~  /a+/", 1);
		eqi("\"aaa\" !~ /a+/", 0);
		eqi("\"bbb\" ~  /a+/", 0);
		eqi("\"bbb\" !~ /a+/", 1);
		eqi("111 ~  /1+/", 1);
		eqi("111 !~ /1+/", 0);
		eqi("111.0 ~  /1+/", 1);
		eqi("111.0 !~ /1+/", 0);
		eqi("\"bb\" \"a\" ~  /a+/", 1);
		eqi("\"bb\" \"b\" !~ /a+/", 1);

		eqi("\"aaa\" ~  \"a+\"", 1);
		eqi("111 ~  11", 1);
	}

	public void testLogand() {
		eqi("1 && 1", 1);
		eqi("0 && 1", 0);
		eqi("1 && 0", 0);
		eqi("0 && 0", 0);
		eqi("\"0\" && \"0\"", 1);
		eqi("\"\"  && \"0\"", 0);
		eqi("\"0\" && \"\"",  0);
		eqi("\"\"  && \"\"",  0);
		eqi("2 + 0 && 1 + 3", 1);
		eqi("2 == 2 && 1 == 1", 1);
		eqi("2 != 2 && 1 == 1", 0);
		eqi("2 == 2 && 1 != 1", 0);
		eqi("2 != 2 && 1 != 1", 0);
		eqi("1 && 1 && 0", 0);
		eqi("1 && 1 && 1", 1);
	}

	public void testLogor() {
		eqi("1 || 1", 1);
		eqi("0 || 1", 1);
		eqi("1 || 0", 1);
		eqi("0 || 0", 0);
		eqi("\"0\" || \"0\"", 1);
		eqi("\"\"  || \"0\"", 1);
		eqi("\"0\" || \"\"",  1);
		eqi("\"\"  || \"\"",  0);
		eqi("2 + 0 || 1 + 3", 1);
		eqi("2 == 2 || 1 == 1", 1);
		eqi("2 != 2 || 1 == 1", 1);
		eqi("2 == 2 || 1 != 1", 1);
		eqi("2 != 2 || 1 != 1", 0);
		eqi("0 || 0 || 0", 0);
		eqi("1 || 0 || 0", 1);
		eqi("1 && 1 || 1 && 0", 1);
	}

	public void testCond() {
		eqi("1 ? 3 : 4", 3);
		eqi("0 ? 3 : 4", 4);
		eqi("1 ? 3 + 4 : 4 + 8", 7);
		eqi("0 ? 3 + 4 : 4 + 5", 9);
		eqi("1 ? 1 || 1 : 0 || 0", 1);
		eqi("0 ? 1 || 1 : 0 || 0", 0);
	}

	public void testAssignop() {
		eqi("a  = 1", 1);  eqz("a", 1);
		eqi("a += 3", 4);  eqz("a", 4);
		eqi("a -= 2", 2);  eqz("a", 2);
		eqi("a *= 3", 6);  eqz("a", 6);
		eqi("a /= 2", 3);  eqz("a", 3);
	}

}
