// AXL3 - An XLL Library
// Wrapper class library for Microsft Excel's xll add-in which written by C++.
//
// Copyright(c) 2009-2009, yukimi_sake@users.sourceforge.jp. All rights reserved.

#pragma once
#include <tchar.h>

namespace xl{
	class xlVar;
	class xlSheet;
	static BOOL CALLBACK EnumProc(HWND hwnd, LPARAM * pEnum){
		TCHAR rgsz[50];
		GetClassName(hwnd, rgsz, 50);
		if (!lstrcmpi(rgsz, _T("XLMAIN"))){
			if  (LOWORD(*pEnum) == LOWORD(hwnd)){
				*pEnum = (LPARAM)hwnd;
				return FALSE;
			}
		}
		return TRUE;
	}

	class xlmFuncs{
	//// A singleton class that wraps Excel Macros directly. ////

	private:
		xlmFuncs(){};

	public:
		static xlmFuncs& Instance(){ static xlmFuncs x; return x; }
		
	// Utils
		int Alert(const char* c){
			return API.Call(xlcAlert, 0, "C", c);
		}

		int Alert(const xlVar& str){
			return API.Call(xlcAlert, 0, "P", &str);
		}

		int Quit(){
		// CAUTION : DO NOT USE this function in normal block, 
		//           otherwise you will get memory leaks.
		//           USE in "catch(...){}" section instead.

			return API.Call(xlcQuit, 0, 0);
		}

	// Events
		int OnDoubleclick(xlSheet& sheet, const xlVar& handler){
			return API.Call(xlcOnDoubleclick, 0,"PP", sheet.Name, &handler);
		}

		int OnDoubleclick(const char* sheetname, const char* handler){
			return API.Call(xlcOnDoubleclick, 0,"CC", sheetname, handler);
		}

		int OnEntry(const xlVar& sheetname, const xlVar& handler){
			return API.Call(xlcOnEntry, 0,"PP", &sheetname, &handler);
		}
		int OnEntry(const char* sheetname, const char* handler){
			return API.Call(xlcOnEntry, 0,"CC", sheetname, handler);
		}

		int OnKey(const xlVar& sheet, const xlVar handler){
			return API.Call(xlcOnKey, 0,"PP", sheet, handler);
		}
		int OnKey(const char* sheet, const char* handler){
			return API.Call(xlcOnKey, 0,"CC", sheet, handler);
		}

		int OnRecalc(const xlVar& sheet, const xlVar handler){
			return API.Call(xlcOnRecalc, 0,"PP", sheet, handler);
		}

		int OnRecalc(const char* sheet, const char* handler){
			return API.Call(xlcOnRecalc, 0,"CC", sheet, handler);
		}

		int OnSheet(const xlVar& sheet, const xlVar handler, const bool activate){
			return API.Call(xlcOnSheet, 0,"PPB", sheet, handler, activate);
		}

		int OnSheet(const char* sheet, const char* handler, const bool activate){
			return API.Call(xlcOnSheet, 0,"CCB", sheet, handler, activate);
		}

		int OnWindow(const xlVar& window, const xlVar handler){
			return API.Call(xlcOnWindow, 0,"PP", window, handler);
		}

		int OnWindow(const char* window, const char* handler){
			return API.Call(xlcOnWindow, 0,"CC", window, handler);
		}


	// Applications
		int ScreenUpdating(xlVar& on_off){
			return API.Call(xlcEcho, 0, "P", &on_off);
		}

		int ScreenUpdating(bool on_off){
			return API.Call(xlcEcho, 0, "B", on_off);
		}

		int Calculation(xlVar& state){
			return API.Call(xlcCalculation, 0, "P", &state);
		}

		int Calculation(int state){
			return API.Call(xlcCalculation, 0, "I", state);
		}

		HWND GetHwnd(){
			xlVar res;
			API.Call(xlGetHwnd, &res, 0);
			if (API.IsExcel12()) return (HWND)res.Int;
			LPARAM * enm = (LPARAM *)res.Int;
			EnumWindows((WNDENUMPROC)EnumProc, (LPARAM)&enm);
			return (HWND)enm;
		}

	// Windows
		int Zoom(xlVar& magnitude){
			return API.Call(xlcZoom, 0, "P", &magnitude);
		}

		int Zoom(double magnitude){
			return API.Call(xlcZoom, 0, "N", magnitude);
		}

	//  Options
/*
		void OptionsEdit(){
			xlVar incell_edit, drag_drop, alert, entermove, fixed, decimals, copy_objects, \
				    update_links, move_direction, autocomplete, animations;
			int r=API.Call(xlcOptionsEdit, 0, 1, incell_edit);
				//drag_drop, alert, entermove, fixed, decimals,\
				//                        copy_objects, update_links, move_direction, autocomplete,\
				//						animations);
		}
*/	

	// Ranges
		int Clear(int type_num){
			return API.Call(xlcClear, 0, "I", type_num);
		}
		
		int Delete(int shift){ 
			return API.Call(xlcEditDelete, 0, "I", shift);
		}

		int Select(xlRange& selection, xlRange& activeCell){
			return API.Call(xlcSelect,0, "PP", &selection, &activeCell);
		}

		int Select(xlRange& cell){
			return API.Call(xlcSelect, 0, "PP", &cell, &cell);
		}

		xlRange ActiveCell(){
			xlRange res; API.Call(xlfActiveCell, &res, 0); return xlRange(res);
		}
		
		xlRange Selection(){
			xlRange res; API.Call(xlfSelection, &res, 0); return xlRange(res); 
		}

		xlRange Caller(){ 
			xlRange res; API.Call(xlfCaller, &res, (int)0); return xlRange(res); 
		}

		int GetCell(xlVar *res, int type_num){
			return API.Call(xlfGetCell, res, "I", type_num);
		}

		int GetCell(xlVar *res, int type_num, xlRange& ref){
			return API.Call(xlfGetCell, res, "IP", type_num, &ref);
		}

		int GetDocument(xlVar *res, int type_num){
			return API.Call(xlfGetDocument, res, "I", type_num);
		}

		int GetDocument(xlVar *res, int type_num, xlVar* doc_name){
			return API.Call(xlfGetDocument, res, "IP", type_num, doc_name);
		}

		int GetWindow(xlVar *res, int type_num){
			return API.Call(xlfGetWindow, res, "I", type_num); 
		}

		int GetWindow(xlVar *res, int type_num, xlVar* wnd_name){
			return API.Call(xlfGetWindow, res, "IP", type_num, wnd_name); 
		}

		int GetWorkbook(xlVar *res, int type_num){
			return API.Call(xlfGetWorkbook, res, "I", type_num);
		}

		int GetWorkbook(xlVar *res, int type_num, xlVar* book_name){
			return API.Call(xlfGetWorkbook, res, "IP", type_num, book_name);
		}

		int GetWorkspace(xlVar *res, int type_num){
			return API.Call(xlfGetWorkspace, res, "I", type_num);
		}

	// Menus
		xlVar CountMenus(){
			xlVar res;
			API.Call(xlfGetBar, &res, 0);
			return xlVar(res); 
		}

		xlVar GetBar(const int bar_num, const char* menu, const int command=0){
			xlVar res;
			API.Call(xlfGetBar, &res, "ICI", bar_num, menu, command);
			return xlVar(res);
		}

		xlVar GetBar(const int bar_num, const char* menu, const char* command, const char* subcommand){
			xlVar res;
			API.Call(xlfGetBar, &res, "ICCC", bar_num, menu, command, subcommand);
			return xlVar(res);
		}
		
		xlVar AddMenu(const int bar_num, const xlVar& menus, const char* to_insert){
			xlVar res;
			API.Call(xlfAddMenu, &res, "IPC", bar_num, &menus, to_insert);
			return xlVar(res);
		}

		xlVar AddMenu(const int bar_num, const xlVar& menus){
			xlVar res;
			API.Call(xlfAddMenu, &res, "IP", bar_num, &menus);
			return xlVar(res);
		}

		int DeleteMenu(const int bar_num, const char* menu_name){
			return API.Call(xlfDeleteMenu, 0, "IC", bar_num, menu_name);
		}

		int DeleteMenu(const int bar_num, const char* menu_name, const char* submenu_name){
			return API.Call(xlfDeleteMenu, 0, "ICC", bar_num, menu_name, submenu_name);
		}

	// Cell formats
		int Border(
				const int outline, 
				const int left,
				const int right,
				const int top,
				const int bottom,
				//const bool shade, // ignored in Windows.
				const int outline_color,
				const int left_color,
				const int right_color,
				const int top_color,
				const int bottom_color
			)
		{
			return API.Call(xlcBorder, 0, "IIIII_IIIII",
					outline, left, right, top, bottom, outline_color, left_color, right_color, top_color, bottom_color);
		}

		int Patterns(int apattern, int afore, int aback){
			return API.Call(xlcPatterns, 0, "III", apattern, afore, aback);
		}

		int FontProperties(
				const char* font,
				const char* font_style,
				const double size,
				const bool strikethrough,
				const bool superscript,
				const bool subscript,
				//const bool outline,  // ignored in Windows.
				//const bool shadow,   // ignored in Windows.
				const int underline,
				const int color,
				const bool normal,
				const int background
			)
		{
			return API.Call(xlcFontProperties, 0, "CCNBBB__II",
				font, font_style, size, strikethrough, superscript, subscript, underline, color, normal, background);

		}

		int FormatText(
				const int x_align, 
				const int y_align, 
				const int orient_num, 
				const bool auto_text,
				const bool auto_size, 
				const bool show_key,
				const int show_value,
				const int add_indent
			)
		{
			return API.Call(xlcFormatText, 0, "IIIBBBII",x_align, y_align, orient_num, auto_text, auto_size, show_key, show_value, add_indent);
		}

	// GetCell wrapper functions


	// GetDocument wrapper functions

		xlVar GetActiveDocumentName(){xlVar res; GetDocument(&res, 1); return xlVar(res);}

		xlVar GetDocumentPath(xlVar book_name){xlVar res; GetDocument(&res, 2, &book_name); return xlVar(res);}

		xlVar GetActiveSheetName(){ xlVar res; GetDocument(&res, 76); return xlVar(res);}

		xlVar GetActiveBookName(){xlVar res; GetDocument(&res, 88); return xlVar(res);}

	// GetWindow wrapper functions

		xlVar GetWindowName(){ xlVar res; GetWindow(&res, 1); return xlVar(res);}

		xlVar CountWindows(){ xlVar res; GetWindow(&res, 2); return xlVar(res);}

		xlVar GetWindowXPos(){ xlVar res; GetWindow(&res, 3); return xlVar(res);}

		xlVar GetWindowYPos(){ xlVar res; GetWindow(&res, 4); return xlVar(res);}

		xlVar GetWindowWidth(){ xlVar res; GetWindow(&res, 5); return xlVar(res);}

		xlVar GetWindowHeight(){ xlVar res; GetWindow(&res, 6); return xlVar(res);}

		xlVar IsWindowHidden(){ xlVar res; GetWindow(&res, 7); return xlVar(res);}

		xlVar GetLeftColumnOfPanes(){ xlVar res; GetWindow(&res, 13); return xlVar(res);}

		xlVar GetTopRowOfPanes(){ xlVar res; GetWindow(&res, 14); return xlVar(res);}

		xlVar CountColumnsOfPanes(){ xlVar res; GetWindow(&res, 15); return xlVar(res);}

		xlVar CountRowsOfPanes(){ xlVar res; GetWindow(&res, 16); return xlVar(res);}

		xlVar GetActivePane(){ xlVar res; GetWindow(&res, 17); return xlVar(res);}

		xlVar IsVerticalSplitted(){ xlVar res; GetWindow(&res, 18); return xlVar(res);}

		xlVar IsHorizontalSplitted(){ xlVar res; GetWindow(&res, 19); return xlVar(res);}

		xlVar IsWindowMaximized(){ xlVar res; GetWindow(&res, 20); return xlVar(res);}

		xlVar IsOutlineShown(){ xlVar res; GetWindow(&res, 22); return xlVar(res);}

		xlVar GetWindowState(){ xlVar res; GetWindow(&res, 23); return xlVar(res);}
			// 1 = Restored
			// 2 = Minimized (displayed as an icon)
			// 3 = Maximized
	
		xlVar ArePanesFlozen(){ xlVar res; GetWindow(&res, 24); return xlVar(res); }

		xlVar GetZoom(){ xlVar res; GetWindow(&res, 25); return xlVar(res); }


	// GetWorkspace wrapper functions
		xlVar GetMoveAfterEnter(){ xlVar res; GetWorkspace(&res, 46); return xlVar(res); }

	};

	__declspec(selectany) xl::xlmFuncs XLM = xl::xlmFuncs::Instance();
}