/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.compiler;

import com.sun.btrace.BTraceUtils;
import com.sun.btrace.annotations.BTrace;
import com.sun.btrace.compiler.Verifier;
import com.sun.btrace.util.Messages;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.tools.Diagnostic;

public class VerifierVisitor
extends TreeScanner<Boolean, Void> {
    private Verifier verifier;
    private String className;
    private boolean insideMethod;
    private static volatile Method[] btraceMethods;

    public VerifierVisitor(Verifier verifier) {
        this.verifier = verifier;
    }

    @Override
    public Boolean visitMethodInvocation(MethodInvocationTree node, Void v) {
        String name;
        ExpressionTree methodSelect = node.getMethodSelect();
        if (methodSelect.getKind() == Tree.Kind.IDENTIFIER) {
            String name2 = ((IdentifierTree)methodSelect).getName().toString();
            int numArgs = 0;
            List<? extends ExpressionTree> args = node.getArguments();
            if (args != null) {
                numArgs = args.size();
            }
            if (name2.equals("super") || VerifierVisitor.isBTraceMethod(name2, numArgs)) {
                return (Boolean)super.visitMethodInvocation(node, v);
            }
        } else if (methodSelect.getKind() == Tree.Kind.MEMBER_SELECT && ((name = methodSelect.toString()).startsWith("BTraceUtils.") || name.startsWith("com.sun.btrace.BTraceUtils."))) {
            name = name.substring(name.lastIndexOf(".") + 1);
            int numArgs = 0;
            List<? extends ExpressionTree> args = node.getArguments();
            if (args != null) {
                numArgs = args.size();
            }
            if (VerifierVisitor.isBTraceMethod(name, numArgs)) {
                return (Boolean)super.visitMethodInvocation(node, v);
            }
        }
        return this.reportError("no.method.calls", node);
    }

    @Override
    public Boolean visitAssert(AssertTree node, Void v) {
        return this.reportError("no.asserts", node);
    }

    @Override
    public Boolean visitBinary(BinaryTree node, Void v) {
        if (node.getKind() == Tree.Kind.PLUS) {
            ExpressionTree left = node.getLeftOperand();
            ExpressionTree right = node.getRightOperand();
            if (left.getKind() == Tree.Kind.STRING_LITERAL || right.getKind() == Tree.Kind.STRING_LITERAL) {
                return this.reportError("no.string.concatenation", node);
            }
        }
        return (Boolean)super.visitBinary(node, v);
    }

    @Override
    public Boolean visitAssignment(AssignmentTree node, Void v) {
        if (this.checkLValue(node.getVariable())) {
            return (Boolean)super.visitAssignment(node, v);
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitCompoundAssignment(CompoundAssignmentTree node, Void v) {
        if (this.checkLValue(node.getVariable())) {
            return (Boolean)super.visitCompoundAssignment(node, v);
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitCatch(CatchTree node, Void v) {
        return this.reportError("no.catch", node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean visitClass(ClassTree node, Void v) {
        String string;
        if (this.insideMethod) {
            return this.reportError("no.local.class", node);
        }
        List<? extends Tree> members = node.getMembers();
        for (Tree tree : members) {
            VariableTree vt;
            boolean isStatic;
            if (tree.getKind() == Tree.Kind.CLASS) {
                return this.reportError("no.nested.class", tree);
            }
            if (tree.getKind() != Tree.Kind.VARIABLE || (isStatic = this.isStatic((vt = (VariableTree)tree).getModifiers().getFlags()))) continue;
            return this.reportError("no.instance.variables", tree);
        }
        Tree superClass = node.getExtendsClause();
        if (superClass != null && !(string = superClass.toString()).equals("Object") && !string.equals("java.lang.Object")) {
            return this.reportError("object.superclass.required", superClass);
        }
        List<? extends Tree> list = node.getImplementsClause();
        if (list != null && list.size() > 0) {
            return this.reportError("no.interface.implementation", list.get(0));
        }
        ModifiersTree mt = node.getModifiers();
        if (!this.isPublic(mt.getFlags())) {
            return this.reportError("class.should.be.public", node);
        }
        List<? extends AnnotationTree> anno = mt.getAnnotations();
        if (anno == null || anno.isEmpty()) {
            return this.reportError("not.a.btrace.program", node);
        }
        String btrace = BTrace.class.getName();
        for (AnnotationTree annotationTree : anno) {
            String name2 = annotationTree.getAnnotationType().toString();
            if (!name2.equals(btrace) && !name2.equals("BTrace")) continue;
            String oldClassName = this.className;
            try {
                this.className = node.getSimpleName().toString();
                Boolean bl = (Boolean)super.visitClass(node, v);
                return bl;
            }
            finally {
                this.className = oldClassName;
            }
        }
        return this.reportError("not.a.btrace.program", node);
    }

    @Override
    public Boolean visitDoWhileLoop(DoWhileLoopTree node, Void v) {
        return this.reportError("no.do.while", node);
    }

    @Override
    public Boolean visitEnhancedForLoop(EnhancedForLoopTree node, Void v) {
        return this.reportError("no.enhanced.for", node);
    }

    @Override
    public Boolean visitForLoop(ForLoopTree node, Void v) {
        return this.reportError("no.for.loop", node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean visitMethod(MethodTree node, Void v) {
        boolean oldInsideMethod = this.insideMethod;
        this.insideMethod = true;
        try {
            Name name = node.getName();
            if (name.contentEquals("<init>")) {
                Boolean bl = (Boolean)super.visitMethod(node, v);
                return bl;
            }
            Set<Modifier> flags = node.getModifiers().getFlags();
            boolean isStatic = this.isStatic(flags);
            if (isStatic) {
                boolean isPublic = this.isPublic(node.getModifiers().getFlags());
                if (isPublic) {
                    if (this.isSynchronized(flags)) {
                        Boolean bl = this.reportError("no.synchronized.methods", node);
                        return bl;
                    }
                    Boolean bl = (Boolean)super.visitMethod(node, v);
                    return bl;
                }
                Boolean bl = this.reportError("method.should.be.public", node);
                return bl;
            }
            Boolean bl = this.reportError("no.instance.method", node);
            return bl;
        }
        finally {
            this.insideMethod = oldInsideMethod;
        }
    }

    @Override
    public Boolean visitNewArray(NewArrayTree node, Void v) {
        return this.reportError("no.array.creation", node);
    }

    @Override
    public Boolean visitNewClass(NewClassTree node, Void v) {
        return this.reportError("no.new.object", node);
    }

    @Override
    public Boolean visitReturn(ReturnTree node, Void v) {
        if (node.getExpression() != null) {
            return this.reportError("return.type.should.be.void", node);
        }
        return (Boolean)super.visitReturn(node, v);
    }

    @Override
    public Boolean visitMemberSelect(MemberSelectTree node, Void v) {
        if (node.getIdentifier().contentEquals("class")) {
            return this.reportError("no.class.literals", node);
        }
        return (Boolean)super.visitMemberSelect(node, v);
    }

    @Override
    public Boolean visitSynchronized(SynchronizedTree node, Void v) {
        return this.reportError("no.synchronized.blocks", node);
    }

    @Override
    public Boolean visitThrow(ThrowTree node, Void v) {
        return this.reportError("no.throw", node);
    }

    @Override
    public Boolean visitTry(TryTree node, Void v) {
        return this.reportError("no.try", node);
    }

    @Override
    public Boolean visitWhileLoop(WhileLoopTree node, Void v) {
        return this.reportError("no.while.loop", node);
    }

    @Override
    public Boolean visitOther(Tree node, Void v) {
        return this.reportError("no.other", node);
    }

    private boolean isStatic(Set<Modifier> modifiers) {
        for (Modifier m : modifiers) {
            if (m != Modifier.STATIC) continue;
            return true;
        }
        return false;
    }

    private boolean isSynchronized(Set<Modifier> modifiers) {
        for (Modifier m : modifiers) {
            if (m != Modifier.SYNCHRONIZED) continue;
            return true;
        }
        return false;
    }

    private boolean isPublic(Set<Modifier> modifiers) {
        for (Modifier m : modifiers) {
            if (m != Modifier.PUBLIC) continue;
            return true;
        }
        return false;
    }

    private boolean checkLValue(Tree variable) {
        if (variable.getKind() == Tree.Kind.ARRAY_ACCESS) {
            this.reportError("no.assignment", variable);
            return false;
        }
        if (variable.getKind() != Tree.Kind.IDENTIFIER) {
            if (this.className != null) {
                String name = variable.toString();
                if (!this.className.equals(name = name.substring(0, name.lastIndexOf(".")))) {
                    this.reportError("no.assignment", variable);
                    return false;
                }
            } else {
                this.reportError("no.assignment", variable);
                return false;
            }
        }
        return true;
    }

    private static boolean isBTraceMethod(String name, int numArgs) {
        VerifierVisitor.initBTraceMethods();
        for (Method m : btraceMethods) {
            if (!m.getName().equals(name) || m.getParameterTypes().length != numArgs) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initBTraceMethods() {
        if (btraceMethods != null) return;
        Class<VerifierVisitor> clazz = VerifierVisitor.class;
        synchronized (VerifierVisitor.class) {
            if (btraceMethods != null) return;
            btraceMethods = BTraceUtils.class.getDeclaredMethods();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private Boolean reportError(String msg, Tree node) {
        SourcePositions srcPos = this.verifier.getSourcePositions();
        CompilationUnitTree compUnit = this.verifier.getCompilationUnit();
        if (compUnit != null) {
            long pos = srcPos.getStartPosition(compUnit, node);
            long line = compUnit.getLineMap().getLineNumber(pos);
            String name = compUnit.getSourceFile().getName();
            msg = String.format("%s:%d:%s", name, line, Messages.get(msg));
            this.verifier.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        } else {
            this.verifier.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        }
        return Boolean.FALSE;
    }
}

