package cerot.blight.btrace;

/**
 * メソッドリターンのモデルクラス。
 * @author cero-t
 * 
 */
public class MethodReturn extends MethodExpression {
	/** 戻り値のクラス */
	private String returnType;

	/** 戻り値 */
	private String returnValue;

	/**
	 * 戻り値のクラスを取得します。
	 * @return 戻り値のクラス
	 */
	public String getReturnType() {
		return this.returnType;
	}

	/**
	 * 戻り値のクラスを設定します。
	 * @param returnType 戻り値のクラス
	 */
	public void setReturnType(String returnType) {
		this.returnType = returnType;
	}

	/**
	 * 戻り値を取得します。
	 * @return 戻り値
	 */
	public String getReturnValue() {
		return this.returnValue;
	}

	/**
	 * 戻り値を設定します。
	 * @param returnValue 戻り値
	 */
	public void setReturnValue(String returnValue) {
		this.returnValue = returnValue;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("timestamp=" + this.getTimestamp());
		builder.append(",className=" + this.getClassName());
		builder.append(",methodName=" + this.getMethodName());
		builder.append(",returnValue=" + this.getReturnType());
		builder.append(",returnType=" + this.getReturnValue());
		return new String(builder);
	}
}
