/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.descriptor;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.descriptor.MutableBodyDescriptor;
import org.apache.james.mime4j.util.MimeUtil;

public class DefaultBodyDescriptor
implements MutableBodyDescriptor {
    private static final String US_ASCII = "us-ascii";
    private static final String SUB_TYPE_EMAIL = "rfc822";
    private static final String MEDIA_TYPE_TEXT = "text";
    private static final String MEDIA_TYPE_MESSAGE = "message";
    private static final String EMAIL_MESSAGE_MIME_TYPE = "message/rfc822";
    private static final String DEFAULT_SUB_TYPE = "plain";
    private static final String DEFAULT_MEDIA_TYPE = "text";
    private static final String DEFAULT_MIME_TYPE = "text/plain";
    private static Log log = LogFactory.getLog((Class)DefaultBodyDescriptor.class);
    private String mediaType = "text";
    private String subType = "plain";
    private String mimeType = "text/plain";
    private String boundary = null;
    private String charset = "us-ascii";
    private String transferEncoding = "7bit";
    private Map parameters = new HashMap();
    private boolean contentTypeSet;
    private boolean contentTransferEncSet;
    private long contentLength = -1L;

    public DefaultBodyDescriptor() {
        this(null);
    }

    public DefaultBodyDescriptor(BodyDescriptor parent) {
        if (parent != null && MimeUtil.isSameMimeType("multipart/digest", parent.getMimeType())) {
            this.mimeType = EMAIL_MESSAGE_MIME_TYPE;
            this.subType = SUB_TYPE_EMAIL;
            this.mediaType = MEDIA_TYPE_MESSAGE;
        } else {
            this.mimeType = DEFAULT_MIME_TYPE;
            this.subType = DEFAULT_SUB_TYPE;
            this.mediaType = "text";
        }
    }

    public void addField(String name, String value) {
        if ((name = name.trim().toLowerCase()).equals("content-transfer-encoding") && !this.contentTransferEncSet) {
            this.contentTransferEncSet = true;
            if ((value = value.trim().toLowerCase()).length() > 0) {
                this.transferEncoding = value;
            }
        } else if (name.equals("content-length") && this.contentLength != -1L) {
            try {
                this.contentLength = Long.parseLong(value.trim());
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid content-length: " + value));
            }
        } else if (name.equals("content-type") && !this.contentTypeSet) {
            this.parseContentType(value);
        }
    }

    private void parseContentType(String value) {
        this.contentTypeSet = true;
        Map params = MimeUtil.getHeaderParams(value);
        String main = (String)params.get("");
        String type = null;
        String subtype = null;
        if (main != null) {
            main = main.toLowerCase().trim();
            int index = main.indexOf(47);
            boolean valid = false;
            if (index != -1) {
                type = main.substring(0, index).trim();
                subtype = main.substring(index + 1).trim();
                if (type.length() > 0 && subtype.length() > 0) {
                    main = type + "/" + subtype;
                    valid = true;
                }
            }
            if (!valid) {
                main = null;
                type = null;
                subtype = null;
            }
        }
        String b = (String)params.get("boundary");
        if (main != null && (main.startsWith("multipart/") && b != null || !main.startsWith("multipart/"))) {
            this.mimeType = main;
            this.subType = subtype;
            this.mediaType = type;
        }
        if (MimeUtil.isMultipart(this.mimeType)) {
            this.boundary = b;
        }
        String c = (String)params.get("charset");
        this.charset = null;
        if (c != null && (c = c.trim()).length() > 0) {
            this.charset = c.toLowerCase();
        }
        if (this.charset == null && "text".equals(this.mediaType)) {
            this.charset = US_ASCII;
        }
        this.parameters.putAll(params);
        this.parameters.remove("");
        this.parameters.remove("boundary");
        this.parameters.remove("charset");
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public String getCharset() {
        return this.charset;
    }

    public Map getContentTypeParameters() {
        return this.parameters;
    }

    public String getTransferEncoding() {
        return this.transferEncoding;
    }

    public String toString() {
        return this.mimeType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getSubType() {
        return this.subType;
    }
}

