package cerot.tools.taskmine.converter;

import cerot.tools.taskcoach.entity.Task;
import junit.framework.TestCase;

/**
 * TaskCoachConverterのテストクラス。
 * @author cero-t
 * 
 */
public class TaskConverterTest extends TestCase {
	/**
	 * toNormalHoursのテストケース。
	 */
	public void testToNormalHours() {
		assertEquals("0.25", TaskConverter.toNormalHours(15 * 60 * 1000));
		assertEquals("0.50", TaskConverter.toNormalHours(30 * 60 * 1000));
		assertEquals("0.75", TaskConverter.toNormalHours(45 * 60 * 1000));
		assertEquals("1.00", TaskConverter.toNormalHours(67 * 60 * 1000));
		assertEquals("1.25", TaskConverter.toNormalHours(68 * 60 * 1000));
		assertEquals("1.50", TaskConverter.toNormalHours(97 * 60 * 1000));
		assertEquals("1.75", TaskConverter.toNormalHours(98 * 60 * 1000));
		assertEquals("1.25", TaskConverter.toNormalHours(75 * 60 * 1000));
		assertEquals("1.50", TaskConverter.toNormalHours(97 * 60 * 1000));
		assertEquals("1.75", TaskConverter.toNormalHours(98 * 60 * 1000));
		assertEquals("2.00", TaskConverter.toNormalHours(113 * 60 * 1000));
		assertEquals("12.00", TaskConverter.toNormalHours(720 * 60 * 1000));
	}

	/**
	 * extractIssueIdのテストケース。
	 */
	public void testExtractIssueId() {
		Task task = new Task();

		task.subject = "#123テスト";
		assertEquals(Integer.valueOf(123), TaskConverter.extractIssueId(task));

		task.subject = "#123 テスト";
		assertEquals(Integer.valueOf(123), TaskConverter.extractIssueId(task));

		task.subject = "#123";
		assertEquals(Integer.valueOf(123), TaskConverter.extractIssueId(task));

		task.subject = "a#123";
		assertEquals(null, TaskConverter.extractIssueId(task));

		task.subject = "#123";
		task.description = "refs #456";
		assertEquals(Integer.valueOf(123), TaskConverter.extractIssueId(task));

		task.subject = null;
		assertEquals(Integer.valueOf(456), TaskConverter.extractIssueId(task));

		task.description = "refs #456テスト";
		assertEquals(Integer.valueOf(456), TaskConverter.extractIssueId(task));

		task.description = "refs #456 テスト";
		assertEquals(Integer.valueOf(456), TaskConverter.extractIssueId(task));

		task.description = "arefs #456";
		assertEquals(Integer.valueOf(456), TaskConverter.extractIssueId(task));

		task.description = "refs#456";
		assertEquals(null, TaskConverter.extractIssueId(task));
	}
}
