/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.compiler;

import com.sun.btrace.compiler.VerifierVisitor;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class Verifier
extends AbstractProcessor
implements TaskListener {
    private List<String> classNames = new ArrayList<String>();
    private Trees treeUtils;
    private List<CompilationUnitTree> compUnits = new ArrayList<CompilationUnitTree>();
    private ClassTree currentClass;

    @Override
    public void init(ProcessingEnvironment pe) {
        super.init(pe);
        this.treeUtils = Trees.instance(pe);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            Set<? extends Element> elements = roundEnv.getRootElements();
            for (Element element : elements) {
                Tree tree = this.treeUtils.getTree(element);
                if (!tree.getKind().equals((Object)Tree.Kind.CLASS)) continue;
                this.verify((ClassTree)tree);
            }
        }
        return true;
    }

    @Override
    public void started(TaskEvent e) {
    }

    @Override
    public void finished(TaskEvent e) {
        CompilationUnitTree ct = e.getCompilationUnit();
        if (ct != null) {
            this.compUnits.add(ct);
        }
    }

    List<String> getClassNames() {
        return this.classNames;
    }

    CompilationUnitTree getCompilationUnit() {
        for (CompilationUnitTree ct : this.compUnits) {
            for (Tree tree : ct.getTypeDecls()) {
                if (!tree.equals(this.currentClass)) continue;
                return ct;
            }
        }
        return null;
    }

    Trees getTreeUtils() {
        return this.treeUtils;
    }

    SourcePositions getSourcePositions() {
        return this.treeUtils.getSourcePositions();
    }

    ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    Messager getMessager() {
        return this.processingEnv.getMessager();
    }

    Elements getElementUtils() {
        return this.processingEnv.getElementUtils();
    }

    Types getTypeUtils() {
        return this.processingEnv.getTypeUtils();
    }

    Locale getLocale() {
        return this.processingEnv.getLocale();
    }

    private boolean verify(ClassTree ct) {
        this.currentClass = ct;
        CompilationUnitTree cut = this.getCompilationUnit();
        String className = ct.getSimpleName().toString();
        ExpressionTree pkgName = cut.getPackageName();
        if (pkgName != null) {
            className = pkgName + "." + className;
        }
        this.classNames.add(className);
        Boolean value = ct.accept(new VerifierVisitor(this), null);
        return value == null ? true : value;
    }
}

