﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Backlog
{
    public class Backlog
    {
        /// <summary>
        /// XML-RPC I/F
        /// </summary>
        private static XmlRpcProxy<IBacklog> rpc = new XmlRpcProxy<IBacklog>();

        private static string PostFix = "XML-RPC";

        /// <summary>
        /// I/F
        /// </summary>
        public static IBacklog Rpc
        {
            get
            {
                return rpc.Content;
            }
        }

        /// <summary>
        /// URL
        /// </summary>
        public static string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// XML-RPC URL
        /// </summary>
        public static string XmlRpcUrl
        {
            get
            {
                return rpc.Url;
            }
        }

        /// <summary>
        /// ユーザー名
        /// </summary>
        public static string UserName
        {
            get
            {
                return rpc.UserName;
            }
        }

        /// <summary>
        /// パスワード
        /// </summary>
        public static string Password
        {
            get
            {
                return rpc.Password;
            }
        }

        /// <summary>
        /// 接続状態
        /// </summary>
        public static bool IsConnected
        {
            get;
            private set;
        }

        /// <summary>
        /// Trac の URL から XML-RPC の URL を取得
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public static string GetXmlRpcUrl( string url )
        {
            // URL の取得。終端に'/' が入っていなければ付加し、XML-RPC アドレスを設定
            if ( url[url.Length - 1] != '/' ) {
                url += "/";
            }

            return url + PostFix;
        }

        /// <summary>
        /// Backlog へ接続
        /// </summary>
        /// <param name="url">URL</param>
        /// <param name="userName">ユーザー名</param>
        /// <param name="password">パスワード</param>
        public static void Connect( string url, string userName, string password )
        {
            rpc.Create( GetXmlRpcUrl( url ), userName, password );

            // 接続確認
            object ret = Rpc.GetProjects();

            Url = url;

            IsConnected = true;
        }

        /// <summary>
        /// 接続テスト
        /// </summary>
        /// <param name="url">URL</param>
        /// <param name="userName">ユーザー名</param>
        /// <param name="password">パスワード</param>
        public static bool TryConnect( string url, string userName, string password )
        {
            bool result = true;
            string currentUrl = Url;
            string currentUserName = rpc.UserName;
            string currentPassword = rpc.Password;

            try {
                // 接続テスト
                Connect( url, userName, password );
            }
            catch {
                // 例外が出たら失敗
                result = false;
            }
            finally {
                // 元のURLがあれば戻す
                if ( !string.IsNullOrEmpty( currentUrl ) ) {
                    Connect( currentUrl, currentUserName, currentPassword );
                }
                // 元のURLがなければ閉じる
                else {
                    Close();
                }
            }

            return result;
        }

        /// <summary>
        /// I/F の終了
        /// </summary>
        public static void Close()
        {
            Url = null;
            rpc.Close();

            IsConnected = false;
        }
    }
}
