﻿using System;
using System.Globalization;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Backlog
{
    /// <summary>
    /// プロジェクトの発生バージョン/マイルストーン
    /// </summary>
    public class Version
    {
        /// <summary>
        /// ユーザー属性
        /// </summary>
        class AttributeNames
        {
            public const string ID = "id";              // ID
            public const string NAME = "name";          // 名称
            public const string DATE = "date";          // リリース予定日
        }

        private static string DateFormat = "yyyyMMdd";

        /// <summary>
        /// ID
        /// </summary>
        public int Id
        {
            get;
            private set;
        }

        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// リリース予定日
        /// </summary>
        public DateTime Date
        {
            get;
            private set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Version()
        {
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="param"></param>
        public Version( XmlRpcStruct param )
            : this()
        {
            Id = int.Parse( param[AttributeNames.ID].ToString() );
            Name = param[AttributeNames.NAME].ToString();

            if ( !string.IsNullOrEmpty( param[AttributeNames.DATE].ToString() ) ) {
                Date = DateTime.ParseExact( param[AttributeNames.DATE].ToString(), DateFormat,
                    DateTimeFormatInfo.InvariantInfo );
            }
        }

        /// <summary>
        /// XmlRpcStruct に変換
        /// </summary>
        /// <returns></returns>
        public XmlRpcStruct ToXmlRpcStruct()
        {
            XmlRpcStruct value = new XmlRpcStruct();
            value[AttributeNames.ID] = Id;
            value[AttributeNames.NAME] = Name;
            value[AttributeNames.DATE] = Date.ToString( DateFormat );

            return value;
        }
    }
}
