﻿using System;
using System.Globalization;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Backlog
{
    /// <summary>
    /// コメント
    /// </summary>
    public class Comment
    {
        /// <summary>
        /// ユーザー属性
        /// </summary>
        class AttributeNames
        {
            public const string ID = "id";                      // コメントID
            public const string CONTENT = "content";            // コメント内容
            public const string CREATED_USER = "created_user";  // コメント登録者
            public const string CREATED_ON = "created_on";      // 登録日時
            public const string UPDATED_ON = "updated_on";      // 最終更新日時
        }
        /// <summary>
        /// DateTime のフォーマット（年月日自分秒）
        /// </summary>
        private static string DateTimeFormat = "yyyyMMddHHmmss";

        /// <summary>
        /// コメントID
        /// </summary>
        public int Id
        {
            get;
            private set;
        }

        /// <summary>
        /// コメント内容
        /// </summary>
        public string Content
        {
            get;
            private set;
        }

        /// <summary>
        /// コメント登録者
        /// </summary>
        public User CreatedUser
        {
            get;
            private set;
        }

        /// <summary>
        /// 登録日時
        /// </summary>
        public DateTime CreatedOn
        {
            get;
            private set;
        }

        /// <summary>
        /// 最終更新日時
        /// </summary>
        public DateTime UpdatedOn
        {
            get;
            private set;
        }


        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Comment()
        {
            CreatedUser = new User();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="param"></param>
        public Comment( XmlRpcStruct param )
            : this()
        {
            Id = int.Parse( param[AttributeNames.ID].ToString() );
            CreatedUser = new User( (XmlRpcStruct)param[AttributeNames.CREATED_USER] );

            if ( !string.IsNullOrEmpty( param[AttributeNames.CREATED_ON].ToString() ) ) {
                CreatedOn = DateTime.ParseExact( param[AttributeNames.CREATED_ON].ToString(), DateTimeFormat,
                    DateTimeFormatInfo.InvariantInfo );
            }

            if ( !string.IsNullOrEmpty( param[AttributeNames.UPDATED_ON].ToString() ) ) {
                UpdatedOn = DateTime.ParseExact( param[AttributeNames.UPDATED_ON].ToString(), DateTimeFormat,
                    DateTimeFormatInfo.InvariantInfo );
            }
        }
    }
}
