#!/bin/bash -eE
                  #// Content-Type: text/plain; charset=utf-8
                  #// -eE オプションは、エラーが起きたら中断します
                  #// -x オプションは、１行ずつコマンドを表示します

function  Main_func()
{
  echo  "テスト済みバージョン： "
  echo  "GNU bash 4.1.5 - Ubuntu Lucid"
  echo  "GNU bash 3.2.48 - Mac OS X Snow Leopard"
  echo  "このマシンのバージョン："
  /bin/bash --version | head -n 1
  Pause_func  --time_out=10
  ./T_Menu.sh
  ./T_File.sh
  ./T_Err.sh
  ./T_Str.sh
  echo  "手動テスト(T_*_Manullay.sh) は別途行ってください。"
  echo  "bashlib へのシンボリック・リンクの中でもテストしてください。"
}









 
#//--- start of bashlib include ------------------------------------------------------ 

#// <<< set up bashlib and call Main_func >>> 

#// bashlib is provided under 3-clause BSD license.
#// Copyright (C) 2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

g_BashLibPath="scriptlib/bashlib_inc.sh"; g_Ver="1.0"
g_StartInPath=`pwd`; cd "`dirname "$BASH_SOURCE"`"; g_Arguments=( "$BASH_SOURCE" "$@" )
for (( i = 0; i < 20; i ++ ));do
  if [ -e "$g_BashLibPath" ];then break ;else  g_BashLibPath="../$g_BashLibPath" ;fi ;done
if [ "$i" == "20" ];then  echo "${g_BashLibPath##*../} が見つかりません。
bashlib $g_Ver をダウンロードして scriptlib フォルダーをコピーしてください。"; exit 1 ;fi
source  "$g_BashLibPath"  #// include
CallMain_func
#//--- end of bashlib include --------------------------------------------------------
 
