Option Explicit 

'// Copyright (C) 2007-2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

Dim g_g : Sub GetMainSetting( g ) : If not IsEmpty(g_g) Then Set g=g_g : Exit Sub
  Set g=CreateObject("Scripting.Dictionary") : Set g_g=g

  '[Setting]
  '==============================================================================
  g("SVGPath") = "bashlib.svg"
  g("VmlTreePath") = "bashlib_tree.html"
  g("TemplatePath") = "ReleaseHtml5.txt"
  g("OutHtmlPath") = "bashlib.html"
  g("RepUrls") = Array( _
    Array( "C:\home\mem_cache\MyDoc\src\vbslib new\_src\vbslib.svg#OpenTemp",_
           "" ),_
    Array( "C:\home\mem_cache\MyDoc\src\vbslib new\_src\vbslib.svg#BashSyntax",_
           "" ) )
  g("DelUrls") = Array( _
    "C:\home\mem_cache\MyDoc\programming\XNvg\VFXNvg\VFXNvg.svg",_
    "C:\home\mem_cache\MyDoc\programming\OS\UNIX-Linux\!Linux.svg",_
    "..\test" )
  '==============================================================================
End Sub


Sub  Main( Opt, AppKey )
  Dim  g : GetMainSetting  g
  Dim  w_:Set w_=AppKey.NewWritable( "." ).Enable()  '// XNvgÃt@CtH_[ȉ݂ł悤ɂB
  Dim  text,  svg_width,  svg_height
  '// Stop:OrError  '// }`EvZX̂Ƃ́ALqAg_debug=0 ŎsAg_debug_process ɐݒ肷ׂlmF܂B


  '//=== SVG  XML ̐K`ɂ
  Dim  file
  Set  file = OpenForReplace( g("SVGPath"), g("OutHtmlPath") )
  file.ReplaceRange  "<!DOCTYPE svg", ">", ""
  file = Empty


  '//=== SVG ϊ
  Dim  root, elem, attr
  Set root = LoadXML( g("OutHtmlPath"), Empty )
  svg_width  = root.getAttribute( "width" )
  svg_height = root.getAttribute( "height" )
  '//  echo root.xml

  ModifySVGTag  root

  root.removeChild  root.selectSingleNode( "./script" )

  ModifyGPage2AndOver  root

  ModifyHyperLinkInSVG  root

  root.ownerDocument.save  g("OutHtmlPath")


  Set  file = OpenForReplace( g("OutHtmlPath"), Empty )

  '//=== tHg𒲐
  file.Replace  "font-family:MS-Gothic,monospace", _
                "font-family:Osaka-mono,MS-Gothic,monospace"

  '//=== xmlns 폜BiDOM ł͏ɂ߁Aōsj
  file.Replace  " xmlns=""http://www.w3.org/2000/svg""",  ""
  file.Replace  " xmlns:xlink=""http://www.w3.org/1999/xlink""",  ""

  '//=== HTML ǉ
  file.Replace _
    "<?xml version=""1.0"" encoding=""utf-16""?>"+vbCRLF,_
    "<!DOCTYPE html><!-- HTML5 Standards mode -->"+vbCRLF+_
    "<HTML>"+vbCRLF+_
    "<HEAD>"+vbCRLF+_
    "<META charset=""UTF-16""/>"+vbCRLF+_
    "<META http-equiv=""X-UA-Compatible"" content=""IE=9""/> <!-- avoid old IE mode in intranet -->"+vbCRLF+_
    "<TITLE>bashlib - shorthand library for bash</TITLE>"+vbCRLF+_
    "</HEAD>"+vbCRLF+_
    ""+vbCRLF+_
    "<BODY>"+vbCRLF+_
    ""+vbCRLF+_
    "<P style=""margin-bottom:-7px; font-size:small;"">"+vbCRLF+_
    "&nbsp;"+vbCRLF+_
    "</P>"+vbCRLF+_
    "<DIV style=""font-size:small; position:absolute; left:20px; top:10px;"">"+vbCRLF+_
    "<A href=""#table-of-contents"" style=""color:blue;""> </A>"+vbCRLF+_
    "</DIV>"+vbCRLF+_
    ""+vbCRLF
  file = Empty


  '//=== ǉ
  InsertTOC  svg_width,  svg_height


  '//=== OnLoad ĂяoR[h𖄂ߍ
  text = ReadFile( g("OutHtmlPath") )
  Dim  cs : Set cs = new_TextFileCharSetStack( "UTF-8" )
  CreateFile  g("OutHtmlPath"),  text +vbCRLF+_
    "<SCRIPT>"+vbCRLF+_
    "OnLoad();"+vbCRLF+_
    "</SCRIPT>"+vbCRLF+_
    "</BODY>"+vbCRLF+_
    "</HTML>"+vbCRLF

End Sub



Sub  ModifySVGTag( root )
  Dim  svg : Set svg = root
  Dim  page1 : Set page1 = svg.selectSingleNode( "./g" )
  Dim  attrs : attrs = Array( "sub_doctype", "cats_canvas_type", "onload", _
    "preserveAspectRatio", "uuid" )
  Dim  attr

  For Each attr  In attrs
    svg.removeAttribute  attr
  Next

  svg.setAttribute  "width", svg.getAttribute( "width" ) + 0  '// ̌ 00 Jbg
  svg.setAttribute  "height", page1.getAttribute( "height" ) + 20
End Sub


Sub  ModifyGPage2AndOver( root )
  Dim  svg : Set svg = root
  Dim  pages : Set pages = svg.selectNodes( "./g" )
  Dim  page,  page_num,  transform,  translate_xy,  page2_translate_y

  page_num = 1
  For Each page  In pages
    If page_num = 1 Then
    ElseIf page_num = 2 Then

      '//=== Qy[Wڂ g ^O transform="translate(+10,+844)"  +844 
      '// page2_translate_y 
      transform = page.getAttribute( "transform" )
      translate_xy = ArrayFromCSV_Int( sscanf( transform, "translate(%s)" ) )
      page2_translate_y = translate_xy( 1 )
      page.setAttribute  "transform", "translate(+" & translate_xy(0) & ",+" & 10 & ")"
    Else

      '//=== Ry[Wڈȍ~ g ^O transform="translate(+x,+y)"  y 
      '// page2_translate_y - 10 炷
      transform = page.getAttribute( "transform" )
      translate_xy = ArrayFromCSV_Int( sscanf( transform, "translate(%s)" ) )
      page.setAttribute  "transform", "translate(+" & translate_xy(0) & ",+" &_
        translate_xy(1) - ( page2_translate_y - 10 ) & ")"
    End If
    page_num = page_num + 1
  Next
End Sub


Sub  ModifyHyperLinkInSVG( root )
  Dim  g : GetMainSetting  g
  Dim  svg : Set svg = root
  Dim  a_tags : Set a_tags = svg.selectNodes( ".//a" )
  Dim  a_tag,  href,  paths,  path

  For Each a_tag  In a_tags

    '//=== a ^Õy[Wւ̃N onclick ύX
    '// ύXOF<a xlink:href="#Main_func" onclick="chgPage( evt, 2 )">
    '// ύXF<a xlink:href="#Main_func" onclick="window.location.hash='Main_func';">
    href = a_tag.getAttribute( "xlink:href" )
    If Left( href, 1 ) = "#" Then
      a_tag.setAttribute  "xlink:href", "#"
      a_tag.setAttribute  "onclick", "window.location.hash='"+ Mid( href, 2 ) +"'; return false"
    Else

      '//=== [Jւ̃N𒲐
      For Each paths  In g("RepUrls")
        If StrCompHeadOf( href, paths(0), Empty ) = 0 Then
          If paths(1) <> "" Then
            a_tag.setAttribute  "xlink:href",  paths(1) + Mid( href, Len( paths(0) ) + 1 )
          Else
            a_tag.removeAttribute  "xlink:href"
          End If
          Exit For
        End If
      Next

      '//=== (src) 
      If StrCompHeadOf( href, "..\scriptlib\bashlib.sh", Empty ) = 0 Then
        If a_tag.firstChild.text = "(src)" Then
          a_tag.removeChild  a_tag.firstChild
        End If
      End If

      '//=== eXgփNȂ悤ɂ
      For Each path  In g("DelUrls")
        If StrCompHeadOf( href, path, Empty ) = 0 Then
          a_tag.removeAttribute  "xlink:href"
          a_tag.setAttribute  "onclick", "return false"
        End If
      Next
    End If

    a_tag.removeAttribute  "cats_vhref"
  Next
End Sub


Sub  InsertTOC( svg_width, svg_height )
  Dim  g : GetMainSetting  g
  Dim  tree,  toc,  attr,  start_pos,  end_pos,  file

  toc = ReadFile( g("TemplatePath") )


  '//=== c[̕ǂݍ
  tree = ReadFile( g("VmlTreePath") )
  start_pos = InStr( tree, "<DIV class=""tree"">" )
  end_pos = InStr( start_pos, tree, "</NOBR></DIV>" )

  toc = toc + Mid( tree, start_pos, end_pos - start_pos ) +_
    "</NOBR></DIV>"+vbCRLF+_
    ""+vbCRLF+_
    "<SCRIPT>"+vbCRLF


  '//=== c[̉摜ւ̃pXς
  toc = Replace( toc, "src=""t_", "src=""image/t_" )


  '//=== NiA ^Oj target 𖳂
  toc = Replace( toc, "target=""main"" ", "" )


  '//=== em[h DIV  name ǉ
  '// FǉOF<DIV class="node" id="node2_children">
  '//     ǉF<DIV class="node" name="node2_children" id="node2_children">
  Dim  re : Set re = CreateObject("VBScript.RegExp")
  Dim  matches, match

  re.Pattern = "<DIV class=""node"" id="".*"">"
  re.Global = False
  Do
    Set matches = re.Execute( toc )

    If matches.Count > 0 Then
      For Each match  In matches
        attr = sscanf( match.Value, "id=""%s""" )
        toc = Left( toc, match.FirstIndex ) +_
          "<DIV class=""node"" name="""+ attr +""" id="""+ attr +""">" +_
          Mid( toc, match.FirstIndex + match.Length + 1 )
      Next
    Else
      Exit Do
    End If
  Loop


  '//=== c[̃m[h烊NAhXς
  '// FύXOFhref="bashlib_01.html#svgcats_vml_p3"
  '//     ύXFhref="#page3"
  re.Pattern = "href="""+ g_fs.GetBaseName( g("SVGPath") ) +".*\.html#svgcats_vml_p"
  re.Global = True
  toc = re.Replace( toc, "href=""#page" )


  '//=== c[̃f[^ g_elem_ids ϐǂݍ
  start_pos = InStr( tree, "g_elem_ids = new Array" )
  end_pos = InStr( start_pos, tree, "//]]>" )

  toc = toc + Mid( tree, start_pos, end_pos - start_pos ) +_
    "</SCRIPT>"+vbCRLF+_
    "</P>"+vbCRLF+_
    "</TD></TR></TABLE>"+vbCRLF+_
    ""+vbCRLF+_
    ""+vbCRLF+_
    "<svg width="""+ svg_width +""" height="""+ svg_height +""">"+vbCRLF+_
    ""+vbCRLF+_
    "<g id=""page2"""


  '//=== g("OutHtmlPath")  toc 𖄂ߍ
  Set  file = OpenForReplace( g("OutHtmlPath"), Empty )
  file.Replace  "<g id=""page2""",  vbCRLF + toc
End Sub


 






 
'--- start of vbslib include ------------------------------------------------------ 

'// ̓ Main ֐ĂяoĂ܂B
'// ܂Ascriptlib tH_[TāAvbslib CN[hĂ܂

'// vbslib is provided under 3-clause BSD license.
'// Copyright (C) 2007-2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

Dim  g_Vers : If IsEmpty( g_Vers ) Then
Set  g_Vers = CreateObject("Scripting.Dictionary") : g_Vers.Add "vbslib", 4.0
Dim  g_debug, g_debug_params, g_admin, g_vbslib_path, g_CommandPrompt, g_fs, g_sh, g_AppKey
Dim  g_MainPath, g_SrcPath, g_f, g_include_path, i, g_debug_tree, g_debug_process, g_b_compile_debug, g_debug_select
g_SrcPath = WScript.ScriptFullName : g_MainPath = g_SrcPath
SetupVbslibParameters
Set  g_fs = CreateObject( "Scripting.FileSystemObject" )
Set  g_sh = WScript.CreateObject("WScript.Shell") : g_f = g_sh.CurrentDirectory
g_sh.CurrentDirectory = g_fs.GetParentFolderName( WScript.ScriptFullName )
For i = 20 To 1 Step -1 : If g_fs.FileExists(g_vbslib_path) Then  Exit For
g_vbslib_path = "..\" + g_vbslib_path  : Next
If g_fs.FileExists(g_vbslib_path) Then  g_vbslib_path = g_fs.GetAbsolutePathName( g_vbslib_path )
g_sh.CurrentDirectory = g_f
If i=0 Then WScript.Echo "Not found " + g_fs.GetFileName( g_vbslib_path ) +vbCR+vbLF+_
  "Let's download vbslib "&g_Vers.Item("vbslib")&" and Copy scriptlib folder." : Stop : WScript.Quit 1
Set g_f = g_fs.OpenTextFile( g_vbslib_path ): Execute g_f.ReadAll() : g_f = Empty
If ResumePush Then  On Error Resume Next
  CallMainFromVbsLib
ResumePop : On Error GoTo 0
End If
'---------------------------------------------------------------------------------

Sub  SetupDebugTools()
  set_input  ""
  SetBreakByFName  Empty
  SetStartSectionTree  ""
End Sub

Sub  SetupVbslibParameters()
  '--- start of parameters for vbslib include -------------------------------
  '// g_Vers("OldMain") = 1
  g_vbslib_path = "scriptlib\vbs_inc.vbs"
  g_CommandPrompt = 2

  g_debug = 1   '// release:0, debug:99, -1:call SetupDebugTools
                '// lrItBXRpC΁Ag_debug  1 ȏɂƃfobK[g܂B
                '// XebvsJnꏊAϐ̒lmFꏊɁAStop ߂LqĂB
  g_debug_select = 1

  '--- end of parameters for vbslib include ---------------------------------
End Sub
'--- end of vbslib include --------------------------------------------------------

 
