//:AppDefaults_p.h
#import "AppDefaults.h"

#import <AppKit/NSApplication.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSDrawer.h>
#import <AppKit/NSColor.h>
#import <AppKit/NSFont.h>
#import <SGAppKit/SGAppKit.h>
#import "CMRPreferencesDefautValues.h"


@class CMRMessageAttributesTemplate;



//:AppDefaults-Background.m
@interface AppDefaults(BackgroundColorsSupport)
- (NSMutableDictionary *) backgroundColorDictionary;
- (NSColor *) defaultsColorForKey : (NSString *) key;
- (void) setBGDefaultsColor : (NSColor  *) color
					 forKey : (NSString *) key;
@end



@interface AppDefaults(AccountPrivate)
- (BOOL) checkAvailableKeychain;
@end


#define APPDEFAULTS_KEYCHAIN_STRINGS_TABLE			@"AlertPanel"
#define APPDEFAULTS_KEYCHAIN_TITLE					@"Keychain ERROR"
#define APPDEFAULTS_KEYCHAIN_NOT_AVAILABLE			@"Not Available"
#define APPDEFAULTS_KEYCHAIN_DELETE					@"Delete Keychain"
#define APPDEFAULTS_KEYCHAIN_ERRPR_DELETE			@"ERRPR Delete"
#define APPDEFAULTS_KEYCHAIN_ERRPR_CHANGE			@"ERRPR Change"

#define APPDEFAULTS_KEYCHAIN_PARAM_KEY				@"Parameters"

#define APPDEFAULTS_KEYCHAIN_TITLE_ERR_CREATE		@"ERRPR Create Title"
#define APPDEFAULTS_KEYCHAIN_MSG_ERR_PARAM_CREATE	@"Param ERRPR Create Message"
#define APPDEFAULTS_KEYCHAIN_MSG_ERRKCDUPLICATEITEM	@"DuplicateItem ERRPR Create Message"


@interface AppDefaults(AccountAlert)
- (BOOL) checkKeychainParamWithAccount : (NSString *) account
							  password : (NSString *) password;
- (int) runKeychainAlertPanelWithTitle : (NSString *) title
							   message : (NSString *) message
							   account : (NSString *) account
							  password : (NSString *) password;
							  
- (int) runKeychainAlertPanelWithKey : (NSString *) key
					   allowedCancel : (BOOL      ) allowedCancel;
@end