//
//  BSCoreDataManager.h
//  BathyScaphe
//
//  Created by Hori,Masaki on 10/10/12.
//  Copyright 2010 masakih. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@class ThreadTextDownloader;
@class BSBoardInformationObject;
@class BSThreadInformationObject;

@interface BSCoreDataManager : NSObject
{
	NSPersistentStoreCoordinator *persistentStoreCoordinator;
    NSManagedObjectModel *managedObjectModel;
    NSManagedObjectContext *managedObjectContext;
	
	BOOL oneTimeEditor;
}

@property (readonly) NSManagedObjectContext *managedObjectContext;

+ (BSCoreDataManager *)defaultManager;
+ (BSCoreDataManager *)oneTimeEditor;

- (void)refresh;
- (void)doVacuum;	// ???

// raise BSCoreDataManagerFailExuteFetchException, if fail to execute.
- (NSArray *)fetchDataForEntityName:(NSString *)entityName predicate:(NSPredicate *)predicate;
- (NSArray *)fetchDataForEntityName:(NSString *)entityName predicateFormat:(NSString *)predicateFormat, ...;
- (NSArray *)fetchDataForEntityName:(NSString *)entityName sortDescriptors:(NSArray *)sortDescriptors predicate:(NSPredicate *)predicate;
- (NSArray *)fetchDataForEntityName:(NSString *)entityName sortDescriptors:(NSArray *)sortDescriptors predicateFormat:(NSString *)predicateFormat, ...;


- (IBAction)saveAction:(id)sender;

@end

@interface BSCoreDataManager (BSCoreDataModelAccess)
// Board info Accessor
- (BSBoardInformationObject *)findBSBoardInformationObjectForHints:(NSDictionary *)hints;

- (BSBoardInformationObject *)resisterBoardInformationWithName:(NSString *)name URLString:(NSString *)urlString;

- (void)setName:(NSString *)name toBoard:(BSBoardInformationObject *)board;
- (void)setName:(NSString *)name toBoardID:(NSNumber *)boardID;
- (void)setURLString:(NSString *)urlString toBoard:(BSBoardInformationObject *)board;
- (void)setURLString:(NSString *)urlString toBoardID:(NSNumber *)baordID;

- (NSNumber *)boardIDFromBoardURL:(NSString *)urlString;
- (NSString *)urlStringFromBoardID:(NSNumber *)boardID;
- (NSNumber *)boardIDFromBoardName:(NSString *)boardName;
- (NSString *)urlStringFromBoardName:(NSString *)boardName;
- (NSString *)boardNameFromBoardID:(NSNumber *)boardID;
- (NSString *)boardNameFromBoardURL:(NSString *)urlString;

// for BoardManager-BoardListRepiar
- (BOOL)removeBoardInformationWithURL:(NSString *)urlString;


// Thread Info Accessor
- (NSArray *)threadInfoWithBoardID:(NSNumber *)boardID;
- (NSArray *)cachedThreadInfoWithBoardID:(NSNumber *)boardID;
- (BSThreadInformationObject *)threadInfoWithIdentifier:(NSString *)threadID boardInfo:(BSBoardInformationObject *)board;
- (BSThreadInformationObject *)threadInfoWithIdentifier:(NSString *)threadID boardHints:(NSDictionary *)hints;

- (BSThreadInformationObject *)resisterThreadInformationWithContentsOfFileURL:(NSURL *)fileURL;

- (void)removeThreadInfoWithIdentifier:(NSString *)threadID baordID:(NSNumber *)baordID;

- (void)setLabel:(NSUInteger)code boardName:(NSString *)boardName threadIdentifier:(NSString *)identifier;
- (void)setLabel:(NSUInteger)code threadInformation:(id /* BSThreadInformationObject * */)thread;
- (void)setIsDatOchi:(BOOL)flag threadInformation:(id /* BSThreadInformationObject * */)thread;
- (void)toggleDatOchiOfThreadInformation:(id /* BSThreadInformationObject * */)thread;

// 
- (NSDictionary *)attributesForThreadsListWithContentsOfFile:(NSString *)filePath;

// ログファイルに整合させる
//- (BOOL)rebuildFromLogFolder:(NSString *)folderPath boardID:(NSNumber *)boardID;
- (BOOL)rebuildFromLogFolder:(NSString *)folderPath boardID:(NSNumber *)boardID error:(NSError **)error;

// 未使用データを削除する
- (void)deleteUnusedInfomationsOnBoardID:(NSNumber *)boardID;

// データをリセットする
- (void)cleanUpItemsWhichHasBeenRemoved:(NSArray *)filenames;

// Favorites Accessor
- (NSArray *)favoritesThreadInformation;
- (BOOL)addFavoritesThreadIdentifier:(NSString *)threadID boardName:(NSString *)boardName;
- (BOOL)removeFavoritesThreadIdentifier:(NSString *)threadID boardName:(NSString *)boardName;
- (void)moveFavorites:(NSArray *)favorites afterFavorite:(id)favorite;


- (void)threadTextDownloader:(ThreadTextDownloader *)downloader didUpdateWithContents:(NSDictionary *)userInfo;

@end

#ifndef DATABASE_MANAGER_ENABLE
NSString *tableNameForKey(NSString *key);
#endif

NSUInteger indexOfIdentifier(NSArray *array, NSString *identifier);
id itemOfTitle(NSArray *array, NSString *searchTitle);

extern NSString *const BSCoreDataModelBoardInformationName;
extern NSString *const BSCoreDataModelThreadInformationName;
extern NSString *const BSCoreDataModelBoardHistoryName;
extern NSString *const BSCoreDataModelThreadItemName;
extern NSString *const BSCoreDataModelFavoriteName;
extern NSString *const BSCoreDataModelSurviveThreadItemsName;


// find BSBoardInformationObject Hints keys.
extern NSString *const BSBoardInformationObjectHintID;	// NSNumber
extern NSString *const BSBoardInformationObjectHintURL;	// NSString (not NSURL)
extern NSString *const BSBoardInformationObjectHintName;	//NSString


extern NSString *const BSCoreDataManagerFailExuteFetchException;


extern NSString *const BSCoreDataDidFinishUpdateDownloadedOrDeletedThreadInfoNotification;
extern NSString *const BSCoreDataWillUpdateThreadItemNotification;
extern NSString *const BSCoreDataWillDeleteThreadItemsNotification;

extern NSString *const BSCoreDataWantsThreadItemsUpdateNotification;
extern     NSString *const BSCoreDataUserInfoBoardNameKey;
extern     NSString *const BSCoreDataUserInfoThreadIDKey;
extern     NSString *const BSCoreDataUserInfoThreadCountKey;
extern     NSString *const BSCoreDataUserInfoThreadModDateKey;
extern     NSString *const BSCoreDataUserInfoThreadPathsArrayKey;
extern     NSString *const BSCoreDataUserInfoUpdateTypeKey;
extern     NSString *const BSCoreDataUserInfoIsDBInsertedKey;
extern     NSString *const BSCoreDataUserInfoThreadStatusKey;


extern     NSString *const UserInfoBoardNameKey;
extern     NSString *const UserInfoThreadIDKey;
extern     NSString *const UserInfoThreadCountKey;
extern     NSString *const UserInfoThreadModDateKey;
extern     NSString *const UserInfoThreadPathsArrayKey;
extern     NSString *const UserInfoUpdateTypeKey;
extern     NSString *const UserInfoIsDBInsertedKey;
extern     NSString *const UserInfoThreadStatusKey;
