/**
  * $Id: SG2chErrorHandler.h,v 1.1.1.1.4.1 2006-09-01 13:46:54 masakih Exp $
  * 
  * SG2chErrorHandler.h
  *
  * Copyright (c) 2003, Takanori Ishikawa.
  * See the file LICENSE for copying permission.
  */
#import <SGFoundation/SGFoundation.h>
#import "w2chConnect.h"



@interface SG2chErrorHandler : NSObject<w2chErrorHandling>
{
	NSURL				*m_requestURL;
	w2chConnectMode		m_requestMode;
	SG2chServerError	m_recentError;
	NSString			*m_recentErrorTitle;
	NSString			*m_recentErrorMessage;
	
	// available in CometBlaster and later.
	NSDictionary		*m_additionalFormsData;
}
//////////////////////////////////////////////////////////////////////
/////////////////////// [ En ] ///////////////////////////
//////////////////////////////////////////////////////////////////////
/**
  * ꎞIuWFNg̐B
  * 擾URLw肵ďB
  * 
  * @param    anURL       擾URL
  * @return               ꎞIuWFNg
  */
+ (id) handlerWithURL : (NSURL *) anURL;

/**
  * 擾URLw肵ďB
  * 
  * @param    anURL       擾URL
  * @return               ς݂̃CX^X
  */
- (id) initWithURL : (NSURL         *) anURL;


//////////////////////////////////////////////////////////////////////
/////////////////////// [ NX\bh ] ///////////////////////////
//////////////////////////////////////////////////////////////////////
/**
  * w肳ꂽURLf[^擾łꍇYES
  * 
  * @param    anURL  URL
  * @return          URLf[^擾łꍇYES
  */
+ (BOOL) canInitWithURL : (NSURL *) anURL;

//////////////////////////////////////////////////////////////////////
////////////////////// [ ANZT\bh ] //////////////////////////
//////////////////////////////////////////////////////////////////////
/* Accessor for m_requestURL */
- (void) setRequestURL : (NSURL *) aRequestURL;
/* Accessor for m_recentError */
- (void) setRecentError : (SG2chServerError) aRecentError;
/* Accessor for m_recentErrorTitle */
- (void) setRecentErrorTitle : (NSString *) aRecentErrorTitle;
/* Accessor for m_recentErrorMessage */
- (void) setRecentErrorMessage : (NSString *) aRecentErrorMessage;

- (NSDictionary *) additionalFormsData;
- (void) setAdditionalFormsData : (NSDictionary *) anAdditionalFormsData;
- (BOOL) parseHTMLContents: (NSString *) htmlContents
				 intoTitle: (NSString **) ptitle
			   intoMessage: (NSString **) pbody;
- (NSDictionary *) scanAdditionalFormsWithHTML: (NSString *) htmlContents;
@end

extern SG2chServerError SGMake2chServerError(int type, 
			     						     w2chConnectMode mode, 
										     int error);

