//:CMRToolbarDelegateImp_p.h
#import "CMRToolbarDelegateImp.h"

#import <AppKit/NSDrawer.h>
#import <AppKit/NSImage.h>

#import "CocoMonar_Prefix.h"
#import <SGAppKit/SGAppKit.h>



@interface CMRToolbarDelegateImp(Private)
- (NSToolbarItem *) itemForItemIdentifier : (NSString *) anIdentifier
								itemClass : (Class	   ) aClass;
- (NSToolbarItem *) appendToolbarItemWithItemIdentifier : (NSString *) itemIdentifier
                                      localizedLabelKey : (NSString *) label
                               localizedPaletteLabelKey : (NSString *) paletteLabel
                                    localizedToolTipKey : (NSString *) toolTip
                                                 action : (SEL       ) action
                                                 target : (id        ) target;
- (NSToolbarItem *) appendToolbarItemWithClass : (Class		) aClass
								itemIdentifier : (NSString *) itemIdentifier
							 localizedLabelKey : (NSString *) label
					  localizedPaletteLabelKey : (NSString *) paletteLabel
						   localizedToolTipKey : (NSString *) toolTip
										action : (SEL       ) action
										target : (id        ) target;
- (NSMutableDictionary *) itemDictionary;

// SledgeHammer Addition
- (NSString *) pIndicatorItemIdentifier;
@end



@interface CMRToolbarDelegateImp(Protected)
- (void) initializeToolbarItems : (NSWindow *) aWindow;
- (void) configureToolbar : (NSToolbar *) aToolbar;
@end



@interface CMRToolbarDelegateImp(CMRLocalizableStringsOwner)
@end
