/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 51 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 248
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  int yy46;
  struct LikeOp yy72;
  Expr* yy172;
  ExprList* yy174;
  Select* yy219;
  struct LimitVal yy234;
  TriggerStep* yy243;
  struct TrigEvent yy370;
  SrcList* yy373;
  struct {int value; int mask;} yy405;
  Token yy410;
  IdList* yy432;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 589
#define YYNRULE 313
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor;

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   292,   85,  362,   84,  154,  205,  419,  419,   71,   71,
 /*    10 */    71,   71,  200,   93,   93,   93,   93,   78,   78,   77,
 /*    20 */    77,   77,   76,  212,  415,   48,  426,  432,   87,   93,
 /*    30 */    93,   93,   93,   78,   78,   77,   77,   77,   76,  212,
 /*    40 */   510,  509,  397,  452,   89,   80,  306,  436,  437,  433,
 /*    50 */   433,   60,   60,   71,   71,   71,   71,  232,   93,   93,
 /*    60 */    93,   93,   78,   78,   77,   77,   77,   76,  212,  292,
 /*    70 */   305,  419,  419,  490,  223,   57,   85,  421,   84,  154,
 /*    80 */    93,   93,   93,   93,   78,   78,   77,   77,   77,   76,
 /*    90 */   212,  309,  443,  444,  212,  426,  432,  575,  380,   75,
 /*   100 */    78,   78,   77,   77,   77,   76,  212,  398,  399,  423,
 /*   110 */   423,  423,  292,   89,   80,  306,  436,  437,  433,  433,
 /*   120 */    60,   60,   71,   71,   71,   71,  489,   93,   93,   93,
 /*   130 */    93,   78,   78,   77,   77,   77,   76,  212,  426,  432,
 /*   140 */    67,   77,   77,   77,   76,  212,  397,  475,    9,  377,
 /*   150 */    62,   19,  397,  143,  411,  211,   89,   80,  306,  436,
 /*   160 */   437,  433,  433,   60,   60,   71,   71,   71,   71,  533,
 /*   170 */    93,   93,   93,   93,   78,   78,   77,   77,   77,   76,
 /*   180 */   212,  292,  525,  491,  295,  485,  481,  446,  446,  452,
 /*   190 */   189,  408,   22,  334,  340,  343,   85,  463,   84,  154,
 /*   200 */   262,  448,  209,   85,  348,   84,  154,  426,  432,  149,
 /*   210 */   151,  398,  399,  465,  551,  150,  534,  398,  399,  490,
 /*   220 */   466,  569,  570,  421,  292,   89,   80,  306,  436,  437,
 /*   230 */   433,  433,   60,   60,   71,   71,   71,   71,  362,   93,
 /*   240 */    93,   93,   93,   78,   78,   77,   77,   77,   76,  212,
 /*   250 */   426,  432,  550,  525,  397,  423,  423,  423,  345,  285,
 /*   260 */   415,   35,  535,   22,  339,  333,  443,  444,   89,   80,
 /*   270 */   306,  436,  437,  433,  433,   60,   60,   71,   71,   71,
 /*   280 */    71,  457,   93,   93,   93,   93,   78,   78,   77,   77,
 /*   290 */    77,   76,  212,  458,  526,  232,  292,  223,  185,  311,
 /*   300 */   488,  208,  325,  241,  240,  362,  459,  127,  496,  362,
 /*   310 */   327,  468,  152,  223,  475,  573,  427,  428,  497,  398,
 /*   320 */   399,  189,  426,  432,  334,  340,  343,  415,   50,  211,
 /*   330 */   161,  415,   35,  572,  571,  348,  251,  430,  431,   66,
 /*   340 */    89,   80,  306,  436,  437,  433,  433,   60,   60,   71,
 /*   350 */    71,   71,   71,  266,   93,   93,   93,   93,   78,   78,
 /*   360 */    77,   77,   77,   76,  212,  292,  429,  219,  311,  356,
 /*   370 */   112,  331,  218,  201,  118,  269,  369,  275,  374,  186,
 /*   380 */   189,  457,  503,  334,  340,  343,  279,  573,  484,  312,
 /*   390 */   123,  426,  432,  458,  348,  568,  211,   95,  587,  893,
 /*   400 */   397,  893,  148,  199,  397,  572,  459,  397,  385,   89,
 /*   410 */    80,  306,  436,  437,  433,  433,   60,   60,   71,   71,
 /*   420 */    71,   71,   18,   93,   93,   93,   93,   78,   78,   77,
 /*   430 */    77,   77,   76,  212,  292,  453,  219,  416,  584,   69,
 /*   440 */   362,  177,  271,  118,  269,  369,  275,  374,  186,  198,
 /*   450 */   157,  532,  506,  272,  351,  279,  440,  260,  531,  448,
 /*   460 */   426,  432,  415,   50,  483,  398,  399,  382,  211,  398,
 /*   470 */   399,    8,  398,  399,  388,  416,  439,  439,   89,   80,
 /*   480 */   306,  436,  437,  433,  433,   60,   60,   71,   71,   71,
 /*   490 */    71,  472,   93,   93,   93,   93,   78,   78,   77,   77,
 /*   500 */    77,   76,  212,  292,  372,  362,  378,  505,  388,  350,
 /*   510 */   439,  439,  362,  409,  523,    1,  543,  191,  362,  397,
 /*   520 */   542,  388,  520,  439,  439,  361,  156,  415,   47,  426,
 /*   530 */   432,  410,  359,  182,  415,   48,  477,  545,  200,  520,
 /*   540 */   415,   50,  388,  283,  439,  439,  352,   89,   80,  306,
 /*   550 */   436,  437,  433,  433,   60,   60,   71,   71,   71,   71,
 /*   560 */   416,   93,   93,   93,   93,   78,   78,   77,   77,   77,
 /*   570 */    76,  212,  292,  414,  324,  384,  282,  413,  329,  245,
 /*   580 */   301,  397,  372,  514,  398,  399,  286,  376,  294,  450,
 /*   590 */   524,  176,  492,  279,  479,  903,  129,  390,  426,  432,
 /*   600 */     2,  412,  170,  165,  163,  400,  401,  402,  587,  894,
 /*   610 */   623,  894,   92,  547,   68,  292,   89,   80,  306,  436,
 /*   620 */   437,  433,  433,   60,   60,   71,   71,   71,   71,  513,
 /*   630 */    93,   93,   93,   93,   78,   78,   77,   77,   77,   76,
 /*   640 */   212,  426,  432,  216,  358,  393,  398,  399,  584,  246,
 /*   650 */   213,  518,  825,  518,  247,  308,  263,  166,  292,   89,
 /*   660 */    80,  306,  436,  437,  433,  433,   60,   60,   71,   71,
 /*   670 */    71,   71,  471,   93,   93,   93,   93,   78,   78,   77,
 /*   680 */    77,   77,   76,  212,  426,  432,  215,  230,  302,  228,
 /*   690 */   525,  416,  250,  329,  248,  541,  373,  541,  518,  580,
 /*   700 */    22,  292,   89,   80,  306,  436,  437,  433,  433,   60,
 /*   710 */    60,   71,   71,   71,   71,  389,   93,   93,   93,   93,
 /*   720 */    78,   78,   77,   77,   77,   76,  212,  426,  432,  278,
 /*   730 */    56,  278,  391,  310,  470,    2,  515,  518,  127,  518,
 /*   740 */   589,  392,  367,  375,  292,   89,   74,  306,  436,  437,
 /*   750 */   433,  433,   60,   60,   71,   71,   71,   71,  221,   93,
 /*   760 */    93,   93,   93,   78,   78,   77,   77,   77,   76,  212,
 /*   770 */   426,  432,  300,  249,  303,  354,  278,  450,  338,  176,
 /*   780 */    76,  212,  204,  441,  159,   21,  194,  292,  172,   80,
 /*   790 */   306,  436,  437,  433,  433,   60,   60,   71,   71,   71,
 /*   800 */    71,  153,   93,   93,   93,   93,   78,   78,   77,   77,
 /*   810 */    77,   76,  212,  426,  432,  278,  416,  278,  416,  205,
 /*   820 */   416,  419,  416,  554,  222,  200,  470,  206,  157,  392,
 /*   830 */   367,   55,  508,  306,  436,  437,  433,  433,   60,   60,
 /*   840 */    71,   71,   71,   71,  328,   93,   93,   93,   93,   78,
 /*   850 */    78,   77,   77,   77,   76,  212,   86,  336,  362,    4,
 /*   860 */   362,  232,  362,  299,  448,  209,  160,  332,  362,  511,
 /*   870 */   362,  322,   86,  336,  362,    4,  548,  495,  518,  299,
 /*   880 */   415,   25,  415,   53,  415,  117,  419,  322,  314,  512,
 /*   890 */   415,   38,  415,   31,  362,  567,  415,   40,  452,  362,
 /*   900 */   416,  362,  234,  362,  314,  582,   20,  287,  362,  414,
 /*   910 */   419,  494,  495,  413,  452,  362,  415,   16,   58,   81,
 /*   920 */   254,  415,   54,  415,   98,  415,   41,   65,  313,  315,
 /*   930 */   415,   52,  421,  449,   58,   81,  482,  415,   36,  386,
 /*   940 */   362,  297,  383,   65,  313,  315,   86,  336,  421,    4,
 /*   950 */   223,  362,  232,  299,  362,  557,  277,  366,  223,  127,
 /*   960 */   229,  322,  415,   42,  423,  423,  423,  424,  425,   11,
 /*   970 */   565,  387,   63,  415,   28,  419,  415,  101,  314,  225,
 /*   980 */   423,  423,  423,  424,  425,   11,  583,  291,  452,  281,
 /*   990 */   162,  127,  362,  561,  232,  261,  268,  270,  104,  232,
 /*  1000 */   371,  362,  500,  501,  362,  232,  362,  232,   58,   81,
 /*  1010 */   546,  180,  127,  255,  415,   30,  164,   65,  313,  315,
 /*  1020 */   256,  362,  421,  415,   33,  244,  415,   51,  415,  115,
 /*  1030 */   362,  555,  168,   63,  550,  316,  232,  182,  167,  362,
 /*  1040 */   558,  178,  362,  415,   32,  362,  560,  362,  562,  362,
 /*  1050 */   416,  362,  415,   45,  423,  423,  423,  424,  425,   11,
 /*  1060 */   257,  415,   44,  479,  415,   10,  362,  415,   34,  415,
 /*  1070 */    99,  415,   26,  415,   24,  362,  434,  253,  362,  585,
 /*  1080 */   362,  475,  362,  479,  318,  252,  240,  243,  415,   96,
 /*  1090 */   293,  362,  294,  362,  258,  223,  284,  415,   49,  362,
 /*  1100 */   415,  114,  415,  113,  415,  102,  507,  579,  341,  362,
 /*  1110 */   330,  362,  276,  415,   27,  415,   43,  362,  586,  381,
 /*  1120 */   264,  415,  116,  362,  368,  362,  363,  527,  349,  183,
 /*  1130 */   362,  415,   97,  415,   37,  396,    5,  469,  226,  415,
 /*  1140 */    23,  447,  406,  461,  296,  415,   39,  415,   29,  342,
 /*  1150 */   415,    3,  415,   46,  231,  239,  478,  119,  519,  422,
 /*  1160 */   474,  464,  420,  193,  273,  321,  553,  445,  564,  323,
 /*  1170 */   337,  467,  516,  147,  536,  506,  521,  517,   95,  370,
 /*  1180 */   227,  173,  357,  346,  196,  326,  188,  538,  235,   70,
 /*  1190 */    64,  539,  364,  197,  120,  344,  141,  233,  549,  236,
 /*  1200 */    61,  237,  187,  242,   94,  192,  320,  298,  576,  581,
 /*  1210 */    72,  130,  131,  125,  133,  556,  128,  418,  577,  578,
 /*  1220 */   462,  190,  563,  403,  395,  138,   90,  353,  404,  360,
 /*  1230 */   405,  499,  493,  498,  142,  304,  274,  503,  109,  224,
 /*  1240 */   504,  319,  265,  132,  476,  214,  480,  417,  267,  290,
 /*  1250 */   522,    7,  502,  100,  528,  289,  529,  530,  624,  158,
 /*  1260 */   625,  135,  540,  103,  217,  139,  220,  407,  559,  454,
 /*  1270 */   174,  207,   73,   59,  175,  171,   13,  107,   17,  317,
 /*  1280 */   179,   91,   88,   15,  552,  442,  335,  105,  144,  122,
 /*  1290 */   280,  451,  288,  106,  307,  124,  111,   79,  195,  238,
 /*  1300 */   145,  537,  155,  355,   82,  486,  126,  473,  487,  137,
 /*  1310 */   110,   12,  394,  121,  203,  202,    6,  544,  140,  588,
 /*  1320 */   181,  365,  347,  435,  210,  460,   83,  146,  259,  272,
 /*  1330 */   379,  184,  574,  108,  134,  169,  456,  455,  904,   14,
 /*  1340 */   566,  438,  136,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  217,  147,  219,  220,   21,   23,   23,   69,   70,
 /*    10 */    71,   72,   22,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,  169,  170,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */    91,   92,   23,   58,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  147,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   215,   88,   88,   88,  110,   22,  217,   92,  219,  220,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,  164,  165,  166,   84,   42,   43,  238,  188,   46,
 /*   100 */    78,   79,   80,   81,   82,   83,   84,   88,   89,  124,
 /*   110 */   125,  126,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,  169,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,   80,   81,   82,   83,   84,   23,  161,   19,  239,
 /*   150 */    19,   19,   23,   21,   23,  228,   60,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  181,
 /*   170 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,  147,  169,  150,   20,  200,  124,  125,   58,
 /*   190 */    90,  156,  157,   93,   94,   95,  217,  218,  219,  220,
 /*   200 */   145,   78,   79,  217,  104,  219,  220,   42,   43,   78,
 /*   210 */    79,   88,   89,   27,   11,  180,  181,   88,   89,   88,
 /*   220 */    34,   98,   99,   92,   16,   60,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,  147,   74,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,   49,  147,   23,  124,  125,  126,  224,  153,
 /*   260 */   169,  170,  156,  157,  230,  164,  165,  166,   60,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   12,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   24,  181,  147,   16,  110,   22,   16,
 /*   300 */    20,  210,   99,  100,  101,  147,   37,   22,   39,  147,
 /*   310 */   123,   22,   22,  110,  161,  147,   42,   43,   49,   88,
 /*   320 */    89,   90,   42,   43,   93,   94,   95,  169,  170,  228,
 /*   330 */   147,  169,  170,  165,  166,  104,  188,   63,   64,  131,
 /*   340 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   350 */    70,   71,   72,  200,   74,   75,   76,   77,   78,   79,
 /*   360 */    80,   81,   82,   83,   84,   16,   92,   84,   16,  211,
 /*   370 */    21,  209,  210,   90,   91,   92,   93,   94,   95,   96,
 /*   380 */    90,   12,   97,   93,   94,   95,  103,  147,   20,  242,
 /*   390 */   243,   42,   43,   24,  104,  227,  228,  121,   19,   20,
 /*   400 */    23,   22,  113,  155,   23,  165,   37,   23,   39,   60,
 /*   410 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   420 */    71,   72,   19,   74,   75,   76,   77,   78,   79,   80,
 /*   430 */    81,   82,   83,   84,   16,   20,   84,  189,   59,   21,
 /*   440 */   147,  155,   92,   91,   92,   93,   94,   95,   96,  201,
 /*   450 */   202,  176,  177,  103,  206,  103,   20,  147,  183,   78,
 /*   460 */    42,   43,  169,  170,   80,   88,   89,  227,  228,   88,
 /*   470 */    89,   68,   88,   89,  106,  189,  108,  109,   60,   61,
 /*   480 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   490 */    72,  114,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   500 */    82,   83,   84,   16,  211,  147,   16,   20,  106,  216,
 /*   510 */   108,  109,  147,  167,  168,   19,   25,   19,  147,   23,
 /*   520 */    29,  106,  176,  108,  109,  147,  155,  169,  170,   42,
 /*   530 */    43,  168,   41,   43,  169,  170,   20,   18,   22,  176,
 /*   540 */   169,  170,  106,  190,  108,  109,   80,   60,   61,   62,
 /*   550 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   560 */   189,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   570 */    83,   84,   16,  107,   55,  186,   20,  111,  147,  221,
 /*   580 */   215,   23,  211,  178,   88,   89,  158,  216,   98,  161,
 /*   590 */   162,  163,  160,  103,  147,  139,  140,  141,   42,   43,
 /*   600 */   144,  169,   99,  100,  101,    7,    8,    9,   19,   20,
 /*   610 */   112,   22,  130,   94,  132,   16,   60,   61,   62,   63,
 /*   620 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  178,
 /*   630 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   640 */    84,   42,   43,  212,  142,  143,   88,   89,   59,   14,
 /*   650 */   148,  147,  133,  147,   14,  208,  147,  155,   16,   60,
 /*   660 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   670 */    71,   72,  114,   74,   75,   76,   77,   78,   79,   80,
 /*   680 */    81,   82,   83,   84,   42,   43,  182,   52,  182,   54,
 /*   690 */   147,  189,   52,  147,   54,   99,  100,  101,  147,  156,
 /*   700 */   157,   16,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   710 */    68,   69,   70,   71,   72,  213,   74,   75,   76,   77,
 /*   720 */    78,   79,   80,   81,   82,   83,   84,   42,   43,  225,
 /*   730 */   131,  225,  141,  182,   22,  144,   20,  147,   22,  147,
 /*   740 */     0,    1,    2,  241,   16,   60,   61,   62,   63,   64,
 /*   750 */    65,   66,   67,   68,   69,   70,   71,   72,  212,   74,
 /*   760 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   770 */    42,   43,  182,  133,  182,  147,  225,  161,  162,  163,
 /*   780 */    83,   84,  155,   20,  155,   22,  155,   16,  155,   61,
 /*   790 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   800 */    72,   89,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   810 */    82,   83,   84,   42,   43,  225,  189,  225,  189,   21,
 /*   820 */   189,   23,  189,   20,  192,   22,  114,  201,  202,    1,
 /*   830 */     2,  199,  178,   62,   63,   64,   65,   66,   67,   68,
 /*   840 */    69,   70,   71,   72,  213,   74,   75,   76,   77,   78,
 /*   850 */    79,   80,   81,   82,   83,   84,   16,   17,  147,   19,
 /*   860 */   147,  147,  147,   23,   78,   79,  155,  236,  147,   30,
 /*   870 */   147,   31,   16,   17,  147,   19,  185,  186,  147,   23,
 /*   880 */   169,  170,  169,  170,  169,  170,   88,   31,   48,   50,
 /*   890 */   169,  170,  169,  170,  147,  147,  169,  170,   58,  147,
 /*   900 */   189,  147,  188,  147,   48,   20,   19,   22,  147,  107,
 /*   910 */    23,  185,  186,  111,   58,  147,  169,  170,   78,   79,
 /*   920 */   147,  169,  170,  169,  170,  169,  170,   87,   88,   89,
 /*   930 */   169,  170,   92,  161,   78,   79,   80,  169,  170,   91,
 /*   940 */   147,  102,  147,   87,   88,   89,   16,   17,   92,   19,
 /*   950 */   110,  147,  147,   23,  147,  147,  225,   20,  110,   22,
 /*   960 */   147,   31,  169,  170,  124,  125,  126,  127,  128,  129,
 /*   970 */    20,  123,   22,  169,  170,   88,  169,  170,   48,  147,
 /*   980 */   124,  125,  126,  127,  128,  129,  244,  245,   58,   20,
 /*   990 */     5,   22,  147,  188,  147,   10,   11,   12,   13,  147,
 /*  1000 */    16,  147,    7,    8,  147,  147,  147,  147,   78,   79,
 /*  1010 */    20,   26,   22,   28,  169,  170,  155,   87,   88,   89,
 /*  1020 */    35,  147,   92,  169,  170,  147,  169,  170,  169,  170,
 /*  1030 */   147,   20,   47,   22,   49,  188,  147,   43,   53,  147,
 /*  1040 */   188,   56,  147,  169,  170,  147,  188,  147,  188,  147,
 /*  1050 */   189,  147,  169,  170,  124,  125,  126,  127,  128,  129,
 /*  1060 */   147,  169,  170,  147,  169,  170,  147,  169,  170,  169,
 /*  1070 */   170,  169,  170,  169,  170,  147,   92,  188,  147,   20,
 /*  1080 */   147,  161,  147,  147,   99,  100,  101,  147,  169,  170,
 /*  1090 */   105,  147,   98,  147,  147,  110,  147,  169,  170,  147,
 /*  1100 */   169,  170,  169,  170,  169,  170,  147,  147,  233,  147,
 /*  1110 */   147,  147,  147,  169,  170,  169,  170,  147,   59,  134,
 /*  1120 */   200,  169,  170,  147,  208,  147,  147,  147,  147,  232,
 /*  1130 */   147,  169,  170,  169,  170,  147,  191,  203,  147,  169,
 /*  1140 */   170,  229,  149,  147,  208,  169,  170,  169,  170,  147,
 /*  1150 */   169,  170,  169,  170,  147,  147,  147,  147,  172,  147,
 /*  1160 */   147,  172,  161,  112,  172,  223,  194,  229,  194,  152,
 /*  1170 */   173,  172,  172,  191,  152,  177,  161,  161,  121,   15,
 /*  1180 */   193,  151,  118,  152,  151,   38,  152,  152,  234,  119,
 /*  1190 */   130,  235,  116,  151,   60,  152,   19,  194,  184,  195,
 /*  1200 */   120,  196,  184,  197,  130,  151,   15,  152,   33,  137,
 /*  1210 */   237,  187,  187,  187,  187,  194,  184,  198,  152,  152,
 /*  1220 */   152,    6,  194,  146,  146,  152,   98,  115,  146,   98,
 /*  1230 */   146,  179,  171,  171,  214,   40,  171,   97,   19,   84,
 /*  1240 */   171,  154,  204,  214,  205,  222,  205,  189,  204,  174,
 /*  1250 */   179,   22,  173,  159,  171,  174,  171,  171,  112,   19,
 /*  1260 */   112,  102,   51,  175,  175,  113,  226,   20,   17,   11,
 /*  1270 */    14,  226,   19,  237,  113,  115,   19,  240,  231,   36,
 /*  1280 */   122,   68,   68,   22,    1,   20,   44,   19,   19,  243,
 /*  1290 */    20,   20,    5,   19,  246,   98,   19,   19,   98,  133,
 /*  1300 */    21,   17,  112,   44,   22,   20,   20,  114,   20,   19,
 /*  1310 */    19,  117,    1,   32,  112,  112,  117,   45,  102,    4,
 /*  1320 */    96,    3,   16,   92,   44,   20,   19,   19,  136,  103,
 /*  1330 */    57,  135,   20,   14,   45,   22,   20,   20,  247,   19,
 /*  1340 */   123,  107,  122,
};
#define YY_SHIFT_USE_DFLT (-62)
#define YY_SHIFT_MAX 389
static const short yy_shift_ofst[] = {
 /*     0 */   828,  840,  985,  -16,  840,  930,  930,  231,  123,  -36,
 /*    10 */    96,  930,  930,  930,  930,  930,  -45,  203,  381,   19,
 /*    20 */   786,  786,  -17,   53,  349,  165,  418,  556,  208,  280,
 /*    30 */   599,  487,  642,  642,  642,  642,  642,  642,  642,  642,
 /*    40 */   685,  642,  642,  642,  642,  642,  642,  642,  642,  642,
 /*    50 */   642,  642,  728,  771,  771,  856,  930,  930,  930,  930,
 /*    60 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    70 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    80 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    90 */   930,  930,  930,  930,  930,  930,  -61,  -61,    6,    6,
 /*   100 */   283,   22,   61,  490,  519,   19,   19,   19,   19,   19,
 /*   110 */    19,   19,  -17,  697,   10,  -62,  -62,  -62,  131,  352,
 /*   120 */   269,  269,  589,  379,   19,   19,  798,   19,   19,  740,
 /*   130 */    19,   19,  848,   19,   19,   19,   19,   19,  798,   19,
 /*   140 */    19,   19,  187,  -36,  -36,  -36,  -62,  -62,  -62,  -15,
 /*   150 */   290,  -15,  100,  558,  496,  384,  436,  129,  369,  415,
 /*   160 */   368,  377,  598,  839,  402,  839,  402,   19,   19,   19,
 /*   170 */   839,   19,  402,   19,   19,   19,  887,  402,   19,   19,
 /*   180 */    19,   19,   19,  596,   19,   19,   19,   19,  491,   19,
 /*   190 */    19,  466,   19,   19,  402,   19,   19,   19,  712,  402,
 /*   200 */    19,   19,   19,   19,  402,   19,  712,  186,  186,   63,
 /*   210 */   186,   63,  -17,  132,  482,  285,  276,  994,  186,  -17,
 /*   220 */   186,  276,  289,  802,  -17, 1051, 1051, 1057, 1164, 1051,
 /*   230 */  1164, 1051, 1051, 1064, 1147, 1060, 1070, 1076, 1164, 1051,
 /*   240 */  1134, 1134, 1080, 1177, 1057, 1074, 1164, 1191, 1191, 1191,
 /*   250 */  1191, 1057, 1134, 1177, 1051, 1175, 1175, 1051, 1051, 1072,
 /*   260 */  1051, 1215, 1215, 1051, 1128, 1112, 1128, 1112, 1215, 1131,
 /*   270 */  1215, 1131, 1195, 1131, 1140, 1131, 1219, 1155, 1155, 1195,
 /*   280 */  1131, 1131, 1131,  -36, 1219, 1229,  -62,  -62,  -62,  -62,
 /*   290 */   -62,  -62,  274,  640,  503,  635,  516,  -51,  403,  498,
 /*   300 */   937,  950,  969,  990,  995, 1011,  984, 1059,  803,  763,
 /*   310 */   716,  350,  885, 1146, 1240, 1148, 1159, 1211, 1152, 1247,
 /*   320 */  1251, 1258, 1253, 1160, 1256, 1161, 1243, 1257, 1158, 1213,
 /*   330 */  1214, 1261, 1283, 1265, 1242, 1268, 1269, 1270, 1271, 1287,
 /*   340 */  1274, 1197, 1277, 1278, 1200, 1166, 1279, 1284, 1259, 1190,
 /*   350 */  1285, 1286, 1288, 1290, 1193, 1291, 1282, 1194, 1311, 1272,
 /*   360 */  1281, 1202, 1203, 1216, 1199, 1315, 1224, 1318,  -10, 1280,
 /*   370 */  1306, 1231, 1282, 1289, 1307, 1308, 1305, 1192, 1226, 1196,
 /*   380 */  1273, 1319, 1312, 1316, 1313, 1317, 1217, 1320, 1234, 1220,
};
#define YY_REDUCE_USE_DFLT (-217)
#define YY_REDUCE_MAX 291
static const short yy_reduce_ofst[] = {
 /*     0 */   456,  371,  502,  -14,  711,  293,  162,   35,  168,  248,
 /*    10 */  -141,  358,  158, -145,  365,   91,  -21,  631,  240,  106,
 /*    20 */   -73,  101,  428, -216, -216, -216, -216, -216, -216, -216,
 /*    30 */  -216, -216, -216, -216, -216, -216, -216, -216, -216, -216,
 /*    40 */  -216, -216, -216, -216, -216, -216, -216, -216, -216, -216,
 /*    50 */  -216, -216, -216, -216, -216,  981,  976,  964,  952,  946,
 /*    60 */   962,  970,  978,  983,  857,  859,  874,  883,  892,  895,
 /*    70 */   898,  900,  902,  904,  919,  928,  931,  933,  935,  944,
 /*    80 */   713,  715,  721,  723,  727,  747,  752,  754,  756,  761,
 /*    90 */   768,  793,  804,  807,  845,  854, -216, -216, -216, -216,
 /*   100 */   346, -216, -216,  275,   34,  504,  506,  543,  -90,  551,
 /*   110 */   590,  592,  616, -216, -216, -216, -216, -216,  432,  363,
 /*   120 */   691,  726,  742,  742,  714,  805,  153,  731,  847,  591,
 /*   130 */   852,  858,  861,  860,  916,  546,  889,  936,  920,  148,
 /*   140 */   431,  447,  286,  627,  629,  633,  147,  632,  626,  -43,
 /*   150 */   -12,   14,  113,  183,  310,  378,  353,  509,  389,  353,
 /*   160 */   353,  628,   55,  405,  353,  451,  353,  748,  773,  795,
 /*   170 */   654,  808,  353,  813,  832,  878,  772,  353,  913,  940,
 /*   180 */   947,  949,  959,  875,  960,  963,  965,  979,  897,  980,
 /*   190 */   988,  945,  991,  996,  353, 1002, 1007, 1008,  934,  353,
 /*   200 */  1009, 1010,  378, 1012,  353, 1013,  934,  986,  989,  912,
 /*   210 */   992,  938, 1001,  993,  942,  997,  972,  998,  999, 1015,
 /*   220 */  1000,  974,  987,  982, 1016, 1017, 1022, 1003, 1030, 1031,
 /*   230 */  1033, 1034, 1035, 1004,  954,  956, 1005, 1006, 1042, 1043,
 /*   240 */  1014, 1018, 1019, 1020, 1021, 1023, 1054, 1024, 1025, 1026,
 /*   250 */  1027, 1028, 1032, 1029, 1055,  973, 1036, 1066, 1067, 1037,
 /*   260 */  1068, 1077, 1078, 1073, 1038, 1039, 1044, 1041, 1082, 1061,
 /*   270 */  1084, 1062, 1052, 1065, 1079, 1069, 1075, 1040, 1045, 1071,
 /*   280 */  1083, 1085, 1086, 1058, 1081, 1087, 1094, 1046, 1047, 1088,
 /*   290 */  1089, 1048,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   595,  820,  902,  710,  902,  820,  902,  902,  848,  714,
 /*    10 */   877,  818,  902,  902,  902,  902,  792,  902,  848,  902,
 /*    20 */   848,  848,  626,  743,  902,  902,  902,  902,  902,  902,
 /*    30 */   902,  902,  813,  748,  741,  734,  726,  745,  821,  814,
 /*    40 */   902,  750,  751,  876,  815,  878,  757,  817,  758,  744,
 /*    50 */   822,  861,  780,  779,  798,  902,  902,  902,  902,  902,
 /*    60 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*    70 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*    80 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*    90 */   902,  902,  902,  902,  902,  902,  804,  782,  791,  781,
 /*   100 */   619,  783,  784,  679,  614,  902,  902,  902,  902,  902,
 /*   110 */   902,  902,  902,  785,  786,  799,  801,  800,  902,  902,
 /*   120 */   902,  902,  902,  902,  902,  902,  710,  902,  902,  595,
 /*   130 */   902,  902,  902,  902,  902,  902,  902,  902,  710,  902,
 /*   140 */   902,  902,  902,  902,  902,  902,  895,  704,  714,  902,
 /*   150 */   670,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   160 */   902,  902,  602,  902,  753,  902,  693,  834,  902,  902,
 /*   170 */   902,  902,  691,  902,  902,  902,  628,  866,  881,  902,
 /*   180 */   883,  902,  902,  902,  902,  902,  902,  902,  854,  902,
 /*   190 */   600,  702,  902,  902,  868,  902,  902,  902,  718,  717,
 /*   200 */   902,  902,  902,  902,  616,  902,  712,  737,  737,  902,
 /*   210 */   737,  902,  902,  902,  816,  652,  747,  649,  737,  902,
 /*   220 */   737,  747,  711,  702,  902,  719,  719,  747,  611,  719,
 /*   230 */   611,  719,  719,  738,  858,  860,  740,  730,  611,  719,
 /*   240 */   683,  683,  742,  759,  747,  902,  611,  690,  690,  690,
 /*   250 */   690,  747,  683,  759,  719,  880,  880,  719,  719,  888,
 /*   260 */   719,  599,  599,  719,  727,  729,  727,  729,  599,  681,
 /*   270 */   599,  681,  666,  681,  652,  681,  826,  831,  831,  666,
 /*   280 */   681,  681,  681,  902,  826,  669,  636,  895,  863,  654,
 /*   290 */   654,  900,  902,  902,  902,  902,  902,  902,  841,  766,
 /*   300 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   310 */   902,  902,  902,  771,  902,  767,  902,  902,  902,  902,
 /*   320 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   330 */   902,  731,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   340 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   350 */   902,  902,  902,  902,  902,  902,  739,  902,  902,  902,
 /*   360 */   902,  768,  902,  902,  902,  902,  902,  596,  857,  902,
 /*   370 */   902,  902,  819,  856,  902,  890,  902,  902,  902,  902,
 /*   380 */   887,  902,  902,  902,  902,  902,  902,  902,  696,  902,
 /*   390 */   591,  590,  593,  592,  594,  598,  601,  623,  624,  625,
 /*   400 */   603,  604,  605,  606,  607,  608,  609,  615,  617,  635,
 /*   410 */   637,  621,  639,  700,  701,  763,  694,  695,  699,  622,
 /*   420 */   774,  765,  769,  770,  772,  773,  787,  788,  790,  796,
 /*   430 */   803,  806,  789,  794,  795,  797,  802,  805,  697,  698,
 /*   440 */   809,  629,  630,  633,  634,  844,  846,  845,  847,  632,
 /*   450 */   631,  775,  778,  811,  812,  869,  870,  871,  872,  873,
 /*   460 */   807,  720,  810,  793,  732,  735,  736,  733,  703,  713,
 /*   470 */   722,  723,  724,  725,  708,  709,  715,  728,  761,  762,
 /*   480 */   716,  705,  706,  707,  808,  764,  776,  777,  640,  641,
 /*   490 */   771,  642,  643,  644,  682,  685,  686,  687,  645,  664,
 /*   500 */   667,  668,  646,  653,  647,  648,  655,  656,  657,  660,
 /*   510 */   661,  662,  663,  658,  659,  827,  828,  832,  830,  829,
 /*   520 */   650,  651,  665,  638,  627,  620,  671,  674,  675,  676,
 /*   530 */   677,  678,  680,  672,  673,  618,  610,  612,  721,  850,
 /*   540 */   859,  855,  851,  852,  853,  613,  823,  824,  684,  755,
 /*   550 */   756,  849,  862,  864,  760,  865,  867,  892,  688,  689,
 /*   560 */   692,  833,  874,  746,  749,  752,  754,  835,  836,  837,
 /*   570 */   838,  839,  842,  843,  840,  875,  879,  882,  884,  885,
 /*   580 */   886,  889,  891,  896,  897,  898,  901,  899,  597,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ALTER",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "cmdx",          "cmd",         
  "explain",       "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "ifnotexists", 
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "carg",        
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "ifexists",    
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "nexprlist",   
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "exprlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "uniqueflag",    "idxitem",       "collate",       "nmnum",       
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE ids",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 144 */ "sortlist ::= sortitem sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "groupby_opt ::=",
 /* 150 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 151 */ "having_opt ::=",
 /* 152 */ "having_opt ::= HAVING expr",
 /* 153 */ "limit_opt ::=",
 /* 154 */ "limit_opt ::= LIMIT expr",
 /* 155 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 156 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 157 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 158 */ "where_opt ::=",
 /* 159 */ "where_opt ::= WHERE expr",
 /* 160 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 161 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 162 */ "setlist ::= nm EQ expr",
 /* 163 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 182 */ "term ::= STRING",
 /* 183 */ "expr ::= REGISTER",
 /* 184 */ "expr ::= VARIABLE",
 /* 185 */ "expr ::= expr COLLATE ids",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT expr",
 /* 210 */ "expr ::= BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "between_op ::= BETWEEN",
 /* 214 */ "between_op ::= NOT BETWEEN",
 /* 215 */ "expr ::= expr between_op expr AND expr",
 /* 216 */ "in_op ::= IN",
 /* 217 */ "in_op ::= NOT IN",
 /* 218 */ "expr ::= expr in_op LP exprlist RP",
 /* 219 */ "expr ::= LP select RP",
 /* 220 */ "expr ::= expr in_op LP select RP",
 /* 221 */ "expr ::= expr in_op nm dbnm",
 /* 222 */ "expr ::= EXISTS LP select RP",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= nexprlist",
 /* 231 */ "exprlist ::=",
 /* 232 */ "nexprlist ::= nexprlist COMMA expr",
 /* 233 */ "nexprlist ::= expr",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "collate ::=",
 /* 243 */ "collate ::= COLLATE ids",
 /* 244 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 245 */ "cmd ::= VACUUM",
 /* 246 */ "cmd ::= VACUUM nm",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ DELETE",
 /* 250 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 251 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 252 */ "cmd ::= PRAGMA nm dbnm",
 /* 253 */ "nmnum ::= plus_num",
 /* 254 */ "nmnum ::= nm",
 /* 255 */ "plus_num ::= plus_opt number",
 /* 256 */ "minus_num ::= MINUS number",
 /* 257 */ "number ::= INTEGER|FLOAT",
 /* 258 */ "plus_opt ::= PLUS",
 /* 259 */ "plus_opt ::=",
 /* 260 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 261 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 262 */ "trigger_time ::= BEFORE",
 /* 263 */ "trigger_time ::= AFTER",
 /* 264 */ "trigger_time ::= INSTEAD OF",
 /* 265 */ "trigger_time ::=",
 /* 266 */ "trigger_event ::= DELETE|INSERT",
 /* 267 */ "trigger_event ::= UPDATE",
 /* 268 */ "trigger_event ::= UPDATE OF inscollist",
 /* 269 */ "foreach_clause ::=",
 /* 270 */ "foreach_clause ::= FOR EACH ROW",
 /* 271 */ "when_clause ::=",
 /* 272 */ "when_clause ::= WHEN expr",
 /* 273 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 274 */ "trigger_cmd_list ::=",
 /* 275 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 276 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 277 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 278 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 279 */ "trigger_cmd ::= select",
 /* 280 */ "expr ::= RAISE LP IGNORE RP",
 /* 281 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 282 */ "raisetype ::= ROLLBACK",
 /* 283 */ "raisetype ::= ABORT",
 /* 284 */ "raisetype ::= FAIL",
 /* 285 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 286 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 287 */ "cmd ::= DETACH database_kw_opt expr",
 /* 288 */ "key_opt ::=",
 /* 289 */ "key_opt ::= KEY expr",
 /* 290 */ "database_kw_opt ::= DATABASE",
 /* 291 */ "database_kw_opt ::=",
 /* 292 */ "cmd ::= REINDEX",
 /* 293 */ "cmd ::= REINDEX nm dbnm",
 /* 294 */ "cmd ::= ANALYZE",
 /* 295 */ "cmd ::= ANALYZE nm dbnm",
 /* 296 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 297 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 298 */ "add_column_fullname ::= fullname",
 /* 299 */ "kwcolumn_opt ::=",
 /* 300 */ "kwcolumn_opt ::= COLUMNKW",
 /* 301 */ "cmd ::= create_vtab",
 /* 302 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 303 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 304 */ "vtabarglist ::= vtabarg",
 /* 305 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 306 */ "vtabarg ::=",
 /* 307 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 308 */ "vtabargtoken ::= ANY",
 /* 309 */ "vtabargtoken ::= lp anylist RP",
 /* 310 */ "lp ::= LP",
 /* 311 */ "anylist ::=",
 /* 312 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 155: /* select */
{
#line 369 "parse.y"
sqlite3SelectDelete((yypminor->yy219));
#line 1277 "parse.c"
}
      break;
    case 169: /* term */
{
#line 629 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1284 "parse.c"
}
      break;
    case 170: /* expr */
{
#line 627 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1291 "parse.c"
}
      break;
    case 174: /* idxlist_opt */
{
#line 887 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1298 "parse.c"
}
      break;
    case 182: /* idxlist */
{
#line 885 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1305 "parse.c"
}
      break;
    case 188: /* fullname */
{
#line 486 "parse.y"
sqlite3SrcListDelete((yypminor->yy373));
#line 1312 "parse.c"
}
      break;
    case 189: /* oneselect */
{
#line 371 "parse.y"
sqlite3SelectDelete((yypminor->yy219));
#line 1319 "parse.c"
}
      break;
    case 192: /* selcollist */
{
#line 408 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1326 "parse.c"
}
      break;
    case 193: /* from */
{
#line 441 "parse.y"
sqlite3SrcListDelete((yypminor->yy373));
#line 1333 "parse.c"
}
      break;
    case 194: /* where_opt */
{
#line 568 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1340 "parse.c"
}
      break;
    case 195: /* groupby_opt */
{
#line 534 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1347 "parse.c"
}
      break;
    case 196: /* having_opt */
{
#line 539 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1354 "parse.c"
}
      break;
    case 197: /* orderby_opt */
{
#line 509 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1361 "parse.c"
}
      break;
    case 199: /* sclp */
{
#line 410 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1368 "parse.c"
}
      break;
    case 201: /* seltablist */
{
#line 437 "parse.y"
sqlite3SrcListDelete((yypminor->yy373));
#line 1375 "parse.c"
}
      break;
    case 202: /* stl_prefix */
{
#line 439 "parse.y"
sqlite3SrcListDelete((yypminor->yy373));
#line 1382 "parse.c"
}
      break;
    case 204: /* on_opt */
{
#line 498 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1389 "parse.c"
}
      break;
    case 205: /* using_opt */
{
#line 503 "parse.y"
sqlite3IdListDelete((yypminor->yy432));
#line 1396 "parse.c"
}
      break;
    case 206: /* seltablist_paren */
{
#line 473 "parse.y"
sqlite3SelectDelete((yypminor->yy219));
#line 1403 "parse.c"
}
      break;
    case 208: /* inscollist */
{
#line 614 "parse.y"
sqlite3IdListDelete((yypminor->yy432));
#line 1410 "parse.c"
}
      break;
    case 209: /* sortlist */
{
#line 511 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1417 "parse.c"
}
      break;
    case 210: /* sortitem */
{
#line 513 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1424 "parse.c"
}
      break;
    case 211: /* nexprlist */
{
#line 861 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1431 "parse.c"
}
      break;
    case 212: /* setlist */
{
#line 581 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1438 "parse.c"
}
      break;
    case 214: /* inscollist_opt */
{
#line 612 "parse.y"
sqlite3IdListDelete((yypminor->yy432));
#line 1445 "parse.c"
}
      break;
    case 215: /* itemlist */
{
#line 604 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1452 "parse.c"
}
      break;
    case 216: /* exprlist */
{
#line 859 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1459 "parse.c"
}
      break;
    case 218: /* escape */
{
#line 705 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1466 "parse.c"
}
      break;
    case 221: /* case_operand */
{
#line 854 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1473 "parse.c"
}
      break;
    case 222: /* case_exprlist */
{
#line 840 "parse.y"
sqlite3ExprListDelete((yypminor->yy174));
#line 1480 "parse.c"
}
      break;
    case 223: /* case_else */
{
#line 850 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1487 "parse.c"
}
      break;
    case 231: /* trigger_cmd_list */
{
#line 991 "parse.y"
sqlite3DeleteTriggerStep((yypminor->yy243));
#line 1494 "parse.c"
}
      break;
    case 233: /* trigger_event */
{
#line 977 "parse.y"
sqlite3IdListDelete((yypminor->yy370).b);
#line 1501 "parse.c"
}
      break;
    case 235: /* when_clause */
{
#line 986 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1508 "parse.c"
}
      break;
    case 236: /* trigger_cmd */
{
#line 1004 "parse.y"
sqlite3DeleteTriggerStep((yypminor->yy243));
#line 1515 "parse.c"
}
      break;
    case 238: /* key_opt */
{
#line 1064 "parse.y"
sqlite3ExprDelete((yypminor->yy172));
#line 1522 "parse.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 39 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1690 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 139, 1 },
  { 140, 2 },
  { 140, 1 },
  { 142, 1 },
  { 141, 1 },
  { 141, 3 },
  { 144, 0 },
  { 144, 1 },
  { 144, 3 },
  { 143, 3 },
  { 146, 0 },
  { 146, 1 },
  { 146, 2 },
  { 145, 0 },
  { 145, 1 },
  { 145, 1 },
  { 145, 1 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 148, 6 },
  { 151, 0 },
  { 151, 3 },
  { 150, 1 },
  { 150, 0 },
  { 149, 4 },
  { 149, 2 },
  { 153, 3 },
  { 153, 1 },
  { 156, 3 },
  { 157, 1 },
  { 160, 1 },
  { 161, 1 },
  { 147, 1 },
  { 147, 1 },
  { 147, 1 },
  { 158, 0 },
  { 158, 1 },
  { 162, 1 },
  { 162, 4 },
  { 162, 6 },
  { 163, 1 },
  { 163, 2 },
  { 164, 1 },
  { 164, 1 },
  { 159, 2 },
  { 159, 0 },
  { 167, 3 },
  { 167, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 5 },
  { 168, 2 },
  { 168, 4 },
  { 168, 4 },
  { 168, 1 },
  { 168, 2 },
  { 173, 0 },
  { 173, 1 },
  { 175, 0 },
  { 175, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 1 },
  { 178, 1 },
  { 176, 3 },
  { 176, 2 },
  { 179, 0 },
  { 179, 2 },
  { 179, 2 },
  { 154, 0 },
  { 154, 2 },
  { 180, 3 },
  { 180, 2 },
  { 180, 1 },
  { 181, 2 },
  { 181, 7 },
  { 181, 5 },
  { 181, 5 },
  { 181, 10 },
  { 183, 0 },
  { 183, 1 },
  { 171, 0 },
  { 171, 3 },
  { 184, 0 },
  { 184, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 143, 4 },
  { 187, 2 },
  { 187, 0 },
  { 143, 8 },
  { 143, 4 },
  { 143, 1 },
  { 155, 1 },
  { 155, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 152, 0 },
  { 152, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 4 },
  { 209, 2 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 143, 4 },
  { 194, 0 },
  { 194, 2 },
  { 143, 6 },
  { 212, 5 },
  { 212, 3 },
  { 143, 8 },
  { 143, 5 },
  { 143, 6 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 208, 3 },
  { 208, 1 },
  { 170, 1 },
  { 170, 3 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 5 },
  { 169, 1 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 6 },
  { 170, 5 },
  { 170, 4 },
  { 169, 1 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 217, 1 },
  { 217, 2 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 170, 4 },
  { 170, 2 },
  { 170, 3 },
  { 170, 3 },
  { 170, 4 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 219, 1 },
  { 219, 2 },
  { 170, 5 },
  { 220, 1 },
  { 220, 2 },
  { 170, 5 },
  { 170, 3 },
  { 170, 5 },
  { 170, 4 },
  { 170, 4 },
  { 170, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 1 },
  { 216, 0 },
  { 211, 3 },
  { 211, 1 },
  { 143, 11 },
  { 224, 1 },
  { 224, 0 },
  { 174, 0 },
  { 174, 3 },
  { 182, 5 },
  { 182, 3 },
  { 225, 1 },
  { 226, 0 },
  { 226, 2 },
  { 143, 4 },
  { 143, 1 },
  { 143, 2 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 6 },
  { 143, 3 },
  { 227, 1 },
  { 227, 1 },
  { 165, 2 },
  { 166, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 143, 5 },
  { 230, 11 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 170, 4 },
  { 170, 6 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 143, 4 },
  { 143, 6 },
  { 143, 3 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 143, 1 },
  { 143, 3 },
  { 143, 1 },
  { 143, 3 },
  { 143, 6 },
  { 143, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
  { 143, 1 },
  { 143, 4 },
  { 241, 7 },
  { 242, 1 },
  { 242, 3 },
  { 243, 0 },
  { 243, 2 },
  { 244, 1 },
  { 244, 3 },
  { 245, 1 },
  { 246, 0 },
  { 246, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* input ::= cmdlist */
      case 1: /* cmdlist ::= cmdlist ecmd */
      case 2: /* cmdlist ::= ecmd */
      case 4: /* ecmd ::= SEMI */
      case 5: /* ecmd ::= explain cmdx SEMI */
      case 10: /* trans_opt ::= */
      case 11: /* trans_opt ::= TRANSACTION */
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 20: /* cmd ::= create_table create_table_args */
      case 28: /* columnlist ::= columnlist COMMA column */
      case 29: /* columnlist ::= column */
      case 37: /* type ::= */
      case 44: /* signed ::= plus_num */
      case 45: /* signed ::= minus_num */
      case 46: /* carglist ::= carglist carg */
      case 47: /* carglist ::= */
      case 48: /* carg ::= CONSTRAINT nm ccons */
      case 49: /* carg ::= ccons */
      case 55: /* ccons ::= NULL onconf */
      case 82: /* conslist ::= conslist COMMA tcons */
      case 83: /* conslist ::= conslist tcons */
      case 84: /* conslist ::= tcons */
      case 85: /* tcons ::= CONSTRAINT nm */
      case 258: /* plus_opt ::= PLUS */
      case 259: /* plus_opt ::= */
      case 269: /* foreach_clause ::= */
      case 270: /* foreach_clause ::= FOR EACH ROW */
      case 290: /* database_kw_opt ::= DATABASE */
      case 291: /* database_kw_opt ::= */
      case 299: /* kwcolumn_opt ::= */
      case 300: /* kwcolumn_opt ::= COLUMNKW */
      case 304: /* vtabarglist ::= vtabarg */
      case 305: /* vtabarglist ::= vtabarglist COMMA vtabarg */
      case 307: /* vtabarg ::= vtabarg vtabargtoken */
      case 311: /* anylist ::= */
#line 91 "parse.y"
{
}
#line 2147 "parse.c"
        break;
      case 3: /* cmdx ::= cmd */
#line 94 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 2152 "parse.c"
        break;
      case 6: /* explain ::= */
#line 97 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 2157 "parse.c"
        break;
      case 7: /* explain ::= EXPLAIN */
#line 99 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 2162 "parse.c"
        break;
      case 8: /* explain ::= EXPLAIN QUERY PLAN */
#line 100 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 2167 "parse.c"
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
#line 106 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy46);}
#line 2172 "parse.c"
        break;
      case 13: /* transtype ::= */
#line 111 "parse.y"
{yygotominor.yy46 = TK_DEFERRED;}
#line 2177 "parse.c"
        break;
      case 14: /* transtype ::= DEFERRED */
      case 15: /* transtype ::= IMMEDIATE */
      case 16: /* transtype ::= EXCLUSIVE */
      case 107: /* multiselect_op ::= UNION */
      case 109: /* multiselect_op ::= EXCEPT|INTERSECT */
#line 112 "parse.y"
{yygotominor.yy46 = yymsp[0].major;}
#line 2186 "parse.c"
        break;
      case 17: /* cmd ::= COMMIT trans_opt */
      case 18: /* cmd ::= END trans_opt */
#line 115 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2192 "parse.c"
        break;
      case 19: /* cmd ::= ROLLBACK trans_opt */
#line 117 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2197 "parse.c"
        break;
      case 21: /* create_table ::= CREATE temp TABLE ifnotexists nm dbnm */
#line 122 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,yymsp[-4].minor.yy46,0,0,yymsp[-2].minor.yy46);
}
#line 2204 "parse.c"
        break;
      case 22: /* ifnotexists ::= */
      case 25: /* temp ::= */
      case 63: /* autoinc ::= */
      case 77: /* init_deferred_pred_opt ::= */
      case 79: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
      case 90: /* defer_subclause_opt ::= */
      case 101: /* ifexists ::= */
      case 112: /* distinct ::= ALL */
      case 113: /* distinct ::= */
      case 213: /* between_op ::= BETWEEN */
      case 216: /* in_op ::= IN */
#line 126 "parse.y"
{yygotominor.yy46 = 0;}
#line 2219 "parse.c"
        break;
      case 23: /* ifnotexists ::= IF NOT EXISTS */
      case 24: /* temp ::= TEMP */
      case 64: /* autoinc ::= AUTOINCR */
      case 78: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
      case 100: /* ifexists ::= IF EXISTS */
      case 111: /* distinct ::= DISTINCT */
      case 214: /* between_op ::= NOT BETWEEN */
      case 217: /* in_op ::= NOT IN */
#line 127 "parse.y"
{yygotominor.yy46 = 1;}
#line 2231 "parse.c"
        break;
      case 26: /* create_table_args ::= LP columnlist conslist_opt RP */
#line 133 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy0,0);
}
#line 2238 "parse.c"
        break;
      case 27: /* create_table_args ::= AS select */
#line 136 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy219);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2246 "parse.c"
        break;
      case 30: /* column ::= columnid type carglist */
#line 148 "parse.y"
{
  yygotominor.yy410.z = yymsp[-2].minor.yy410.z;
  yygotominor.yy410.n = (pParse->sLastToken.z-yymsp[-2].minor.yy410.z) + pParse->sLastToken.n;
}
#line 2254 "parse.c"
        break;
      case 31: /* columnid ::= nm */
#line 152 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy410);
  yygotominor.yy410 = yymsp[0].minor.yy410;
}
#line 2262 "parse.c"
        break;
      case 32: /* id ::= ID */
      case 33: /* ids ::= ID|STRING */
      case 34: /* nm ::= ID */
      case 35: /* nm ::= STRING */
      case 36: /* nm ::= JOIN_KW */
      case 257: /* number ::= INTEGER|FLOAT */
#line 162 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy0;}
#line 2272 "parse.c"
        break;
      case 38: /* type ::= typetoken */
#line 223 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy410);}
#line 2277 "parse.c"
        break;
      case 39: /* typetoken ::= typename */
      case 42: /* typename ::= ids */
      case 119: /* as ::= AS nm */
      case 120: /* as ::= ids */
      case 131: /* dbnm ::= DOT nm */
      case 241: /* idxitem ::= nm */
      case 243: /* collate ::= COLLATE ids */
      case 253: /* nmnum ::= plus_num */
      case 254: /* nmnum ::= nm */
      case 255: /* plus_num ::= plus_opt number */
      case 256: /* minus_num ::= MINUS number */
#line 224 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy410;}
#line 2292 "parse.c"
        break;
      case 40: /* typetoken ::= typename LP signed RP */
#line 225 "parse.y"
{
  yygotominor.yy410.z = yymsp[-3].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy410.z;
}
#line 2300 "parse.c"
        break;
      case 41: /* typetoken ::= typename LP signed COMMA signed RP */
#line 229 "parse.y"
{
  yygotominor.yy410.z = yymsp[-5].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy410.z;
}
#line 2308 "parse.c"
        break;
      case 43: /* typename ::= typename ids */
#line 235 "parse.y"
{yygotominor.yy410.z=yymsp[-1].minor.yy410.z; yygotominor.yy410.n=yymsp[0].minor.yy410.n+(yymsp[0].minor.yy410.z-yymsp[-1].minor.yy410.z);}
#line 2313 "parse.c"
        break;
      case 50: /* ccons ::= DEFAULT term */
      case 52: /* ccons ::= DEFAULT PLUS term */
#line 246 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy172);}
#line 2319 "parse.c"
        break;
      case 51: /* ccons ::= DEFAULT LP expr RP */
#line 247 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy172);}
#line 2324 "parse.c"
        break;
      case 53: /* ccons ::= DEFAULT MINUS term */
#line 249 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2332 "parse.c"
        break;
      case 54: /* ccons ::= DEFAULT id */
#line 253 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy410);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2340 "parse.c"
        break;
      case 56: /* ccons ::= NOT NULL onconf */
#line 262 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy46);}
#line 2345 "parse.c"
        break;
      case 57: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
#line 264 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy46,yymsp[0].minor.yy46,yymsp[-2].minor.yy46);}
#line 2350 "parse.c"
        break;
      case 58: /* ccons ::= UNIQUE onconf */
#line 265 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy46,0,0,0,0);}
#line 2355 "parse.c"
        break;
      case 59: /* ccons ::= CHECK LP expr RP */
#line 266 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy172);}
#line 2360 "parse.c"
        break;
      case 60: /* ccons ::= REFERENCES nm idxlist_opt refargs */
#line 268 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy410,yymsp[-1].minor.yy174,yymsp[0].minor.yy46);}
#line 2365 "parse.c"
        break;
      case 61: /* ccons ::= defer_subclause */
#line 269 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy46);}
#line 2370 "parse.c"
        break;
      case 62: /* ccons ::= COLLATE ids */
#line 270 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy410);}
#line 2375 "parse.c"
        break;
      case 65: /* refargs ::= */
#line 283 "parse.y"
{ yygotominor.yy46 = OE_Restrict * 0x010101; }
#line 2380 "parse.c"
        break;
      case 66: /* refargs ::= refargs refarg */
#line 284 "parse.y"
{ yygotominor.yy46 = (yymsp[-1].minor.yy46 & yymsp[0].minor.yy405.mask) | yymsp[0].minor.yy405.value; }
#line 2385 "parse.c"
        break;
      case 67: /* refarg ::= MATCH nm */
#line 286 "parse.y"
{ yygotominor.yy405.value = 0;     yygotominor.yy405.mask = 0x000000; }
#line 2390 "parse.c"
        break;
      case 68: /* refarg ::= ON DELETE refact */
#line 287 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46;     yygotominor.yy405.mask = 0x0000ff; }
#line 2395 "parse.c"
        break;
      case 69: /* refarg ::= ON UPDATE refact */
#line 288 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<8;  yygotominor.yy405.mask = 0x00ff00; }
#line 2400 "parse.c"
        break;
      case 70: /* refarg ::= ON INSERT refact */
#line 289 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<16; yygotominor.yy405.mask = 0xff0000; }
#line 2405 "parse.c"
        break;
      case 71: /* refact ::= SET NULL */
#line 291 "parse.y"
{ yygotominor.yy46 = OE_SetNull; }
#line 2410 "parse.c"
        break;
      case 72: /* refact ::= SET DEFAULT */
#line 292 "parse.y"
{ yygotominor.yy46 = OE_SetDflt; }
#line 2415 "parse.c"
        break;
      case 73: /* refact ::= CASCADE */
#line 293 "parse.y"
{ yygotominor.yy46 = OE_Cascade; }
#line 2420 "parse.c"
        break;
      case 74: /* refact ::= RESTRICT */
#line 294 "parse.y"
{ yygotominor.yy46 = OE_Restrict; }
#line 2425 "parse.c"
        break;
      case 75: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
      case 76: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
      case 91: /* defer_subclause_opt ::= defer_subclause */
      case 93: /* onconf ::= ON CONFLICT resolvetype */
      case 95: /* orconf ::= OR resolvetype */
      case 96: /* resolvetype ::= raisetype */
      case 166: /* insert_cmd ::= INSERT orconf */
#line 296 "parse.y"
{yygotominor.yy46 = yymsp[0].minor.yy46;}
#line 2436 "parse.c"
        break;
      case 80: /* conslist_opt ::= */
#line 306 "parse.y"
{yygotominor.yy410.n = 0; yygotominor.yy410.z = 0;}
#line 2441 "parse.c"
        break;
      case 81: /* conslist_opt ::= COMMA conslist */
#line 307 "parse.y"
{yygotominor.yy410 = yymsp[-1].minor.yy0;}
#line 2446 "parse.c"
        break;
      case 86: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
#line 313 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy174,yymsp[0].minor.yy46,yymsp[-2].minor.yy46,0);}
#line 2451 "parse.c"
        break;
      case 87: /* tcons ::= UNIQUE LP idxlist RP onconf */
#line 315 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy174,yymsp[0].minor.yy46,0,0,0,0);}
#line 2456 "parse.c"
        break;
      case 88: /* tcons ::= CHECK LP expr RP onconf */
#line 316 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy172);}
#line 2461 "parse.c"
        break;
      case 89: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
#line 318 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy174, &yymsp[-3].minor.yy410, yymsp[-2].minor.yy174, yymsp[-1].minor.yy46);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy46);
}
#line 2469 "parse.c"
        break;
      case 92: /* onconf ::= */
      case 94: /* orconf ::= */
#line 332 "parse.y"
{yygotominor.yy46 = OE_Default;}
#line 2475 "parse.c"
        break;
      case 97: /* resolvetype ::= IGNORE */
#line 337 "parse.y"
{yygotominor.yy46 = OE_Ignore;}
#line 2480 "parse.c"
        break;
      case 98: /* resolvetype ::= REPLACE */
      case 167: /* insert_cmd ::= REPLACE */
#line 338 "parse.y"
{yygotominor.yy46 = OE_Replace;}
#line 2486 "parse.c"
        break;
      case 99: /* cmd ::= DROP TABLE ifexists fullname */
#line 342 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 0, yymsp[-1].minor.yy46);
}
#line 2493 "parse.c"
        break;
      case 102: /* cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select */
#line 352 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, yymsp[0].minor.yy219, yymsp[-6].minor.yy46, yymsp[-4].minor.yy46);
}
#line 2500 "parse.c"
        break;
      case 103: /* cmd ::= DROP VIEW ifexists fullname */
#line 355 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 1, yymsp[-1].minor.yy46);
}
#line 2507 "parse.c"
        break;
      case 104: /* cmd ::= select */
#line 362 "parse.y"
{
  SelectDest dest = {SRT_Callback, 0, 0, 0, 0};
  sqlite3Select(pParse, yymsp[0].minor.yy219, &dest, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2516 "parse.c"
        break;
      case 105: /* select ::= oneselect */
      case 128: /* seltablist_paren ::= select */
#line 373 "parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 2522 "parse.c"
        break;
      case 106: /* select ::= select multiselect_op oneselect */
#line 375 "parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy46;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }else{
    sqlite3SelectDelete(yymsp[-2].minor.yy219);
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 2535 "parse.c"
        break;
      case 108: /* multiselect_op ::= UNION ALL */
#line 386 "parse.y"
{yygotominor.yy46 = TK_ALL;}
#line 2540 "parse.c"
        break;
      case 110: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 390 "parse.y"
{
  yygotominor.yy219 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy174,yymsp[-5].minor.yy373,yymsp[-4].minor.yy172,yymsp[-3].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy174,yymsp[-7].minor.yy46,yymsp[0].minor.yy234.pLimit,yymsp[0].minor.yy234.pOffset);
}
#line 2547 "parse.c"
        break;
      case 114: /* sclp ::= selcollist COMMA */
      case 238: /* idxlist_opt ::= LP idxlist RP */
#line 411 "parse.y"
{yygotominor.yy174 = yymsp[-1].minor.yy174;}
#line 2553 "parse.c"
        break;
      case 115: /* sclp ::= */
      case 141: /* orderby_opt ::= */
      case 149: /* groupby_opt ::= */
      case 231: /* exprlist ::= */
      case 237: /* idxlist_opt ::= */
#line 412 "parse.y"
{yygotominor.yy174 = 0;}
#line 2562 "parse.c"
        break;
      case 116: /* selcollist ::= sclp expr as */
#line 413 "parse.y"
{
   yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy174,yymsp[-1].minor.yy172,yymsp[0].minor.yy410.n?&yymsp[0].minor.yy410:0);
}
#line 2569 "parse.c"
        break;
      case 117: /* selcollist ::= sclp STAR */
#line 416 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy174, p, 0);
}
#line 2577 "parse.c"
        break;
      case 118: /* selcollist ::= sclp nm DOT STAR */
#line 420 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy174, pDot, 0);
}
#line 2587 "parse.c"
        break;
      case 121: /* as ::= */
#line 433 "parse.y"
{yygotominor.yy410.n = 0;}
#line 2592 "parse.c"
        break;
      case 122: /* from ::= */
#line 445 "parse.y"
{yygotominor.yy373 = sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy373));}
#line 2597 "parse.c"
        break;
      case 123: /* from ::= FROM seltablist */
#line 446 "parse.y"
{
  yygotominor.yy373 = yymsp[0].minor.yy373;
  sqlite3SrcListShiftJoinType(yygotominor.yy373);
}
#line 2605 "parse.c"
        break;
      case 124: /* stl_prefix ::= seltablist joinop */
#line 454 "parse.y"
{
   yygotominor.yy373 = yymsp[-1].minor.yy373;
   if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].jointype = yymsp[0].minor.yy46;
}
#line 2613 "parse.c"
        break;
      case 125: /* stl_prefix ::= */
#line 458 "parse.y"
{yygotominor.yy373 = 0;}
#line 2618 "parse.c"
        break;
      case 126: /* seltablist ::= stl_prefix nm dbnm as on_opt using_opt */
#line 459 "parse.y"
{
  yygotominor.yy373 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-5].minor.yy373,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,0,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
}
#line 2625 "parse.c"
        break;
      case 127: /* seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt */
#line 464 "parse.y"
{
    yygotominor.yy373 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy373,0,0,&yymsp[-2].minor.yy410,yymsp[-4].minor.yy219,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
  }
#line 2632 "parse.c"
        break;
      case 129: /* seltablist_paren ::= seltablist */
#line 475 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy373);
     yygotominor.yy219 = sqlite3SelectNew(pParse,0,yymsp[0].minor.yy373,0,0,0,0,0,0,0);
  }
#line 2640 "parse.c"
        break;
      case 130: /* dbnm ::= */
#line 482 "parse.y"
{yygotominor.yy410.z=0; yygotominor.yy410.n=0;}
#line 2645 "parse.c"
        break;
      case 132: /* fullname ::= nm dbnm */
#line 487 "parse.y"
{yygotominor.yy373 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);}
#line 2650 "parse.c"
        break;
      case 133: /* joinop ::= COMMA|JOIN */
#line 491 "parse.y"
{ yygotominor.yy46 = JT_INNER; }
#line 2655 "parse.c"
        break;
      case 134: /* joinop ::= JOIN_KW JOIN */
#line 492 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2660 "parse.c"
        break;
      case 135: /* joinop ::= JOIN_KW nm JOIN */
#line 493 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy410,0); }
#line 2665 "parse.c"
        break;
      case 136: /* joinop ::= JOIN_KW nm nm JOIN */
#line 495 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy410,&yymsp[-1].minor.yy410); }
#line 2670 "parse.c"
        break;
      case 137: /* on_opt ::= ON expr */
      case 145: /* sortitem ::= expr */
      case 152: /* having_opt ::= HAVING expr */
      case 159: /* where_opt ::= WHERE expr */
      case 174: /* expr ::= term */
      case 202: /* escape ::= ESCAPE expr */
      case 226: /* case_else ::= ELSE expr */
      case 228: /* case_operand ::= expr */
#line 499 "parse.y"
{yygotominor.yy172 = yymsp[0].minor.yy172;}
#line 2682 "parse.c"
        break;
      case 138: /* on_opt ::= */
      case 151: /* having_opt ::= */
      case 158: /* where_opt ::= */
      case 203: /* escape ::= */
      case 227: /* case_else ::= */
      case 229: /* case_operand ::= */
#line 500 "parse.y"
{yygotominor.yy172 = 0;}
#line 2692 "parse.c"
        break;
      case 139: /* using_opt ::= USING LP inscollist RP */
      case 171: /* inscollist_opt ::= LP inscollist RP */
#line 504 "parse.y"
{yygotominor.yy432 = yymsp[-1].minor.yy432;}
#line 2698 "parse.c"
        break;
      case 140: /* using_opt ::= */
      case 170: /* inscollist_opt ::= */
#line 505 "parse.y"
{yygotominor.yy432 = 0;}
#line 2704 "parse.c"
        break;
      case 142: /* orderby_opt ::= ORDER BY sortlist */
      case 150: /* groupby_opt ::= GROUP BY nexprlist */
      case 230: /* exprlist ::= nexprlist */
#line 516 "parse.y"
{yygotominor.yy174 = yymsp[0].minor.yy174;}
#line 2711 "parse.c"
        break;
      case 143: /* sortlist ::= sortlist COMMA sortitem sortorder */
#line 517 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy174,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2719 "parse.c"
        break;
      case 144: /* sortlist ::= sortitem sortorder */
#line 521 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 && yygotominor.yy174->a ) yygotominor.yy174->a[0].sortOrder = yymsp[0].minor.yy46;
}
#line 2727 "parse.c"
        break;
      case 146: /* sortorder ::= ASC */
      case 148: /* sortorder ::= */
#line 529 "parse.y"
{yygotominor.yy46 = SQLITE_SO_ASC;}
#line 2733 "parse.c"
        break;
      case 147: /* sortorder ::= DESC */
#line 530 "parse.y"
{yygotominor.yy46 = SQLITE_SO_DESC;}
#line 2738 "parse.c"
        break;
      case 153: /* limit_opt ::= */
#line 556 "parse.y"
{yygotominor.yy234.pLimit = 0; yygotominor.yy234.pOffset = 0;}
#line 2743 "parse.c"
        break;
      case 154: /* limit_opt ::= LIMIT expr */
#line 557 "parse.y"
{yygotominor.yy234.pLimit = yymsp[0].minor.yy172; yygotominor.yy234.pOffset = 0;}
#line 2748 "parse.c"
        break;
      case 155: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 559 "parse.y"
{yygotominor.yy234.pLimit = yymsp[-2].minor.yy172; yygotominor.yy234.pOffset = yymsp[0].minor.yy172;}
#line 2753 "parse.c"
        break;
      case 156: /* limit_opt ::= LIMIT expr COMMA expr */
#line 561 "parse.y"
{yygotominor.yy234.pOffset = yymsp[-2].minor.yy172; yygotominor.yy234.pLimit = yymsp[0].minor.yy172;}
#line 2758 "parse.c"
        break;
      case 157: /* cmd ::= DELETE FROM fullname where_opt */
#line 565 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy373,yymsp[0].minor.yy172);}
#line 2763 "parse.c"
        break;
      case 160: /* cmd ::= UPDATE orconf fullname SET setlist where_opt */
#line 575 "parse.y"
{
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy174,"set list"); 
  sqlite3Update(pParse,yymsp[-3].minor.yy373,yymsp[-1].minor.yy174,yymsp[0].minor.yy172,yymsp[-4].minor.yy46);
}
#line 2771 "parse.c"
        break;
      case 161: /* setlist ::= setlist COMMA nm EQ expr */
#line 584 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2776 "parse.c"
        break;
      case 162: /* setlist ::= nm EQ expr */
#line 586 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2781 "parse.c"
        break;
      case 163: /* cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP */
#line 592 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy373, yymsp[-1].minor.yy174, 0, yymsp[-4].minor.yy432, yymsp[-7].minor.yy46);}
#line 2786 "parse.c"
        break;
      case 164: /* cmd ::= insert_cmd INTO fullname inscollist_opt select */
#line 594 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy373, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy432, yymsp[-4].minor.yy46);}
#line 2791 "parse.c"
        break;
      case 165: /* cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES */
#line 596 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy373, 0, 0, yymsp[-2].minor.yy432, yymsp[-5].minor.yy46);}
#line 2796 "parse.c"
        break;
      case 168: /* itemlist ::= itemlist COMMA expr */
      case 232: /* nexprlist ::= nexprlist COMMA expr */
#line 607 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy174,yymsp[0].minor.yy172,0);}
#line 2802 "parse.c"
        break;
      case 169: /* itemlist ::= expr */
      case 233: /* nexprlist ::= expr */
#line 609 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy172,0);}
#line 2808 "parse.c"
        break;
      case 172: /* inscollist ::= inscollist COMMA nm */
#line 619 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy432,&yymsp[0].minor.yy410);}
#line 2813 "parse.c"
        break;
      case 173: /* inscollist ::= nm */
#line 621 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy410);}
#line 2818 "parse.c"
        break;
      case 175: /* expr ::= LP expr RP */
#line 632 "parse.y"
{yygotominor.yy172 = yymsp[-1].minor.yy172; sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2823 "parse.c"
        break;
      case 176: /* term ::= NULL */
      case 181: /* term ::= INTEGER|FLOAT|BLOB */
      case 182: /* term ::= STRING */
#line 633 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2830 "parse.c"
        break;
      case 177: /* expr ::= ID */
      case 178: /* expr ::= JOIN_KW */
#line 634 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2836 "parse.c"
        break;
      case 179: /* expr ::= nm DOT nm */
#line 636 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy410);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2845 "parse.c"
        break;
      case 180: /* expr ::= nm DOT nm DOT nm */
#line 641 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy410);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy410);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2856 "parse.c"
        break;
      case 183: /* expr ::= REGISTER */
#line 650 "parse.y"
{yygotominor.yy172 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2861 "parse.c"
        break;
      case 184: /* expr ::= VARIABLE */
#line 651 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy172 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2870 "parse.c"
        break;
      case 185: /* expr ::= expr COLLATE ids */
#line 656 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy172, &yymsp[0].minor.yy410);
}
#line 2877 "parse.c"
        break;
      case 186: /* expr ::= CAST LP expr AS typetoken RP */
#line 660 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy172, 0, &yymsp[-1].minor.yy410);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2885 "parse.c"
        break;
      case 187: /* expr ::= ID LP distinct exprlist RP */
#line 665 "parse.y"
{
  if( yymsp[-1].minor.yy174 && yymsp[-1].minor.yy174->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy174, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy46 && yygotominor.yy172 ){
    yygotominor.yy172->flags |= EP_Distinct;
  }
}
#line 2899 "parse.c"
        break;
      case 188: /* expr ::= ID LP STAR RP */
#line 675 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2907 "parse.c"
        break;
      case 189: /* term ::= CTIME_KW */
#line 679 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy172 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->op = TK_CONST_FUNC;  
    yygotominor.yy172->span = yymsp[0].minor.yy0;
  }
}
#line 2920 "parse.c"
        break;
      case 190: /* expr ::= expr AND expr */
      case 191: /* expr ::= expr OR expr */
      case 192: /* expr ::= expr LT|GT|GE|LE expr */
      case 193: /* expr ::= expr EQ|NE expr */
      case 194: /* expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */
      case 195: /* expr ::= expr PLUS|MINUS expr */
      case 196: /* expr ::= expr STAR|SLASH|REM expr */
      case 197: /* expr ::= expr CONCAT expr */
#line 688 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy172,yymsp[0].minor.yy172,0);}
#line 2932 "parse.c"
        break;
      case 198: /* likeop ::= LIKE_KW */
      case 200: /* likeop ::= MATCH */
#line 700 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 0;}
#line 2938 "parse.c"
        break;
      case 199: /* likeop ::= NOT LIKE_KW */
      case 201: /* likeop ::= NOT MATCH */
#line 701 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 1;}
#line 2944 "parse.c"
        break;
      case 204: /* expr ::= expr likeop expr escape */
#line 708 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy172, 0);
  if( yymsp[0].minor.yy172 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy172, 0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy72.eOperator);
  if( yymsp[-2].minor.yy72.not ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy172->span, &yymsp[-1].minor.yy172->span);
  if( yygotominor.yy172 ) yygotominor.yy172->flags |= EP_InfixFunc;
}
#line 2960 "parse.c"
        break;
      case 205: /* expr ::= expr ISNULL|NOTNULL */
#line 721 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2968 "parse.c"
        break;
      case 206: /* expr ::= expr IS NULL */
#line 725 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2976 "parse.c"
        break;
      case 207: /* expr ::= expr NOT NULL */
#line 729 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2984 "parse.c"
        break;
      case 208: /* expr ::= expr IS NOT NULL */
#line 733 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2992 "parse.c"
        break;
      case 209: /* expr ::= NOT expr */
      case 210: /* expr ::= BITNOT expr */
#line 737 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 3001 "parse.c"
        break;
      case 211: /* expr ::= MINUS expr */
#line 745 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 3009 "parse.c"
        break;
      case 212: /* expr ::= PLUS expr */
#line 749 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 3017 "parse.c"
        break;
      case 215: /* expr ::= expr between_op expr AND expr */
#line 756 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy172, 0);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy172, 0, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy172->span);
}
#line 3033 "parse.c"
        break;
      case 218: /* expr ::= expr in_op LP exprlist RP */
#line 772 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pList = yymsp[-1].minor.yy174;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy174);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 3048 "parse.c"
        break;
      case 219: /* expr ::= LP select RP */
#line 783 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 3062 "parse.c"
        break;
      case 220: /* expr ::= expr in_op LP select RP */
#line 793 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 3077 "parse.c"
        break;
      case 221: /* expr ::= expr in_op nm dbnm */
#line 804 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,yymsp[0].minor.yy410.z?&yymsp[0].minor.yy410:&yymsp[-1].minor.yy410);
  }
#line 3093 "parse.c"
        break;
      case 222: /* expr ::= EXISTS LP select RP */
#line 816 "parse.y"
{
    Expr *p = yygotominor.yy172 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
  }
#line 3107 "parse.c"
        break;
      case 223: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 829 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = yymsp[-2].minor.yy174;
    sqlite3ExprSetHeight(yygotominor.yy172);
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy174);
  }
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3121 "parse.c"
        break;
      case 224: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 841 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 3129 "parse.c"
        break;
      case 225: /* case_exprlist ::= WHEN expr THEN expr */
#line 845 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 3137 "parse.c"
        break;
      case 234: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP */
#line 874 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy410, &yymsp[-5].minor.yy410, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy410,0), yymsp[-1].minor.yy174, yymsp[-9].minor.yy46,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy46);
}
#line 3146 "parse.c"
        break;
      case 235: /* uniqueflag ::= UNIQUE */
      case 283: /* raisetype ::= ABORT */
#line 881 "parse.y"
{yygotominor.yy46 = OE_Abort;}
#line 3152 "parse.c"
        break;
      case 236: /* uniqueflag ::= */
#line 882 "parse.y"
{yygotominor.yy46 = OE_None;}
#line 3157 "parse.c"
        break;
      case 239: /* idxlist ::= idxlist COMMA idxitem collate sortorder */
#line 892 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy410);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174, p, &yymsp[-2].minor.yy410);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 3171 "parse.c"
        break;
      case 240: /* idxlist ::= idxitem collate sortorder */
#line 902 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy410);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy410);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 3185 "parse.c"
        break;
      case 242: /* collate ::= */
#line 915 "parse.y"
{yygotominor.yy410.z = 0; yygotominor.yy410.n = 0;}
#line 3190 "parse.c"
        break;
      case 244: /* cmd ::= DROP INDEX ifexists fullname */
#line 921 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy373, yymsp[-1].minor.yy46);}
#line 3195 "parse.c"
        break;
      case 245: /* cmd ::= VACUUM */
      case 246: /* cmd ::= VACUUM nm */
#line 927 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3201 "parse.c"
        break;
      case 247: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
#line 935 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,0);}
#line 3206 "parse.c"
        break;
      case 248: /* cmd ::= PRAGMA nm dbnm EQ ON */
      case 249: /* cmd ::= PRAGMA nm dbnm EQ DELETE */
#line 936 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy0,0);}
#line 3212 "parse.c"
        break;
      case 250: /* cmd ::= PRAGMA nm dbnm EQ minus_num */
#line 938 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,1);
}
#line 3219 "parse.c"
        break;
      case 251: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
#line 941 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-1].minor.yy410,0);}
#line 3224 "parse.c"
        break;
      case 252: /* cmd ::= PRAGMA nm dbnm */
#line 942 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,0,0);}
#line 3229 "parse.c"
        break;
      case 260: /* cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END */
#line 956 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy410.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy410.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy243, &all);
}
#line 3239 "parse.c"
        break;
      case 261: /* trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause */
#line 965 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy410, &yymsp[-6].minor.yy410, yymsp[-5].minor.yy46, yymsp[-4].minor.yy370.a, yymsp[-4].minor.yy370.b, yymsp[-2].minor.yy373, yymsp[0].minor.yy172, yymsp[-10].minor.yy46, yymsp[-8].minor.yy46);
  yygotominor.yy410 = (yymsp[-6].minor.yy410.n==0?yymsp[-7].minor.yy410:yymsp[-6].minor.yy410);
}
#line 3247 "parse.c"
        break;
      case 262: /* trigger_time ::= BEFORE */
      case 265: /* trigger_time ::= */
#line 971 "parse.y"
{ yygotominor.yy46 = TK_BEFORE; }
#line 3253 "parse.c"
        break;
      case 263: /* trigger_time ::= AFTER */
#line 972 "parse.y"
{ yygotominor.yy46 = TK_AFTER;  }
#line 3258 "parse.c"
        break;
      case 264: /* trigger_time ::= INSTEAD OF */
#line 973 "parse.y"
{ yygotominor.yy46 = TK_INSTEAD;}
#line 3263 "parse.c"
        break;
      case 266: /* trigger_event ::= DELETE|INSERT */
      case 267: /* trigger_event ::= UPDATE */
#line 978 "parse.y"
{yygotominor.yy370.a = yymsp[0].major; yygotominor.yy370.b = 0;}
#line 3269 "parse.c"
        break;
      case 268: /* trigger_event ::= UPDATE OF inscollist */
#line 980 "parse.y"
{yygotominor.yy370.a = TK_UPDATE; yygotominor.yy370.b = yymsp[0].minor.yy432;}
#line 3274 "parse.c"
        break;
      case 271: /* when_clause ::= */
      case 288: /* key_opt ::= */
#line 987 "parse.y"
{ yygotominor.yy172 = 0; }
#line 3280 "parse.c"
        break;
      case 272: /* when_clause ::= WHEN expr */
      case 289: /* key_opt ::= KEY expr */
#line 988 "parse.y"
{ yygotominor.yy172 = yymsp[0].minor.yy172; }
#line 3286 "parse.c"
        break;
      case 273: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
#line 992 "parse.y"
{
  if( yymsp[-2].minor.yy243 ){
    yymsp[-2].minor.yy243->pLast->pNext = yymsp[-1].minor.yy243;
  }else{
    yymsp[-2].minor.yy243 = yymsp[-1].minor.yy243;
  }
  yymsp[-2].minor.yy243->pLast = yymsp[-1].minor.yy243;
  yygotominor.yy243 = yymsp[-2].minor.yy243;
}
#line 3299 "parse.c"
        break;
      case 274: /* trigger_cmd_list ::= */
#line 1001 "parse.y"
{ yygotominor.yy243 = 0; }
#line 3304 "parse.c"
        break;
      case 275: /* trigger_cmd ::= UPDATE orconf nm SET setlist where_opt */
#line 1007 "parse.y"
{ yygotominor.yy243 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy410, yymsp[-1].minor.yy174, yymsp[0].minor.yy172, yymsp[-4].minor.yy46); }
#line 3309 "parse.c"
        break;
      case 276: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP */
#line 1012 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy410, yymsp[-4].minor.yy432, yymsp[-1].minor.yy174, 0, yymsp[-7].minor.yy46);}
#line 3314 "parse.c"
        break;
      case 277: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt select */
#line 1015 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy410, yymsp[-1].minor.yy432, 0, yymsp[0].minor.yy219, yymsp[-4].minor.yy46);}
#line 3319 "parse.c"
        break;
      case 278: /* trigger_cmd ::= DELETE FROM nm where_opt */
#line 1019 "parse.y"
{yygotominor.yy243 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy410, yymsp[0].minor.yy172);}
#line 3324 "parse.c"
        break;
      case 279: /* trigger_cmd ::= select */
#line 1022 "parse.y"
{yygotominor.yy243 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy219); }
#line 3329 "parse.c"
        break;
      case 280: /* expr ::= RAISE LP IGNORE RP */
#line 1025 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy172 ){
    yygotominor.yy172->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3340 "parse.c"
        break;
      case 281: /* expr ::= RAISE LP raisetype COMMA nm RP */
#line 1032 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy410); 
  if( yygotominor.yy172 ) {
    yygotominor.yy172->iColumn = yymsp[-3].minor.yy46;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3351 "parse.c"
        break;
      case 282: /* raisetype ::= ROLLBACK */
#line 1042 "parse.y"
{yygotominor.yy46 = OE_Rollback;}
#line 3356 "parse.c"
        break;
      case 284: /* raisetype ::= FAIL */
#line 1044 "parse.y"
{yygotominor.yy46 = OE_Fail;}
#line 3361 "parse.c"
        break;
      case 285: /* cmd ::= DROP TRIGGER ifexists fullname */
#line 1049 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy373,yymsp[-1].minor.yy46);
}
#line 3368 "parse.c"
        break;
      case 286: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
#line 1056 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy172);
}
#line 3375 "parse.c"
        break;
      case 287: /* cmd ::= DETACH database_kw_opt expr */
#line 1059 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy172);
}
#line 3382 "parse.c"
        break;
      case 292: /* cmd ::= REINDEX */
#line 1074 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3387 "parse.c"
        break;
      case 293: /* cmd ::= REINDEX nm dbnm */
#line 1075 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3392 "parse.c"
        break;
      case 294: /* cmd ::= ANALYZE */
#line 1080 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3397 "parse.c"
        break;
      case 295: /* cmd ::= ANALYZE nm dbnm */
#line 1081 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3402 "parse.c"
        break;
      case 296: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
#line 1086 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy373,&yymsp[0].minor.yy410);
}
#line 3409 "parse.c"
        break;
      case 297: /* cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column */
#line 1089 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy410);
}
#line 3416 "parse.c"
        break;
      case 298: /* add_column_fullname ::= fullname */
#line 1092 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy373);
}
#line 3423 "parse.c"
        break;
      case 301: /* cmd ::= create_vtab */
#line 1101 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3428 "parse.c"
        break;
      case 302: /* cmd ::= create_vtab LP vtabarglist RP */
#line 1102 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3433 "parse.c"
        break;
      case 303: /* create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm */
#line 1103 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, &yymsp[0].minor.yy410);
}
#line 3440 "parse.c"
        break;
      case 306: /* vtabarg ::= */
#line 1108 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3445 "parse.c"
        break;
      case 308: /* vtabargtoken ::= ANY */
      case 309: /* vtabargtoken ::= lp anylist RP */
      case 310: /* lp ::= LP */
      case 312: /* anylist ::= anylist ANY */
#line 1110 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3453 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  assert( TOKEN.z[0] );  /* The tokenizer always gives us a token */
  sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
  pParse->parseError = 1;
#line 3518 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
