//
//  String+Utils.m
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 09/06/15.
//  Copyright 2005-2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import <SGFoundation/String+Utils.h>
#import <SGFoundation/NSString-SGExtensions.h>
#import <SGFoundation/NSMutableString-SGExtensions.h>
#import <SGFoundation/NSCharacterSet-SGExtensions.h>
#import <SGFoundation/SGURLEscape.h>
#import "UTILKit.h"



@implementation NSObject(SGStringUtils)
- (NSString *)stringValue
{
	return [self description];
}
@end


@implementation NSString(SGStringUtils)
+ (NSString *)yenmark
{
	static NSString *yen = nil;
	if (!yen) {
		yen = [[NSString alloc] initWithCharacter:0xa5];
	}
	return yen;
}

+ (NSString *)backslash
{
	return @"\\";
}

- (BOOL)isEmpty
{
	return (0 == [self length]);
}

- (NSRange)range
{
	return NSMakeRange(0, [self length]);
}

- (BOOL)boolValue
{
	if ([self intValue] > 0) {
		return YES;
	}
	return ((NSOrderedSame == [self caseInsensitiveCompare : @"yes"]) || (NSOrderedSame == [self caseInsensitiveCompare : @"true"]));
}

- (NSString *)stringValue
{
	return self;
}

- (unsigned)hexIntValue
{
	unsigned	value_;
	
	if (![[NSScanner scannerWithString:self] scanHexInt:&value_]) {
		return 0;
	}
	return value_;
}

- (unsigned)unsignedIntValue
{
	int		tmp;
	
	tmp = [self intValue];
	if (tmp < 0) {
		return 0;
	}
	return (unsigned int)tmp;
}
@end


@implementation NSAttributedString(SGStringUtils)
- (BOOL)isEmpty
{
	return (0 == [self length]);
}

- (NSRange)range
{
	return NSMakeRange(0, [self length]);
}

- (NSString *)stringValue
{
	return [self string];
}
@end


@implementation NSData(SGNetEncoding)
- (NSString *)stringByUsingURLEncoding
{
    return [self stringByUsingURLEncodingUsingEncoding:NSUTF8StringEncoding];
}

- (NSString *)stringByUsingURLEncodingUsingEncoding:(NSStringEncoding)encoding
{
	char	*s;
	
	s = SGURLEscape((const char *)[self bytes], [self length]);

	if (NULL == s) {
		return nil;
	}

	return [[[NSString alloc] initWithBytesNoCopy:s length:strlen(s) encoding:encoding freeWhenDone:YES] autorelease];
}
@end


@implementation NSString(SGNetEncoding)
- (NSString *)stringByURLEncodingUsingEncoding:(NSStringEncoding)encoding
{
    return [self stringByURLEncodingUsingEncoding:encoding convertToCharRefIfNeeded:YES unableToEncode:NULL];
}

- (NSString *)stringByURLEncodingUsingEncoding:(NSStringEncoding)encoding convertToCharRefIfNeeded:(BOOL)flag unableToEncode:(NSIndexSet **)indexes
{	
    if ([self isEmpty]) {
		return self;
	}
	NSData *data = [self dataUsingEncoding:encoding convertToCharRefIfNeeded:flag unableToEncode:indexes];
    if (!data) {
        return nil;
    }
    return [data stringByUsingURLEncodingUsingEncoding:encoding];
}

- (NSData *)dataUsingEncoding:(NSStringEncoding)encoding convertToCharRefIfNeeded:(BOOL)flag
{
    return [self dataUsingEncoding:encoding convertToCharRefIfNeeded:flag unableToEncode:NULL];
}

- (NSData *)dataUsingEncoding:(NSStringEncoding)encoding convertToCharRefIfNeeded:(BOOL)flag unableToEncode:(NSIndexSet **)indexes
{
	NSData *data = [self dataUsingEncoding:encoding];
	if (data) {
		return data;
	}
	if (!flag && indexes == NULL) {
		return nil;
	}

	NSMutableData *mData = [NSMutableData data];
    NSMutableIndexSet *mIndexes = nil;
    if (indexes != NULL) {
        mIndexes = [NSMutableIndexSet indexSet];
    }

    unsigned length_ = [self length];
    unsigned i = 0;
    NSRange aRange;

	NSString *each;
	NSData *eachData;

    while (i < length_) {
        aRange = [self rangeOfComposedCharacterSequenceAtIndex:i];
        each = [self substringWithRange:aRange];
		if (!(eachData = [each dataUsingEncoding:encoding])) {
            if (mIndexes) {
                [mIndexes addIndex:i];
            }
            if (flag) {
                CFMutableStringRef tmp = (CFMutableStringRef)[each mutableCopy];
                CFStringTransform(tmp, NULL, kCFStringTransformToXMLHex, false);
                [mData appendData:[(NSString *)tmp dataUsingEncoding:encoding]];
                [(NSString *)tmp release];
            }
		} else {
			[mData appendData:eachData];
		}
        i = NSMaxRange(aRange);
    }

    if (indexes != NULL) {
        *indexes = mIndexes;
    }
	return flag ? mData : nil;
}

- (NSString *)stringByReplacingSomeCharactersLikeV2C
{
    if ([self isEmpty]) {
        return self;
    }
    NSMutableString *mString = [self mutableCopyWithZone:[self zone]];
    unichar fromChar = 0xfffc;
    unichar toChar;
    [mString replaceCharacters:[NSString stringWithCharacters:&fromChar length:1] toString:@""];
    fromChar = 0x301c;
    toChar = 0xff5e;
    [mString replaceCharacters:[NSString stringWithCharacters:&fromChar length:1] toString:[NSString stringWithCharacters:&toChar length:1]];
    fromChar = 0x203e;
    toChar = 0xffe3;
    [mString replaceCharacters:[NSString stringWithCharacters:&fromChar length:1] toString:[NSString stringWithCharacters:&toChar length:1]];
    fromChar = 0x2014;
    toChar = 0x2015;
    [mString replaceCharacters:[NSString stringWithCharacters:&fromChar length:1] toString:[NSString stringWithCharacters:&toChar length:1]];
    fromChar = 0x2016;
    toChar = 0x2225;
    [mString replaceCharacters:[NSString stringWithCharacters:&fromChar length:1] toString:[NSString stringWithCharacters:&toChar length:1]];
    fromChar = 0x2212;
    toChar = 0xff0d;
    [mString replaceCharacters:[NSString stringWithCharacters:&fromChar length:1] toString:[NSString stringWithCharacters:&toChar length:1]];
    NSString *string = [NSString stringWithString:mString];
    [mString release];
    return string;
}
@end

/*
@implementation NSDictionary(SGNetEncoding)
- (NSString *) queryUsingEncoding : (NSStringEncoding) encoding
{
	NSEnumerator		*keyIter_;
	NSMutableString		*recordQuery_;
	id					key_;
	
	recordQuery_ = [NSMutableString string];
	keyIter_ = [self keyEnumerator];
	while(key_ = [keyIter_ nextObject]){
		id			value_;
		
		[recordQuery_ appendString:[key_ description]];
		
		value_ = [self objectForKey : key_];
		if(value_ != nil){
			NSString	*escaped_;
			
			value_ = ([value_ respondsToSelector : @selector(stringValue)])
						? [value_ stringValue]
						: [value_ description];
			
			escaped_ = [value_ stringByURLEncodingUsingEncoding : encoding];
			if(nil == escaped_) return nil;
			
			[recordQuery_ appendFormat : @"=%@", escaped_];
		}
		[recordQuery_ appendString:@"&"];
	}
	
	if(keyIter_ != nil){
		[recordQuery_ deleteCharactersInRange : 
						NSMakeRange([recordQuery_ length] -1, 1)];
	}
	return recordQuery_;
}
@end
*/
