//
//  BSLabelManager.m
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 10/08/15.
//  Copyright 2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSLabelManager.h"
#import "CocoMonar_Prefix.h"


NSString *const BSLabelManagerDidUpdateDisplayNamesNotification = @"BSLabelManagerDidUpdateDisplayNamesNotification";
NSString *const BSLabelManagerDidUpdateBackgroundColorsNotification = @"BSLabelManagerDidUpdateBackgroundColorsNotification";

@implementation BSLabelManager
APP_SINGLETON_FACTORY_METHOD_IMPLEMENTATION(defaultManager);

- (id)init
{
    if (self = [super init]) {
        [self loadFromFile];
    }
    return self;
}

- (void)dealloc
{
    [m_displayNames release];
    [super dealloc];
}

- (void)loadFromFile
{
    NSBundle    *bundles[] = {
        [NSBundle applicationSpecificBundle], 
        [NSBundle mainBundle],
        nil};
    NSBundle    **p = bundles;
    NSString    *path = nil;
    
    for (; *p != nil; p++) {
        if (path = [*p pathForResourceWithName:@"Labels.plist"]) {
            break;
        }
    }
    
    if (path) {
        m_displayNames = [[[NSArray arrayWithContentsOfFile:path] valueForKey:@"DisplayName"] retain];
    } else {
        m_displayNames = [[NSArray alloc] initWithObjects:@"Mf", @"Mi", @"Va", @"Ch", @"Ap", @"Ra", @"Wo", nil];
    }
}

- (void)saveToFile
{
    NSString *path = [[NSBundle applicationSpecificBundle] pathForResourceWithName:@"Labels.plist"];
    if (!path) {
        path = [[CMRFileManager defaultManager] supportFilepathWithName:@"Labels.plist" resolvingFileRef:NULL];
        if (!path) {
            return;
        }
    }

    NSMutableArray *array = [NSMutableArray arrayWithCapacity:7];
    for (NSString *name in m_displayNames) {
        [array addObject:[NSDictionary dictionaryWithObject:name forKey:@"DisplayName"]];
    }
    [array writeToFile:path atomically:YES];
}

- (NSArray *)displayNames
{
    return m_displayNames;
}

- (void)setDisplayNames:(NSArray *)array
{
  @synchronized(self) {
    [array retain];
    [m_displayNames release];
    m_displayNames = array;
    UTILNotifyName(BSLabelManagerDidUpdateDisplayNamesNotification);
  }
}

- (NSArray *)backgroundColors
{
    if (!m_backgroundColors) {
        m_backgroundColors = [[NSArray alloc] initWithObjects:
                              [NSColor colorWithCalibratedHue:318.0/360.0 saturation:0.47 brightness:0.91 alpha:1.0],
                              [NSColor colorWithCalibratedHue:200.0/360.0 saturation:0.6 brightness:1.0 alpha:1.0],
                              [NSColor colorWithCalibratedHue:153.0/360.0 saturation:0.48 brightness:0.97 alpha:1.0],
                              [NSColor colorWithCalibratedHue:240.0/360.0 saturation:0.6 brightness:1.0 alpha:1.0],
                              [NSColor colorWithCalibratedHue:40.0/360.0 saturation:0.6 brightness:1.0 alpha:1.0],
                              [NSColor colorWithCalibratedHue:0.0 saturation:0.6 brightness:1.0 alpha:1.0],
                              [NSColor colorWithCalibratedHue:80.0/360.0 saturation:0.0 brightness:0.7 alpha:1.0],
                              nil];
    }
    return m_backgroundColors;
}

- (void)setBackgroundColors:(NSArray *)array
{
/*  @synchronized(self) {
    [array retain];
    [m_backgroundColors release];
    m_backgroundColors = array;
    UTILNotifyName(BSLabelManagerDidUpdateBackgroundColorsNotification);
  }*/
    [self doesNotRecognizeSelector:_cmd];
}
@end
