//:SGContextHelpPanel.m
// encoding="UTF-8"

#import "SGContextHelpPanel.h"
#import "CMXPopUpWindowController.h"

typedef void * CGSConnectionID;

extern OSStatus CGSNewConnection(const void **attr, CGSConnectionID *id);


@implementation NSWindow(PopUpWindow)
- (BOOL)isPopUpWindow
{
	return NO;
}
@end


@implementation SGContextHelpPanel
- (void)enableBlur
{
    // QuartzCore.framework のリンクを忘れずに
/*    
    CGSConnectionID _myConnection;
    uint32_t __compositingFilter;
    
    int __compositingType = 1; // Apply filter to contents underneath the window, then draw window normally on top
    
    // Make a new connection to CoreGraphics, alternatively you could use the main connection
    
    CGSNewConnection(NULL , &_myConnection);
    
    // The following creates a new CoreImage filter, then sets its options with a dictionary of values
    
    CGSNewCIFilterByName (_myConnection, (CFStringRef)@"CIGaussianBlur", &__compositingFilter);
    NSDictionary *optionsDict = [NSDictionary dictionaryWithObject:[NSNumber numberWithFloat:3.0] forKey:@"inputRadius"];
    CGSSetCIFilterValuesFromDictionary(_myConnection, __compositingFilter, (CFDictionaryRef)optionsDict);
    
    // Now just switch on the filter for the window
    
    CGSAddWindowFilter(_myConnection, [self windowNumber], __compositingFilter, __compositingType );
    */
}

- (BOOL)isPopUpWindow
{
	return YES;
}

- (BOOL)canBecomeKeyWindow
{
	return YES;
}

- (BOOL)canBecomeMainWindow
{
	return NO;
}

- (NSWindow *)ownerWindow
{
	CMXPopUpWindowController *c;
	
	c = [self windowController];
	if (![c isKindOfClass:[CMXPopUpWindowController class]]) {
		return nil;
	}
	return [c ownerWindow];
}

- (void)performMiniaturize:(id)sender
{
	[[self ownerWindow] performMiniaturize:sender];
}
- (void)performClose:(id)sender
{
	[[self ownerWindow] performClose:sender];
}

/*
	2005-07-12 tsawada2<ben-sawa@td5.so-net.ne.jp>
	NSPanel では、 Esc キーが「パネルを閉じる」ショートカットとして動作している。
	ポップアップをクリックしてから Esc キーを押すと親ウインドウも一緒に閉じる問題については、
	上のメソッドで performClose: をパスしているのが原因であるから、それをやめれば直る。
	しかし、そもそも「Esc キーでポップアップを閉じたい」わけではないので（閉じたい人もいるかも？）、
	Esc キーのイベント自体をここでブロックして、無効にすることにする。
*/
- (void)cancelOperation:(id)sender
{
	//NSLog(@"Escape key has been blocked.");
}
@end
