//
//  BSBoardInfoInspector.h
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 05/10/08.
//  Copyright 2005 BathyScaphe Project. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*!
    @class       BSBoardInfoInspector
    @abstract    manage the "Board Info" inspector panel
    @discussion  BSBoardInfoInspector は、「掲示板オプション」（仮称）インスペクタ・パネルのコントローラです。
*/

@interface BSBoardInfoInspector : NSWindowController {
	NSString	*_currentTargetBoardName;

	IBOutlet NSButton		*m_addNoNameBtn;
	IBOutlet NSButton		*m_removeNoNameBtn;
	IBOutlet NSButton		*m_editNoNameBtn;
	IBOutlet NSButton		*m_detectSettingTxtBtn;
	IBOutlet NSButton		*m_helpButton;
	IBOutlet NSButton		*m_lockButton;
	IBOutlet NSTextField	*m_URLField;
	IBOutlet NSView			*m_namesTable;
	IBOutlet NSArrayController	*m_greenCube;
	IBOutlet NSProgressIndicator	*m_spin;
}

+ (id) sharedInstance;

- (void) showInspectorForTargetBoard : (NSString *) boardName;

// Accessor
- (NSString *) currentTargetBoardName;
- (void) setCurrentTargetBoardName : (NSString *) newTarget;

- (NSButton *) helpButton;
- (NSButton *) addNoNameBtn;
- (NSButton *) removeNoNameBtn;
- (NSButton *) editNoNameBtn;
- (NSButton *) detectSettingTxtBtn;
- (NSButton *) lockButton;
- (NSTextField *) URLField;
- (NSArrayController *) greenCube;
- (NSProgressIndicator *) spin;

// IBAction
- (IBAction) addNoName : (id) sender;
- (IBAction) editNoName: (id) sender;
- (IBAction) startDetect: (id) sender;
- (IBAction) toggleAllowEditingBoardURL: (id) sender;
- (IBAction) openHelpForMe : (id) sender;

// Binding
- (NSMutableArray *) noNamesArray;
- (void) setNoNamesArray: (NSMutableArray *) anArray;

- (NSString *) boardURLAsString;
- (BOOL) shouldEnableUI;
- (BOOL) shouldEnableBeBtn;
- (BOOL) shouldEnableURLEditing;

- (NSString *) defaultKotehan;
- (void) setDefaultKotehan : (NSString *) fieldValue;

- (NSString *) defaultMail;
- (void) setDefaultMail : (NSString *) fieldValue;

- (BOOL) shouldAlwaysBeLogin;
- (void) setShouldAlwaysBeLogin : (BOOL) checkboxState;

- (BOOL) shouldAllThreadsAAThread;
- (void) setShouldAllThreadsAAThread : (BOOL) checkboxState;

- (NSImage *) icon;

- (int) nanashiAllowed;

// Notification
- (void) mainWindowChanged : (NSNotification *) theNotification;
- (void) browserBoardChanged : (NSNotification *) theNotification;
- (void) viewerThreadChanged : (NSNotification *) theNotification;
@end
