//: SGTextAccessoryFieldController.h
/**
  * $Id: SGTextAccessoryFieldController.h,v 1.1.1.1 2005-05-11 17:51:26 tsawada2 Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.
  * See the file LICENSE for copying permission.
  */

/*!
 * @header     SGTextAccessoryFieldController
 * @discussion SGTextAccessoryFieldControllerNX
 */

#import <Cocoa/Cocoa.h>

@class SGBackgroundSurfaceView;
@class NSView, NSTextField, NSButton;

/*!
 * @class      SGTextAccessoryFieldController
 * @abstract   OςύXłeLXgtB[h
 *
 * @discussion wi摜ւ邱ƂŁAOςJX^}CY\
 *             eLXgtB[hbvRg[NXłB
 *             ܂AMail.app̌tB[ĥ悤Ɂu폜v
 *             {^Ă܂B
 *             PNSTextFieldTuNXł
 *             ߍ݃{^łȂ߁AIuWFNg
 *             ̃Rg[ɂȂĂ܂B
 */

@interface SGTextAccessoryFieldController : NSObject
{
	IBOutlet NSView						*m_componentView;
	IBOutlet SGBackgroundSurfaceView	*m_backgroundView;
	
	IBOutlet NSTextField		*m_textField;
	IBOutlet NSButton			*m_clearButton;
	
	NSView						*m_accessoryView;
	BOOL						_sendsActionOnTextDidChange;
}
+ (float) preferedHeight;
- (id) initWithViewFrame : (NSRect) aFrame;

- (void) setStringValue : (NSString *) aString;
- (void) selectAll : (id) sender;
- (void) sendTextFieldAction;

- (IBAction) clearText : (id) sender;
- (BOOL) sendsActionOnTextDidChange;
- (void) setSendsActionOnTextDidChange : (BOOL) flag;
@end



@interface SGTextAccessoryFieldController(Accessor)
- (NSView *) accessoryView;
- (void) setAccessoryView : (NSView *) anAccessoryView;

- (BOOL) isEmpty;
- (BOOL) clearButtonVisible;
- (void) setVisibleClearButton : (BOOL) flag;
@end



@interface SGTextAccessoryFieldController(ViewAccessor)
- (NSView *) componentView;
- (SGBackgroundSurfaceView *) backgroundView;
- (NSTextField *) textField;
- (NSButton *) clearButton;
@end
