/**
  *
  *
  * @version 1.0.0d7 (02/01/18  11:34:23 PM)
  *
  */
#import "AppDefaults_p.h"
#import <AppKit/NSApplication.h>
#import <AppKit/NSPanel.h>


//////////////////////////////////////////////////////////////////////
////////////////////// [ 萔}Nu ] //////////////////////////
//////////////////////////////////////////////////////////////////////
/**
  * ݒɕۑƂ̃L[
  */
// Xbh\̐ݒ̎i[L[
static NSString *const AppDefaultsLogSettingsKey = @"Preferences - LogSettings";

//O̕ۑꏊ̃[g
static NSString *const AppDefaultsDataRootPathKey = @"Data Root Path";

@implementation AppDefaults(LogSetting)
//////////////////////////////////////////////////////////////////////
//////////////////// [ CX^X\bh ] ////////////////////////
//////////////////////////////////////////////////////////////////////
/**
  * O̕ۑꏊ̃[gfBNgύXB
  * 
  * @param    newpath  VpX
  * @return            ύXłꍇYES
  */
- (BOOL) changeDataRootPath : (NSString *) newpath
{
	int       returnCode_;

	if(nil == newpath) return NO;
	
	//POSIXpX
	if(NO == [self validatePathLength : newpath]) return NO;
	//݌ȂA܂̓fBNgł͂Ȃ
	if(NO == [self createDirectoryAtPath : newpath]) return NO;
	
	//ċNKv
	{
		NSString *title_;
		NSString *msg_;
		NSString *btn1_;
		NSString *btn2_;
		
		title_ = 
		  NSLocalizedStringFromTable(@"Need Restart Application",
		  							 [[self class] tableForPanels],
									 nil);
		msg_ = 
		  NSLocalizedStringFromTable(@"Change Data Root Path",
		  							 [[self class] tableForPanels],
									 nil);
		btn1_ = 
		  NSLocalizedStringFromTable(@"Terminate",
		  							 [[self class] tableForPanels],
									 nil);
		btn2_ = 
		  NSLocalizedStringFromTable(@"NoChange",
		  							 [[self class] tableForPanels],
									 nil);
		returnCode_ = NSRunCriticalAlertPanel(
								title_,
								msg_,
								btn1_,
								btn2_,
								nil);
	}
	
	if(NSAlertDefaultReturn == returnCode_){
		[self setDataRootPath : newpath];
		[NSApp terminate : self];
		return YES;
	}else if(NSAlertAlternateReturn == returnCode_){
		return NO;
	}
	
	return NO;
}

- (BOOL) shouldSaveDataRootPath : (NSString *) filepath
{
	NSString	*dataDirPath_;
	dataDirPath_ = [self defaultDataRootPath];
	
	return (NO == [dataDirPath_ isSameAsString : filepath]);
}
- (void) _loadLogSettings;
{
	NSDictionary		*dict_;
	NSString			*filepath_;
	
	dict_ = [[self defaults] dictionaryForKey : AppDefaultsLogSettingsKey];
	filepath_ = [dict_ objectForKey : AppDefaultsDataRootPathKey];
	
	if(NO == [self shouldSaveDataRootPath : filepath_]){
		[[self defaults] removeObjectForKey : AppDefaultsLogSettingsKey];
		return;
	}
	
	[self setDataRootPath : filepath_];
}
- (BOOL) _saveLogSettings;
{
	NSMutableDictionary		*dict_;
	
	dict_ = [NSMutableDictionary dictionary];
	
	if([self shouldSaveDataRootPath : [self dataRootPath]]){
		[dict_ setObject : [self dataRootPath]
				  forKey : AppDefaultsDataRootPathKey];
	}
	[[self defaults] setObject : dict_
						forKey : AppDefaultsLogSettingsKey];
	return YES;
}
@end


