//: CMXPopUpWindowManager.h
/**
  * $Id: CMXPopUpWindowManager.h,v 1.1.1.1 2005-05-11 17:51:09 tsawada2 Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.  All rights reserved.
  * See the file LICENSE for copying permission.
  */

/*!
 * @header     CMXPopUpWindowManager
 * @discussion |bvAbvEBhE̊Ǘ
 */
#import <Cocoa/Cocoa.h>
#import "CMXPopUpWindowController.h"


@class SGBaseCArrayWrapper;

#define CMRPopUpMgr		[CMXPopUpWindowManager defaultManager]

@interface CMXPopUpWindowManager : NSObject
{
	@private
	SGBaseCArrayWrapper		*_controllerArray;
}
/*!
 * @method      defaultManager
 * @abstract    LIuWFNgԂB
 * @discussion  LIuWFNgԂB
 * @result      LIuWFNgԂB
 */
+ (id) defaultManager;

- (BOOL) isPopUpWindowVisible;
/*!
 * @method         showPopUpWindowWithContext:forObject:owner:locationHint:
 * @abstract       |bvAbvEBhE\
 * @discussion     |bvAbvEBhE\
 * @param context  \e
 * @param object   ֘AẪL[ƂȂIuWFNg
 * @param owner    delegate
 * @param point    \ʒu
 * 
 * @result         CMXPopUpWindowController
 */
- (id) showPopUpWindowWithContext : (NSAttributedString *) context
                        forObject : (id                  ) object
                            owner : (id                  ) owner
                     locationHint : (NSPoint             ) point;

- (BOOL) popUpWindowIsVisibleForObject : (id) object;

- (void) closePopUpWindowForOwner : (id) owner;
/*!
 * @method        performClosePopUpWindowForObject:
 * @abstract      |bvAbvEBhE
 * @discussion    |bvAbvEBhE
 * @param object  ֘AẪL[ƂȂIuWFNg
 * @result		  ꍇYES
 */
- (BOOL) performClosePopUpWindowForObject : (id) object;



- (NSColor *) backgroundColor;
- (BOOL) isSeeThrough;
@end
