/**
  * $Id: AppDefaults.h,v 1.42 2007-04-28 11:35:27 tsawada2 Exp $
  * 
  * AppDefaults.h
  *
  * Copyright (c) 2003, Takanori Ishikawa.
  * See the file LICENSE for copying permission.
  */
#import <Foundation/Foundation.h>
#import "CocoMonar_Prefix.h"
#import <AppKit/NSNibDeclarations.h>

#import "BSImagePreviewerInterface.h"

@protocol w2chConnect;
@class BSThreadViewTheme;
/*!
 * @define      CMRPref
 * @discussion  O[oȏݒIuWFNg
 */
#define CMRPref		[AppDefaults sharedInstance]

typedef enum _BSAutoSyncIntervalType {
	BSAutoSyncByWeek	= 1,
	BSAutoSyncBy2weeks	= 2,
	BSAutoSyncByMonth	= 3,
	BSAutoSyncByEveryStartUp = 11,
	BSAutoSyncEveryDay	= 12, // available in ReinforceII and later.
} BSAutoSyncIntervalType;

@interface AppDefaults : NSObject
{
	@private
	NSMutableDictionary		*m_backgroundColorDictionary;
	NSMutableDictionary		*m_threadsListDictionary;
	NSMutableDictionary		*m_threadViewerDictionary;
	NSMutableDictionary		*m_imagePreviewerDictionary;
	NSMutableDictionary		*_dictAppearance;
	NSMutableDictionary		*_dictFilter;
	NSMutableDictionary		*m_soundsDictionary;
	NSMutableDictionary		*m_boardWarriorDictionary;
	BSThreadViewTheme		*m_threadViewTheme;
	
	// pɂɃANZX\̂ϐ
	struct {
		unsigned int mailAttachmentShown:1;
		unsigned int mailAddressShown:1;
		unsigned int enableAntialias:1;
		unsigned int reserved:29;
	} PFlags;
}

+ (id) sharedInstance;
- (NSUserDefaults *) defaults;
- (void) postLayoutSettingsUpdateNotification;

- (BOOL) loadDefaults;
- (BOOL) saveDefaults;

// oCi`ŃOۑ
- (BOOL) saveThreadDocAsBinaryPlist;

- (BOOL) isOnlineMode;
- (void) setIsOnlineMode : (BOOL) flag;
- (IBAction) toggleOnlineMode : (id) sender;

- (BOOL) isSplitViewVertical;
- (void) setIsSplitViewVertical : (BOOL) flag;

// Xbh폜ƂɌxȂ
- (BOOL) quietDeletion;
- (void) setQuietDeletion : (BOOL) flag;
// ONobNOEhŊJ
- (BOOL) openInBg;
- (void) setOpenInBg : (BOOL) flag;

/*** ݁FO ***/
- (NSString *) defaultReplyName;
- (void) setDefaultReplyName : (NSString *) name;
- (NSString *) defaultReplyMailAddress;
- (void) setDefaultReplyMailAddress : (NSString *) mail;
- (NSArray *) defaultKoteHanList;
- (void) setDefaultKoteHanList : (NSArray *) anArray;

/* ŌɊJ */
- (NSString *) browserLastBoard;
- (void) setBrowserLastBoard : (NSString *) boardName;

/* CometBlaster Additions */
- (BOOL) informWhenDetectDatOchi;
- (void) setInformWhenDetectDatOchi: (BOOL) shouldInform;

/* MeteorSweeper Additions */
//- (BOOL) moveFocusToViewerWhenShowThreadAtRow;
//- (void) setMoveFocusToViewerWhenShowThreadAtRow: (BOOL) shouldMove;

/* ReinforceII Hidden Option */
- (BOOL) oldMessageScrollingBehavior;
- (void) setOldMessageScrollingBehavior: (BOOL) flag;

#pragma mark ThreadsList

/* \[g */
- (NSString *) browserSortColumnIdentifier;
- (void) setBrowserSortColumnIdentifier : (NSString *) identifier;
- (BOOL) browserSortAscending;
- (void) setBrowserSortAscending : (BOOL) isAscending;
- (int) browserStatusFilteringMask;
- (void) setBrowserStatusFilteringMask : (int) mask;
- (BOOL) collectByNew;
- (void) setCollectByNew : (BOOL) flag;

/* Search option */
- (CMRSearchMask) contentsSearchOption;
- (void) setContentsSearchOption : (CMRSearchMask) option;

/* Starlight Breaker Additions */
- (BOOL) findPanelExpanded;
- (void) setFindPanelExpanded: (BOOL) isExpanded;
- (NSArray *) contentsSearchTargetArray;
- (void) setContentsSearchTargetArray: (NSArray *) array;

#pragma mark History

- (int) maxCountForThreadsHistory;
- (void) setMaxCountForThreadsHistory : (int) counts;
- (int) maxCountForBoardsHistory;
- (void) setMaxCountForBoardsHistory : (int) counts;
- (int) maxCountForSearchHistory;
- (void) setMaxCountForSearchHistory : (int) counts;
@end



@interface AppDefaults(BackgroundColors)
- (BOOL) browserSTableDrawsStriped;
- (void) setBrowserSTableDrawsStriped : (BOOL) flag;
- (NSColor *) browserSTableBackgroundColor;
- (void) setBrowserSTableBackgroundColor : (NSColor *) color;
- (NSColor *) boardListBackgroundColor;
- (void) setBoardListBackgroundColor : (NSColor *) color;

- (NSColor *) threadViewerBackgroundColor;
- (NSColor *) resPopUpBackgroundColor;
- (NSColor *) replyBackgroundColor;

- (float) resPopUpBgAlphaValue;

- (void) _loadBackgroundColors;
- (BOOL) _saveBackgroundColors;
@end



@interface AppDefaults(Filter)
/*** fXtB^***/
- (BOOL) spamFilterEnabled;
- (void) setSpamFilterEnabled : (BOOL) flag;

// {̌`FbN
- (BOOL) usesSpamMessageCorpus;
- (void) setUsesSpamMessageCorpus : (BOOL) flag;

- (NSString *) spamMessageCorpusStringRepresentation;
- (void) setUpSpamMessageCorpusWithString : (NSString *) aString;


// fXƂ̓F
- (int) spamFilterBehavior;
- (void) setSpamFilterBehavior : (int) mask;

- (void) resetSpamFilter;

// AAD(Ascii Art Detector). Available in MeteorSweeper and later.
- (BOOL) asciiArtDetectorEnabled;
- (void) setAsciiArtDetectorEnabled: (BOOL) flag;

- (void) _loadFilter;
- (BOOL) _saveFilter;
@end



@interface AppDefaults(FontAndColor)
- (BOOL) popUpWindowVerticalScrollerIsSmall;
- (void) setPopUpWindowVerticalScrollerIsSmall : (BOOL) flag;

- (NSColor *) threadsListColor;
- (void) setThreadsListColor : (NSColor *) color;
- (NSFont *) threadsListFont;
- (void) setThreadsListFont : (NSFont *) aFont;
- (NSColor *) threadsListNewThreadColor;
- (void) setThreadsListNewThreadColor : (NSColor *) color;
- (NSFont *) threadsListNewThreadFont;
- (void) setThreadsListNewThreadFont : (NSFont *) aFont;

/* Starlight Breaker -- Theme groups */
- (NSFont *) threadsViewFont;
- (NSColor *) threadsViewColor;
- (NSFont *) messageFont;
- (NSColor *) messageColor;
- (NSFont *) messageTitleFont;
- (NSColor *) messageTitleColor;
- (NSColor *) messageNameColor;
- (NSFont *) messageAlternateFont;
- (NSColor *) messageAnchorColor;
- (NSFont *) messageHostFont;
- (NSColor *) messageHostColor;
- (NSFont *) messageBeProfileFont;
- (NSFont *) messageBookmarkFont;
- (NSColor *) messageBookmarkColor;

- (NSColor *) resPopUpDefaultTextColor;
- (BOOL) isResPopUpTextDefaultColor;
- (NSColor *) replyTextColor;
- (NSFont *) replyFont;
/* End Theme groups */

- (NSColor *) messageFilteredColor;
- (void) setMessageFilteredColor : (NSColor *) color;
- (NSColor *) textEnhancedColor;
- (void) setTextEnhancedColor : (NSColor *) color;

/* boardList font */
- (NSFont *) boardListFont;
- (void) setBoardListFont : (NSFont *) font;
- (NSColor *) boardListTextColor;
- (void) setBoardListTextColor : (NSColor *) color;


/* more options */
- (BOOL) hasMessageAnchorUnderline;
- (void) setHasMessageAnchorUnderline : (BOOL) flag;

- (BOOL) shouldThreadAntialias;
- (void) setShouldThreadAntialias : (BOOL) flag;

- (BOOL) threadsListDrawsGrid;
- (void) setThreadsListDrawsGrid : (BOOL) flag;

/* Row height, cell spacing */
- (float) messageHeadIndent;
- (void) setMessageHeadIndent : (float) anIndent;

/* SledgeHammer Addition */
- (float) msgIdxSpacingBefore;
- (void) setMsgIdxSpacingBefore : (float) aValue;
- (float) msgIdxSpacingAfter;
- (void) setMsgIdxSpacingAfter : (float) aValue;

- (float) threadsListRowHeight;
- (void) setThreadsListRowHeight : (float) rowHeight;
- (void) fixRowHeightToFontSize;

- (float) boardListRowHeight;
- (void) setBoardListRowHeight : (float) rowHeight;
- (void) fixBoardListRowHeightToFontSize;

- (NSDictionary *) boardListTextAttributes; // Available in Starlight Breaker.

- (void) _loadFontAndColor;
- (BOOL) _saveFontAndColor;
@end

@interface AppDefaults(ThreadsListSettings)
- (int) threadsListAutoscrollMask;
- (void) setThreadsListAutoscrollMask : (int) mask;

- (BOOL) useIncrementalSearch;
- (void) setUseIncrementalSearch : (BOOL) TorF;

/* PrincessBride Additions */
- (BOOL) titleRulerViewTextUsesBlackColor;
- (void) setTitleRulerViewTextUsesBlackColor : (BOOL) usesBlackColor;

/* ShortCircuit Additions */
- (id) threadsListTableColumnState;
- (void) setThreadsListTableColumnState : (id) aColumnState;

/* InnocentStarter Additions */
- (BOOL) autoReloadListWhenWake;
- (void) setAutoReloadListWhenWake : (BOOL) doReload;

/* RainbowJerk Additions */
- (NSDate *) lastHEADCheckedDate;
- (void) setLastHEADCheckedDate : (NSDate *) date;
- (BOOL) canHEADCheck;

/* GrafEisen Additions */
- (NSTimeInterval) HEADCheckTimeInterval;
- (void) setHEADCheckTimeInterval : (NSTimeInterval) interval;
- (NSDate *) nextHEADCheckAvailableDate;

- (void) _loadThreadsListSettings;
- (BOOL) _saveThreadsListSettings;
@end

@interface AppDefaults(ThreadViewTheme)
- (BSThreadViewTheme *) threadViewTheme;
- (void) setThreadViewTheme: (BSThreadViewTheme *) aTheme;

- (NSString *) customThemeFilePath;
- (NSString *) createFullPathFromThemeFileName: (NSString *) fileName;

- (NSString *) themeFileName;
- (void) setThemeFileName: (NSString *) fileName;
- (BOOL) usesCustomTheme;
- (void) setUsesCustomTheme: (BOOL) use;

- (NSArray *) installedThemes;
@end


@interface AppDefaults(ThreadViewerSettings)
/* Xbh_E[hƂׂ͂ĕ\ */
- (BOOL) showsAllMessagesWhenDownloaded;
- (void) setShowsAllMessagesWhenDownloaded : (BOOL) flag;

/* IUtCǂݍ */
- (unsigned) onTheFlyCompositionAttributes;
- (void) setOnTheFlyCompositionAttributes : (unsigned) value;

/* uEChËʒuƗ̈Lv */
- (NSString *) windowDefaultFrameString;
- (void) setWindowDefaultFrameString : (NSString *) aString;
- (NSString *) replyWindowDefaultFrameString;
- (void) setReplyWindowDefaultFrameString : (NSString *) aString;

- (int) threadViewerLinkType;
- (void) setThreadViewerLinkType : (int) aType;

- (BOOL) mailAttachmentShown;
- (void) setMailAttachmentShown : (BOOL) flag;
- (BOOL) mailAddressShown;
- (void) setMailAddressShown : (BOOL) flag;

- (int) openInBrowserType;
- (void) setOpenInBrowserType : (int) aType;

/* SledgeHammer Additions */
- (BOOL) showsPoofAnimationOnInvisibleAbone;
- (void) setShowsPoofAnimationOnInvisibleAbone : (BOOL) showsPoof;

/* ShortCircuit Additions */
- (unsigned int) firstVisibleCount;
- (void) setFirstVisibleCount : (unsigned int) aValue;
- (unsigned int) lastVisibleCount;
- (void) setLastVisibleCount : (unsigned int) aValue;

/* SecondFlight Additions */
- (BOOL) previewLinkWithNoModifierKey;
- (void) setPreviewLinkWithNoModifierKey : (BOOL) previewDirectly;

/* InnocentStarter Additions */
- (float) mouseDownTrackingTime;
- (void) setMouseDownTrackingTime : (float) aValue;

/* Vita Additions */
- (BOOL) scrollToLastUpdated;
- (void) setScrollToLastUpdated : (BOOL) flag;

- (void) _loadThreadViewerSettings;
- (BOOL) _saveThreadViewerSettings;
@end



@interface AppDefaults(Account)
- (NSURL *) x2chAuthenticationRequestURL;

- (BOOL) shouldLoginIfNeeded;
- (void) setShouldLoginIfNeeded : (BOOL) flag;
- (BOOL) shouldLoginBe2chAnyTime;
- (void) setShouldLoginBe2chAnyTime : (BOOL) flag;

- (BOOL) hasAccountInKeychain;
- (void) setHasAccountInKeychain : (BOOL) usesKeychain;

- (BOOL) availableBe2chAccount;

- (NSString *) applicationUserAgent;
- (NSString *) x2chUserAccount;
- (void) setX2chUserAccount : (NSString *) account;
- (NSString *) be2chAccountMailAddress;
- (void) setBe2chAccountMailAddress : (NSString *) address;
- (NSString *) be2chAccountCode;
- (void) setBe2chAccountCode : (NSString *) code;
- (NSString *) password;
- (void) loadAccountSettings;
@end



@interface AppDefaults(ChangeAccount)
- (BOOL) changeAccount : (NSString *) newAccount
			  password : (NSString *) newPassword
		  usesKeychain : (BOOL      ) usesKeychain;
- (BOOL) deleteAccount;
@end


@interface AppDefaults(BundleSupport)
- (NSBundle *) moduleWithName : (NSString *) bundleName
					   ofType : (NSString *) type
				  inDirectory : (NSString *) bundlePath;

- (id) _imagePreviewer;
- (id<BSImagePreviewerProtocol>) sharedImagePreviewer;
- (id) _preferencesPane;
- (id) sharedPreferencesPane;
- (id<w2chConnect>) w2chConnectWithURL : (NSURL        *) anURL
                            properties : (NSDictionary *) properties;

- (NSString *) helperAppPath;
- (void) setHelperAppPath : (NSString *) fullPath_;
- (NSString *) helperAppDisplayName;

- (void) _loadImagePreviewerSettings;
- (BOOL) _saveImagePreviewerSettings;
@end

/* Vita Additions */
@interface AppDefaults(Sounds)
- (NSString *) HEADCheckNewArrivedSound;
- (void) setHEADCheckNewArrivedSound : (NSString *) soundName;
- (NSString *) HEADCheckNoUpdateSound;
- (void) setHEADCheckNoUpdateSound : (NSString *) soundName;
- (NSString *) replyDidFinishSound;
- (void) setReplyDidFinishSound : (NSString *) soundName;

- (void) _loadSoundsSettings;
- (BOOL) _saveSoundsSettings;
@end

/* MeteorSweeper Additions */
@interface AppDefaults(BoardWarriorSupport)
- (void) letBoardWarriorStartSyncing: (id) sender;

- (NSURL *) BBSMenuURL;
- (void) setBBSMenuURL: (NSURL *) anURL;

- (BOOL) autoSyncBoardList;
- (void) setAutoSyncBoardList: (BOOL) autoSync;

- (BSAutoSyncIntervalType) autoSyncIntervalTag;
- (void) setAutoSyncIntervalTag: (BSAutoSyncIntervalType) aType;

- (NSTimeInterval) timeIntervalForAutoSyncPrefs;

- (NSDate *) lastSyncDate;
- (void) setLastSyncDate: (NSDate *) finishedDate;

- (void) _loadBWSettings;
- (BOOL) _saveBWSettings;
@end

#pragma mark Constants

extern NSString *const AppDefaultsWillSaveNotification;
