//
//  SmartBLIEditorHelper-SmartConditionAccesor.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 09/02/20.
//  Copyright 2009 masakih. All rights reserved.
//

#import "SmartBLIEditorHelper.h"

//#import "BSDatePicker.h"

@implementation SmartBLIEditorHelper(SmartConditionAccesor)

- (id)value1
{
	id value1 = [NSNull null];
	QualifierMenuItemTags qualifier = [self currentQualifierItemTag];
	id field;
	id strValue;
	
	{
		if(qualifier < isEqualQualifierItemTag) {	// 文字列
			field = [self uiItemForTag:stringExpressionFieldTag];
			strValue = [field stringValue];
			if([strValue length] != 0) {
				value1 = strValue;
			}
		} else if(qualifier < daysItemExtension) {	// 数字
			field = [self uiItemForTag:numberExpressionFieldTag];
			strValue = [field stringValue];
			if([strValue length] != 0) {
				int v = [field intValue];
				value1 = [NSNumber numberWithInt:v];
			}
		} else if(qualifier < dateItemExtension) {	// 相対日付
			field = [self uiItemForTag:daysExpressionFieldTag];
			strValue = [field stringValue];
			if([strValue length] != 0) {
				int v = [field intValue];
				v *= [[[self uiItemForTag:daysUnitPopUpTag] selectedItem] tag];
				value1 = [NSNumber numberWithInt:-1 * v];
			}
		} else if(qualifier < lastExtensionsLabel) { // 絶対日付
			field = [self uiItemForTag:dateExpressionFieldTag];
			strValue = [field stringValue];
			if([strValue length] != 0) {
				NSTimeInterval t = [[field dateValue] timeIntervalSince1970];
				value1 = [NSNumber numberWithDouble:t];
			}
		} else {
			//
			//
		}
	}
	
	return value1;
}
- (id)value2
{
	id value2 = nil;
	QualifierMenuItemTags qualifier = [self currentQualifierItemTag];
	id field;
	id strValue;
	
	{
		if(qualifier < isEqualQualifierItemTag) {	// 文字列
			//
		}else if(qualifier < daysItemExtension) {	// 数字
			if(qualifier == rangeQualifierItemTag) {
				field = [self uiItemForTag:numberExpression2FieldTag];
				strValue = [field stringValue];
				if([strValue length] != 0) {
					int v = [field intValue];
					value2 = [NSNumber numberWithInt:v];
				} else {
					value2 = [NSNull null];
				}
			}
		} else if(qualifier < dateItemExtension) {	// 相対日付
			if(qualifier == daysRangeQualifierItemTag) {
				field = [self uiItemForTag:daysExpressionField2Tag];
				strValue = [field stringValue];
				if([strValue length] != 0) {
					int v = [field intValue];
					v *= [[[self uiItemForTag:daysUnitPopUpTag] selectedItem] tag];
					value2 = [NSNumber numberWithInt:-1 * v];
				} else {
					value2 = [NSNull null];
				}
			}
		} else if(qualifier < lastExtensionsLabel) { // 絶対日付
			if(qualifier == dateRangeQualifierItemTag) {
				field = [self uiItemForTag:dateExpression2FieldTag];
				strValue = [field stringValue];
				if([strValue length] != 0) {
					NSTimeInterval t = [[field dateValue] timeIntervalSince1970];
					value2 = [NSNumber numberWithInt:t];
				} else {
					value2 = [NSNull null];
				}
			}
		} else {
			//
			//
		}
	}
	
	return value2;
}
- (BOOL)isValidAItem
{
	if([self value1] == [NSNull null] || [self value2] == [NSNull null]) {
		return NO;
	}
	
	return YES;
}
- (BOOL)isValid
{
	SmartBLIEditorHelper *helper = [self rootHelper];
	
	while(helper = [helper nextHelper]) {
		if(![helper isValidAItem]) {
			return NO;
		}
	}
	
	return YES;
}
- (SmartCondition *)aCondition
{
	SmartCondition *result;
	
	NSString *criterion;
	id value1, value2 = nil;
	
	SCOperator operator = SCUnknownOperator;
	QualifierMenuItemTags qualifier = [self currentQualifierItemTag];
	
	int tag;
	NSString *typesKey;
	id criteria;
	
	if(self == [self rootHelper]) return nil;
	
	{
		switch(qualifier) {
			case containsQualifierItemTag:
				operator = SCContaionsOperator;
				break;
			case notContainsQualifierItemTag:
				operator = SCNotContainsOperator;
				break;
			case exactQualifierItemTag:
				operator = SCExactOperator;
				break;
			case notExactQualifierItemTag:
				operator = SCNotExactOperator;
				break;
			case beginsWithQualifierItemTag:
				operator = SCBeginsWithOperator;
				break;
			case endsWithQualifierItemTag:
				operator = SCEndsWithOperator;
				break;
			case isEqualQualifierItemTag:
				operator = SCEqualOperator;
				break;
			case notEqualQualifierItemTag:
				operator = SCNotEqualOperator;
				break;
			case largerThanQualifierItemTag:
				operator = SCLargerOperator;
				break;
			case smallerThanQualifierItemTag:
				operator = SCSmallerOperator;
				break;
			case rangeQualifierItemTag:
				operator = SCRangeOperator;
				break;
			case daysTodayQualifierItemTag:
				operator = SCDaysTodayOperator;
				break;
			case daysYesterdayQualifierItemTag:
				operator = SCDaysYesterdayOperator;
				break;
			case daysThisWeekQualifierItemTag:
				operator = SCDaysThisWeekOperator;
				break;
			case daysLastWeekQualifierItemTag:
				operator = SCDaysLastWeekOperator;
				break;
			case daysIsEqualQualifierItemTag:
				operator = SCDaysEqualOperator;
				break;
			case daysLargerThanQualifierItemTaag:
				operator = SCDaysLargerOperator;
				break;
			case daysSmallerThanQualifierItemTag:
				operator = SCDaysSmallerOperator;
				break;
			case daysRangeQualifierItemTag:
				operator = SCDaysRangeOperator;
				break;
			case dateIsEqualQualifierItemTag:
				operator = SCDateEqualOperator;
				break;
			case dateNotEqualQualifierItemTag:
				operator = SCDateNotEqualOperator;
				break;
			case dateLargerThanQualifierItemTaag:
				operator = SCDateLargerOperator;
				break;
			case dateSmallerThanQualifierItemTag:
				operator = SCDateSmallerOperator;
				break;
			case dateRangeQualifierItemTag:
				operator = SCDateRangeOperator;
				break;
			default:
				operator = -1;
				break;
		}
		
		if(operator == -1) {
			return nil;
		}
	}
	
	tag = [[[self uiItemForTag:criterionPopUpTag] selectedItem] tag];
	typesKey = [NSString stringWithFormat:@"%d", tag];
	criteria = [[[self class] criteriaSpecifications] objectForKey:CriteriaSpecificationsCriteriaKey];
	criterion = [[criteria objectForKey:typesKey] objectForKey:CriteriaNameKey];
	
	value1 = [self value1];
	value2 = [self value2];
	if(value1 == [NSNull null] || value2 == [NSNull null]) {
		return nil;
	}
	
	{
		//
		if(value2) {
			result = [SmartCondition conditionWithTarget:criterion
												operator:operator
												   value:value1
												   value:value2];
		} else {
			result = [SmartCondition conditionWithTarget:criterion
												operator:operator
												   value:value1];
		}
	}
	
	return result;
}

- (SmartConditionComposit *)compositCondition
{
	NSMutableArray *array;
	SmartBLIEditorHelper *helper;
	SCCOperator ope;
	
	if(self != [self rootHelper]) return nil;
	
	array = [NSMutableArray array];
	helper = self;
	while((helper = [helper nextHelper])) {
		id cond = [helper aCondition];
		if(cond) {
			[array addObject:cond];
		}
	}
	
	ope = [[allOrAnyPopUp selectedItem] tag];
	
	return [[[SmartConditionComposit alloc] initCompositWithOperator:ope
														  conditions:array] autorelease];
}

- (id<SmartCondition>)condition
{
	// TODO ダット落ちと広告スレの条件付加
	
	return [[self rootHelper] compositCondition];
}


#pragma mark-
#pragma mark Edit SmartItem
- (CriterionMenuItemTags)tagFromConditionKey:(NSString *)key
{
	if(!key || ![key isKindOfClass:[NSString class]]) return -1;
	
	if([key isEqualTo:@"boardName"]) {
		return boardNameItemTag;
	} else if([key isEqualTo:@"threadName"]) {
		return threadNameItemTag;
	} else if([key isEqualTo:@"numberOfAll"]) {
		return numberOfResponseItemTag;
	} else if([key isEqualTo:@"numberOfRead"]) {
		return numberOfReadItemTag;
	} else if([key isEqualTo:@"numberOfDifference"]) {
		return numberOfUnreadItemTag;
	} else if([key isEqualTo:@"threadID"]) {
		return dateOfThreadCreateItemTag;
	} else if([key isEqualTo:@"modifiedDate"]) {
		return dateOfModifierItemTag;
	} else if([key isEqualTo:@"LastWrittenDate"]) {
		return dateOfLastWritenItemTag;
	}
	
	return -1;
}
- (UIItemTags)valueFieldTagFromCondition:(SmartCondition *)condition
{		
	if([condition isKindOfClass:[StringCondition class]]) {
		return stringExpressionFieldTag;
	} else if([condition isKindOfClass:[NumberCondition class]]) {
		return numberExpressionFieldTag;
	} else if([condition isKindOfClass:[RelativeDateLiveCondition class]]) {
		return daysExpressionFieldTag;
	} else if([condition isKindOfClass:[AbsoluteDateLiveCondition class]]) {
		return dateExpressionFieldTag;
	} else if([condition isKindOfClass:[DaysCondition class]]) {
		return dateQualifierPopUpTag;
	}
	
	return -1;
}
- (UIItemTags)value2FieldTagFromCondition:(SmartCondition *)condition
{
	if([condition isKindOfClass:[StringCondition class]]) {
		return -1;
	} else if([condition isKindOfClass:[NumberCondition class]]) {
		return numberExpression2FieldTag;
	} else if([condition isKindOfClass:[RelativeDateLiveCondition class]]) {
		return daysExpressionField2Tag;
	} else if([condition isKindOfClass:[AbsoluteDateLiveCondition class]]) {
		return dateExpression2FieldTag;
	} else if([condition isKindOfClass:[DaysCondition class]]) {
		return -1;
	}
	
	return -1;
}
- (QualifierMenuItemTags)qualifierMenuItemTagFromCondition:(SmartCondition *)condition
{
	int result = -1;
	
	switch([condition operator]) {
		case SCContaionsOperator:
			result = containsQualifierItemTag;
			break;
		case SCNotContainsOperator:
			result = notContainsQualifierItemTag;
			break;
		case SCExactOperator:
			result = exactQualifierItemTag;
			break;
		case SCNotExactOperator:
			result = notExactQualifierItemTag;
			break;
		case SCBeginsWithOperator:
			result = beginsWithQualifierItemTag;
			break;
		case SCEndsWithOperator:
			result = endsWithQualifierItemTag;
			break;
		case SCEqualOperator:
			result = isEqualQualifierItemTag;
			break;
		case SCNotEqualOperator:
			result = notEqualQualifierItemTag;
			break;
		case SCLargerOperator:
			result = largerThanQualifierItemTag;
			break;
		case SCSmallerOperator:
			result = smallerThanQualifierItemTag;
			break;
		case SCRangeOperator:
			result = rangeQualifierItemTag;
			break;
		case SCDaysTodayOperator:
			result = daysTodayQualifierItemTag;
			break;
		case SCDaysYesterdayOperator:
			result = daysYesterdayQualifierItemTag;
			break;
		case SCDaysThisWeekOperator:
			result = daysThisWeekQualifierItemTag;
			break;
		case SCDaysLastWeekOperator:
			result = daysLastWeekQualifierItemTag;
			break;
		case SCDaysEqualOperator:
			result = daysIsEqualQualifierItemTag;
			break;
		case SCDaysNotEqualOperator:
			//
			break;
		case SCDaysLargerOperator:
			result = daysLargerThanQualifierItemTaag;
			break;
		case SCDaysSmallerOperator:
			result = daysSmallerThanQualifierItemTag;
			break;
		case SCDaysRangeOperator:
			result = daysRangeQualifierItemTag;
			break;
		case SCDateEqualOperator:
			result = dateIsEqualQualifierItemTag;
			break;
		case SCDateNotEqualOperator:
			result = dateNotEqualQualifierItemTag;
			break;
		case SCDateLargerOperator:
			result = dateLargerThanQualifierItemTaag;
			break;
		case SCDateSmallerOperator:
			result = dateSmallerThanQualifierItemTag;
			break;
		case SCDateRangeOperator:
			result = dateRangeQualifierItemTag;
			break;
		default:
			//
			break;
	}
	
	return result;
}
- (UIItemTags)qualifierPopupTagFromCondition:(SmartCondition *)condition
{
	int result = -1;
	
	switch([condition operator]) {
		case SCContaionsOperator:
		case SCNotContainsOperator:
		case SCExactOperator:
		case SCNotExactOperator:
		case SCBeginsWithOperator:
		case SCEndsWithOperator:
			result = stringQualifierPopUpTag;
			break;
		case SCEqualOperator:
		case SCNotEqualOperator:
		case SCLargerOperator:
		case SCSmallerOperator:
		case SCRangeOperator:
			result = numberQualifierPopUpTag;
			break;
		case SCDaysTodayOperator:
		case SCDaysYesterdayOperator:
		case SCDaysThisWeekOperator:
		case SCDaysLastWeekOperator:
		case SCDaysEqualOperator:
		case SCDaysNotEqualOperator:
		case SCDaysLargerOperator:
		case SCDaysSmallerOperator:
		case SCDaysRangeOperator:
		case SCDateEqualOperator:
		case SCDateNotEqualOperator:
		case SCDateLargerOperator:
		case SCDateSmallerOperator:
		case SCDateRangeOperator:
			result = dateQualifierPopUpTag;
			break;
		default:
			//
			break;
	}
	
	return result;
}
- (BOOL)setRelaviceDateValueFromCondition:(SmartCondition *)condition
{
	NSNumber *v1 = [condition value];
	NSNumber *v2 = [condition value2];
	long value1 = [v1 longValue] * -1;
	long value2 = [v2 longValue] * -1;
	int tag = -1;
	
	const long hourUnit = 3600;
	const long dayUnit = 86400;
	const long weekUnit = 604800;
	const long monthUnit = 2592000;
	
	if(value1 % monthUnit == 0) {
		if(!v2 || value2 % monthUnit == 0) {
			tag = monthUnit;
		}
	} else if(value1 % weekUnit == 0) {
		if(!v2 || value2 % weekUnit) {
			tag = weekUnit;
		}
	} else if(value1 % dayUnit == 0) {
		if(!v2 || value2 % dayUnit == 0) {
			tag = dayUnit;
		}
	} else if(value1 % hourUnit == 0) {
		if(!v2 || value2 % hourUnit == 0) {
			tag = hourUnit;
		}
	}
	
	if(tag == -1) return NO;
	
	id unitPopUp = [self uiItemForTag:daysUnitPopUpTag];
	int index = [unitPopUp indexOfItemWithTag:tag];
	[unitPopUp selectItemAtIndex:index];
	
	id valueCtrl = [self uiItemForTag:daysExpressionFieldTag];
	[valueCtrl setIntValue:value1 / tag];
	
	if(v2) {
		valueCtrl = [self uiItemForTag:daysExpressionField2Tag];
		[valueCtrl setIntValue:value2 / tag];
	}
	
	return YES;
}
- (BOOL)setAbsoluteDateValueFromCondition:(SmartCondition *)condition
{
	NSNumber *v1 = [condition value];
	NSNumber *v2 = [condition value2];	
	
	id valueCtrl = [self uiItemForTag:dateExpressionFieldTag];
	[valueCtrl setDateValue:[NSCalendarDate dateWithTimeIntervalSince1970:[v1 doubleValue]]];
	
	if(v2) {
		valueCtrl = [self uiItemForTag:dateExpression2FieldTag];
		[valueCtrl setDateValue:[NSCalendarDate dateWithTimeIntervalSince1970:[v2 doubleValue]]];
	}
	
	return YES;
}

- (BOOL)buildAHelperFromSmartCondition:(SmartCondition *)condition
{
	id key, v1, v2 = nil;
	
	if(self == [self rootHelper]) return NO;
	
	if([condition isKindOfClass:[IncludeDatOtiCondition class]]) {
		[[self rootHelper]->includeFallInDATCheck setState:NSOnState];
		return YES;
	}
	if([condition isKindOfClass:[ExcludeAdThreadCondition class]]) {
		[[self rootHelper]->excludeAdThreadCheck setState:NSOnState];
		return YES;
	}
	
	key = [condition key];
	v1 = [condition value];
	if(SCRangeOperator == [condition operator]) {
		v2 = [condition value2];
	}
	
	// key から　CriterionMenu　を選択
	int tag = [self tagFromConditionKey:key];
	if(tag == -1) return NO;
	
	int index = [[self uiItemForTag:criterionPopUpTag] indexOfItemWithTag:tag];
	[[self uiItemForTag:criterionPopUpTag] selectItemAtIndex:index];
	// QualifierMenuItemTags をセット
	tag = [self qualifierMenuItemTagFromCondition:condition];
	if(tag == -1) return NO;
	int popupTag = [self qualifierPopupTagFromCondition:condition];
	if(popupTag == -1) return NO;
	index = [[self uiItemForTag:popupTag] indexOfItemWithTag:tag];
	[[self uiItemForTag:popupTag] selectItemAtIndex:index];
	[self builExpressionViews];
	
	// 値をセット
	int valueCtrlTag;
	id valueCtrl;
	
	if([condition isKindOfClass:[RelativeDateLiveCondition class]]) {
		return [self setRelaviceDateValueFromCondition:condition];
	}
	if([condition isKindOfClass:[AbsoluteDateLiveCondition class]]) {
		return [self setAbsoluteDateValueFromCondition:condition];
	}
	
	valueCtrlTag = [self valueFieldTagFromCondition:condition];
	if(valueCtrlTag == dateQualifierPopUpTag) {
		return YES;
	}
	valueCtrl = [self uiItemForTag:valueCtrlTag];
	[valueCtrl setObjectValue:v1];
	
	if(!v2) return YES;
	
	valueCtrlTag = [self value2FieldTagFromCondition:condition];
	valueCtrl = [self uiItemForTag:valueCtrlTag];
	[valueCtrl setObjectValue:v2];
	
	return YES;
}

- (BOOL)buildHelpers:(id<SmartCondition>)condition
{
	if([condition isKindOfClass:[SmartCondition class]]) {
		id newHelper;
		
		newHelper = [[[[self class] alloc] init] autorelease];
		[newHelper loadComponent];
		[self addHelper:newHelper];
		[newHelper addConditionView];
		
		return [newHelper buildAHelperFromSmartCondition:condition];
	}
	
	if(![condition isKindOfClass:[SmartConditionComposit class]]) {
		return NO;
	}
	
	SmartConditionComposit *conditions = condition;
	NSEnumerator *condsEnum = [[conditions conditions] objectEnumerator];
	id cond;
	while(cond = [condsEnum nextObject]) {
		BOOL res = [self buildHelpers:cond];
		if(!res) return NO;
	}
	
	return YES;
}
- (BOOL)buildHelperFromCondition:(id<SmartCondition>)condition
{
	if(self != [self rootHelper]) return NO;
	
	// SmartConditionComposit でなければならない。
	if(![condition isKindOfClass:[SmartConditionComposit class]]) return NO;
	
	// すべて もしくは または
	int tag = [condition operator];
	[allOrAnyPopUp selectItemAtIndex:[allOrAnyPopUp indexOfItemWithTag:tag]];
	
	[includeFallInDATCheck setState:NSOffState];
	[excludeAdThreadCheck setState:NSOffState];
	
	if(![self buildHelpers:condition]) {
		return NO;
	}
	
	[[self nextHelper] removeConditionView];
	
	return YES;
}

@end
