//
//  BSIPIPathTransformer.m
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 06/07/10.
//  Copyright 2006-2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSIPIPathTransformer.h"


@implementation BSIPIPathTransformer
+ (Class)transformedValueClass
{
    return [NSString class];
}
 
+ (BOOL)allowsReverseTransformation
{
    return NO;
}
 
- (id)transformedValue:(id)beforeObject
{
    if (!beforeObject) {
        return nil;
    }

    if ([beforeObject isKindOfClass:[NSURL class]]) {
        beforeObject = [beforeObject absoluteString];
    }

    return [beforeObject lastPathComponent];
}
@end


@implementation BSIPIImageIgnoringDPITransformer
+ (Class)transformedValueClass
{
    return [NSImage class];
}

+ (BOOL)allowsReverseTransformation
{
    return NO;
}

- (id)transformedValue:(id)beforeObject
{
    if (!beforeObject || ![beforeObject isKindOfClass:[NSString class]]) {
        return nil;
    }

    NSImage *image_ = [[NSImage alloc] initWithContentsOfFile:beforeObject];
    if (!image_) {
        return nil;
    }
    float wi, he;
    NSSize newSize;
    NSImageRep  *tmp_ = [image_ bestRepresentationForDevice:nil];
    
    wi = [tmp_ pixelsWide];
    he = [tmp_ pixelsHigh];
    newSize = NSMakeSize(wi, he);
    // ignore DPI
    [tmp_ setSize:newSize];

    NSImage *newImage = [[NSImage alloc] initWithSize:newSize];
    [newImage addRepresentation:tmp_];
    [image_ release];
    return [newImage autorelease];
}
@end
