//: SGInternalMessenger.h
/**
  * $Id: SGInternalMessenger.h,v 1.1.1.1 2005-05-11 17:51:05 tsawada2 Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.  All rights reserved.
  * See the file LICENSE for copying permission.
  */

/*!
 * @header     SGInternalMessenger
 * @discussion SGInternalMessengerNX
 */

#import <Foundation/Foundation.h>


@protocol SGInternalMessaging
- (void) invokeMessage : (NSInvocation *) anInvocation
            withResult : (BOOL          ) aResultFlag;
@end


/*!
 * @class      SGInternalMessenger
 * @abstract   XbhԂ̃bZ[WʐMsNX
 *
 * @discussion SGInternalMessenger͕ʂ̃XbhɃbZ[W
 *             Ƃ̃C^[tF[XƂȂNXłB
 *             NX̃CX^X͐ꂽ_̃Xbh
 *             炩̃RlNVm܂BꂽbZ
 *             [W͎M̃XbhŎs܂Bʂ
 *             ꍇ͎M̏I܂ŃubN
 *             Aʂ𖳎ꍇ̓bZ[W𑗐MI
 *             _őɖ߂܂B
 */
@interface SGInternalMessenger : NSObject<SGInternalMessaging>

/*!
 * @method     currentMessenger
 * @abstract   ݂Thread(RunLoop)ƒʐMMessenger
 * @discussion ݂Thread(RunLoop)ƒʐMMessengerCX^XԂ܂B
 *
 * @result     CX^X
 */
+ (id) currentMessenger;

- (void)  target : (id ) aTarget
 performSelector : (SEL) aSelector;

- (void)  target : (id ) aTarget
 performSelector : (SEL) aSelector
      withObject : (id ) anObject;

- (void)  target : (id ) aTarget
 performSelector : (SEL) aSelector
      withObject : (id ) anObject
      withObject : (id ) anotherObject;

- (id)    target : (id  ) aTarget
 performSelector : (SEL ) aSelector
      withResult : (BOOL) aResultFlag;

- (id)    target : (id  ) aTarget
 performSelector : (SEL ) aSelector
      withObject : (id  ) anObject
      withResult : (BOOL) aResultFlag;

- (id)    target : (id  ) aTarget
 performSelector : (SEL ) aSelector
      withObject : (id  ) anObject
      withObject : (id  ) anotherObject
      withResult : (BOOL) aResultFlag;

// ʒm
- (void) postNotification : (NSNotification *) aNotification
			 synchronized : (BOOL            ) sync;

// 񓯊
- (void) postNotification : (NSNotification *) aNotification;
- (void) postNotificationName : (NSString     *) aNotificationName
					   object : (id            ) anObject;
- (void) postNotificationName : (NSString     *) aNotificationName
					   object : (id            ) anObject
					 userInfo : (NSDictionary *) aUserInfo;
@end



@interface SGInternalMessenger(CMXAdditions)
- (void *)    target : (id    ) aTarget
     performSelector : (SEL   ) aSelector
            argument : (void *) param2
          withResult : (BOOL  ) aResultFlag;
- (void *)    target : (id    ) aTarget
     performSelector : (SEL   ) aSelector
            argument : (void *) param1
            argument : (void *) param2
          withResult : (BOOL  ) aResultFlag;
@end


extern NSString *const SGInternalMessengerSendException;
