//:BoardManager_p.h
// encoding="UTF-8"

#import "BoardManager.h"
#import "AppDefaults.h"
#import "CocoMonar_Prefix.h"
#import "SmartBoardList.h"

#import <AppKit/NSApplication.h>



@interface BoardManager(Notification)
- (void)boardListDidChange:(NSNotification *)notification;
- (BOOL)saveListsIfNeeded;
@end


@interface BoardManager(PrivateUtilities)
- (id)entryForBoardName:(NSString *)aBoardName;
- (id)valueForBoard:(NSString *)boardName key:(NSString *)key defaultValue:(id)value;
- (void)setValue:(id)value forKey:(NSString *)key atBoard:(NSString *)boardName;
- (void)removeValueForKey:(NSString *)key atBoard:(NSString *)boardName;
- (NSString *)stringValueForBoard:(NSString *)boardName key:(NSString *)key defaultValue:(NSString *)value;
- (void)setStringValue:(NSString *)value withKey:(NSString *)key forBoard:(NSString *)boardName;
- (BOOL)boolValueForBoard:(NSString *)boardName key:(NSString *)key defaultValue:(BOOL)value;
- (void)setBoolValue:(BOOL)value forKey:(NSString *)key atBoard:(NSString *)boardName;
@end


extern NSString *const NNDTenoriTigerSortDescsKey;
