//
//  BSTGrepResult.m
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 10/09/20.
//  Copyright 2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSTGrepResult.h"
#import "CMRThreadLinkProcessor.h"
#import "CMRThreadSignature.h"


@implementation BSTGrepResult
- (id)initWithOrder:(NSString *)orderStr URL:(NSString *)URLStr title:(NSString *)titleContainsBoldTag
{
    if (self = [super init]) {
        NSMutableString *tmp = [titleContainsBoldTag mutableCopy];
        [tmp replaceOccurrencesOfString:@"<b>" withString:@"" options:NSLiteralSearch range:NSMakeRange(0, [tmp length])];
        [tmp replaceOccurrencesOfString:@"</b>" withString:@"" options:NSLiteralSearch range:NSMakeRange(0, [tmp length])];
        m_threadTitle = [[NSString alloc] initWithString:tmp];
        [tmp release];
        m_order = [orderStr unsignedIntegerValue];
        m_threadURLString = [URLStr retain];
    }
    return self;
}

- (void)dealloc
{
    [m_threadTitle release];
    [m_threadURLString release];
    [super dealloc];
}

- (NSUInteger)order
{
    return m_order;
}

- (NSString *)threadURLString
{
    return m_threadURLString;
}

- (NSString *)threadTitle
{
    return m_threadTitle;
}

- (NSURL *)threadURL
{
    return [NSURL URLWithString:[self threadURLString]];
}

- (NSString *)boardName
{
    NSString *result = nil;
    [CMRThreadLinkProcessor parseThreadLink:[self threadURL] boardName:&result boardURL:NULL filepath:NULL];
    return result;
}

- (CMRThreadSignature *)threadSignature
{
    NSString *path = nil;
    [CMRThreadLinkProcessor parseThreadLink:[self threadURL] boardName:NULL boardURL:NULL filepath:&path];
    if (!path) {
        return nil;
    }
    return [CMRThreadSignature threadSignatureFromFilepath:path];
}
@end
