/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


var gB2rService = XPC.getService("@bbs2ch.sourceforge.jp/b2r-global-service;1", "b2rIGlobalService");
var gB2rStorageService = XPC.getService("@bbs2ch.sourceforge.jp/b2r-storage-service;1", "b2rIStorageService");
var gPref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");

var gBoardListBox;
var gLogDataTree;
var gThreadItems;

/**
 * 開始時の処理
 */
function startup(){
	gBoardListBox = document.getElementById("boardListBox");
	gLogDataTree = document.getElementById("logDataTree");

	setTimeout("delayStartup()", 0);
}

function delayStartup(){
	initBoardListBox();
	gBoardListBox.selectItem(gBoardListBox.getItemAtIndex(0));
}

/**
 * 終了時の処理
 */
function shutdown(){
	gLogDataTree.view = null;
}


/**
 * ブラウザへのイベントフロー抑制
 */
function eventBubbleCheck(aEvent){
	// オートスクロールや Find As You Type を抑制しつつキーボードショートカットを許可
	if(!(aEvent.ctrlKey || aEvent.shiftKey || aEvent.altKey || aEvent.metaKey))
		aEvent.stopPropagation();
}

function vacuum(){
	document.getElementById("vacuumButton").disabled = true;
	setTimeout("delayVacuum()", 0);
}

function delayVacuum(){
	var database = gB2rStorageService.database;
	var beforeDatabaseSize = database.databaseFile.clone().fileSize / 1024;

		// スレを読んだことのない板情報を削除
	database.beginTransaction();
	try{
		database.executeSimpleSQL("DELETE FROM board_data WHERE board_id IN (SELECT board_id FROM board_data EXCEPT SELECT board_id FROM thread_data);");
		database.executeSimpleSQL("DELETE FROM board_subject WHERE board_id IN (SELECT board_id FROM board_subject EXCEPT SELECT board_id FROM thread_data);");
	}catch(ex){
		Components.utils.reportError(ex);
	}finally{
		database.commitTransaction();
	}

	database.executeSimpleSQL("VACUUM");
	var afterDatabaseSize = database.databaseFile.clone().fileSize / 1024;
	alert("データベースを最適化しました\n" + beforeDatabaseSize +"KB > "+ afterDatabaseSize +"KB");
	document.getElementById("vacuumButton").disabled = false;
}

function initBoardListBox(){
	while(gBoardListBox.hasChildNodes()){
		gBoardListBox.removeChild(gBoardListBox.firstChild);
	}

	gBoardListBox.appendItem("(すべて)", "");

	var sql = <>
		SELECT
		    td.board_id AS board_id,
		    IFNULL(bb.board_type, 0) AS board_type,
		    IFNULL(bb.title, td.board_id) AS board_title,
		    td.url AS url
		FROM thread_data AS td LEFT OUTER JOIN bbsmenu AS bb
		ON td.board_id=bb.board_id
		GROUP BY td.board_id;
	</>.toString().replace(/\t/g, "");

	var ioService = XPC.getService("@mozilla.org/network/io-service;1", "nsIIOService");

	var database = gB2rStorageService.database;
	var statement = database.createStatement(sql);
	database.beginTransaction();
	try{
		while(statement.executeStep()){
			var boardID = statement.getString(0);
			var boardType = statement.getInt32(1);
			var boardTitle = statement.getString(2);
			var threadURL = ioService.newURI(statement.getString(3), null, null);
			var boardURL = gB2rService.threadUtils.getBoardURL(threadURL).spec;
			if(boardType == gB2rService.BOARD_TYPE_MACHI){
				boardTitle += " [まちBBS]";
			}
			var item = gBoardListBox.appendItem(boardTitle, boardID);
			item.setAttribute("boardURL", boardURL);
		}
	}catch(ex){
		Components.utils.reportError(ex);
	}finally{
		statement.reset();
		database.commitTransaction();
	}
}


function boardListBoxSelect(){
	if(gBoardListBox.selectedItem){
		initLogDataTree(gBoardListBox.selectedItem.value);
	}
}


function boardListBoxContextShowCheck(aEvent){
	var target = aEvent.explicitOriginalTarget;
	return (target.localName=="listitem" && target.value!="");
}


function openBoard(aEvent, aAddTab){
	var boardURL = gBoardListBox.selectedItem.getAttribute("boardURL");

	gB2rService.openURL("bbs2ch:board:" + boardURL, null, aAddTab);
}


function deleteBoardLog(aEvent){
	var boardID = gBoardListBox.selectedItem.value;
	var boardURL = gBoardListBox.selectedItem.getAttribute("boardURL");

	var database = gB2rStorageService.database;

	database.beginTransaction();
	try{
		database.executeSimpleSQL("DELETE FROM board_subject WHERE board_id='" + boardID + "';");
		database.executeSimpleSQL("DELETE FROM board_data WHERE board_id='" + boardID + "';");
		database.executeSimpleSQL("DELETE FROM thread_data WHERE board_id='" + boardID + "';");
	}catch(ex){
		Components.utils.reportError(ex);
	}finally{
		database.commitTransaction();
	}

	initBoardListBox();
	gBoardListBox.selectItem(gBoardListBox.getItemAtIndex(0));
	setTimeout("initLogDataTree(0)", 0);
}


function initLogDataTree(aBoardID){
	var where = ";";
	if(aBoardID != ""){
		where = "WHERE td.board_id='" + aBoardID + "'";
	}
	var sql = <>
		SELECT DISTINCT
		    td.title AS title,
		    td.line_count AS read,
		    td.dat_id AS dat_id,
		    td.board_id AS board_id,
		    IFNULL(bb.board_type, 0) AS board_type,
		    IFNULL(bb.title, td.board_id) AS board_title,
		    td.url
		FROM thread_data AS td LEFT OUTER JOIN bbsmenu AS bb
		ON td.board_id=bb.board_id
		{where}
	</>.toString().replace(/\t/g, "");

	gThreadItems = new Array();

	var database = gB2rStorageService.database;
	var statement = database.createStatement(sql);
	database.beginTransaction();
	try{
		while(statement.executeStep()){
			var treeItem = {};
			treeItem.title = statement.getString(0);
			treeItem.read = statement.getInt32(1);
			treeItem.datID = statement.getString(2);
			treeItem.boardID = statement.getString(3);
			treeItem.boardType = statement.getInt32(4);
			treeItem.boardTitle = statement.getString(5);
			treeItem.url = statement.getString(6);
			if(treeItem.boardType == gB2rService.BOARD_TYPE_MACHI){
				treeItem.boardTitle += " [まちBBS]";
			}
			gThreadItems.push(treeItem);
		}
	}catch(ex){
		Components.utils.reportError(ex);
	}finally{
		statement.reset();
		database.commitTransaction();
	}

	gLogDataTree.view = new LogDataTreeView(gThreadItems);
}



/**
 * gLogDataTree のクリックされたアイテムのインデックスを返す
 * アイテム以外をクリックしたときは、-1 を返す
 * @param aEvent event onClick のイベント
 * @return number アイテムのインデックス
 */
function getClickItemIndex(aEvent){
	var row = {}
	var obj = {}
	gLogDataTree.treeBoxObject.getCellAt(aEvent.clientX, aEvent.clientY, row, {}, obj);
	if(!obj.value) return -1;
	return row.value;
}

/**
 * 選択中のスレッドのインデックスを配列として返す
 * @return array
 */
function getSelectionIndices(){
	var resultArray = new Array();

	var rangeCount = gLogDataTree.treeBoxObject.view.selection.getRangeCount();
	for(var i=0; i<rangeCount; i++){
		var rangeMin = {};
		var rangeMax = {};

		gLogDataTree.treeBoxObject.view.selection.getRangeAt(i, rangeMin, rangeMax);
		for (var j=rangeMin.value; j<=rangeMax.value; j++){
			resultArray.push(j);
		}
	}
	return resultArray;
}


function openThread(aEvent, aAddTab){
	var selectionIndices = getSelectionIndices();

	var index = selectionIndices[0];
		// スレッド表示数の制限
	var threadViewLimit = Number(gPref.getIntPref("extensions.bbs2chreader.board_thread_view_limit"));
	if(isNaN(threadViewLimit) || threadViewLimit == 0){
		threadViewLimit = "";
	}else{
		if(gThreadItems[index].boardType == gB2rService.BOARD_TYPE_MACHI){
			threadViewLimit = "&LAST=" + threadViewLimit;
		}else{
			threadViewLimit = "l" + threadViewLimit;
		}
	}
	var url = "/thread/" + gThreadItems[index].url + threadViewLimit;
	url = gB2rService.serverURL.resolve(url);

	gB2rService.openURL(url, null, aAddTab);
}

function deleteThreadLog(aEvent){
	var selectionIndices = getSelectionIndices();
	var ioService = XPC.getService("@mozilla.org/network/io-service;1", "nsIIOService");
	for each(let i in selectionIndices){
		var threadURL = ioService.newURI(gThreadItems[i].url, null, null);
		var boardURL = gB2rService.threadUtils.getBoardURL(threadURL);
		gB2rStorageService.deleteThreadData(boardURL, gThreadItems[i].datID, true);
	}

	setTimeout("initLogDataTree(gBoardListBox.selectedItem.value)", 0);
}


function LogDataTreeView(aItems){
	this._items = aItems;
	this._rowCount = aItems.length;
}

LogDataTreeView.prototype = {


// ********** ********* implements nsITreeView ********** **********


	get rowCount(){
		return this._rowCount;
	},

	selection: null,

	getCellText : function(aRow, aCol){
		var property = aCol.element._property;
		return this._items[aRow][property];
	},

	setTree: function(aTree){
		if(aTree){
			for(var i=0; i<aTree.columns.count; i++){
				var columnElement = aTree.columns.getColumnAt(i).element;
				columnElement._property = columnElement.getAttribute("property");
			}
		}
		this._treeBox = aTree;
	},

	cycleHeader: function(aCol){},
	getRowProperties: function(aIndex, aProperties){},
	getCellProperties: function(aRow, aCol, aProperties){},
	getColumnProperties: function(aCol, aProperties){},
	isContainer: function(aRow){ return false; },
	isContainerOpen: function(aRow){ return false; },
	isContainerEmpty: function(aRow){ return false; },
	isSeparator: function(aRow){ return false; },
	isSorted: function(aRow){ return false; },
	canDrop: function(aIndex){ return false; },
	canDropOn: function(aIndex){},
	canDropBeforeAfter: function(aIndex, aBefore){},
	drop: function(aIndex, aOrientation){},
	getParentIndex: function getParentIndex(aIndex){ return -1; },
	hasNextSibling: function(aIndex, aAfterIndex){ return false; },
 	getLevel: function(aIndex){ return 0; },
	getImageSrc: function(aRow, aCol){},
	getProgressMode: function(aRow, aCol){},
	getCellValue: function(aRow, aCol){},
	selectionChanged: function(){},
	cycleCell: function(aRow, aCol){},
	isEditable: function(aRow, aCol){ return false; },
	setCellText: function(aRow, aCol, aValue){},
	toggleOpenState: function(aIndex){},
	performAction: function(aAction){},
	performActionOnRow: function(aAction, aRow){},
	performActionOnCell: function(aAction, aRow, aCol){}
}