/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function Bbs2chBoardItems(aURLSpec){
	this.init(aURLSpec);
}


Bbs2chBoardItems.prototype = {


// ********** ********* プロパティ ********** **********


	get items(){
		return this._items;
	},

	get url(){
		return this._url;
	},


	get subjectURL(){
		return this._subjectURL;
	},


	get subjectFile(){
		return this._subjectFile;
	},

	get settingURL(){
		return this._settingURL;
	},


	get settingFile(){
		return this._settingFile;
	},


	get type(){
		return this._type;
	},


	get validURL(){
		return this._validURL;
	},


	get title(){
			// VIP のタイトルに A タグが追加されたので除去
		var title = this.getSetting("BBS_TITLE");
		return title ? title.replace(/<[^>]+>/g, "") : this.url.spec;
	},


	get logoURL(){
		var logoURLSpec = this.getSetting("BBS_TITLE_PICTURE") || "";
		if(!logoURLSpec)
			logoURLSpec = this.getSetting("BBS_FIGUREHEAD") || "";

		if(logoURLSpec){
			try{
					// 相対リンクの解決
				return this._ioService.newURI(logoURLSpec, null, this.url);
			}catch(ex){
				try{
					return this._ioService.newURI(logoURLSpec, null, null);
				}catch(ex2){
					return null;
				}
			}
		}
		return null;
	},


// ********** ********* メソッド ********** **********


	init: function(aURLSpec){
		this._b2rService = XPC.getService("@bbs2ch.sourceforge.jp/b2r-global-service;1", "b2rIGlobalService");
		this._ioService = XPC.getService("@mozilla.org/network/io-service;1", "nsIIOService");

		this._validURL = false;
		try{
			this._url = this._ioService.newURI(aURLSpec, null, null).QueryInterface(Ci.nsIURL);

			this._subjectURL = this._ioService.newURI("subject.txt", null, this.url)
					.QueryInterface(Ci.nsIURL);
			this._subjectFile = this._b2rService.io.getLogFileAtURL(this.subjectURL.spec);

			this._settingURL = this._ioService.newURI("SETTING.TXT", null, this.url)
					.QueryInterface(Ci.nsIURL);
			this._settingFile = this._b2rService.io.getLogFileAtURL(this.settingURL.spec);
		}catch(ex){
			Components.utils.reportError(ex);
			return;
		}

			// 板のタイプをチェック。TYPE_PAGE は TYPE_2CH にする
		this._type = this._b2rService.threadUtils.getBoardType(this.url);
		if(this._type == this._b2rService.BOARD_TYPE_PAGE)
					this._type = this._b2rService.BOARD_TYPE_2CH;

		this._items = new Array();
		this._validURL = true;
	},


	getSetting: function(aSettingName){
		if(!this._settings){
			this._settings = new Array();
			if(this.settingFile.exists()){
				var settingLines = this._b2rService.io.readFile(this.settingFile, this._getCharset());
				var regLine = /^(.+)=(.+)$/gm;
				while(regLine.exec(settingLines)){
					this._settings[RegExp.$1] = RegExp.$2;
				}
			}
		}
		return this._settings[aSettingName] || null;
	},


	_getCharset: function(){
		var charset = "Shift_JIS";
		switch(this.type){
			case this._b2rService.BOARD_TYPE_2CH:
				charset = "Shift_JIS";
				break;
			case this._b2rService.BOARD_TYPE_BE2CH:
			case this._b2rService.BOARD_TYPE_JBBS:
			case this._b2rService.BOARD_TYPE_MACHI:
				charset = "euc-jp";
				break;
		}
		return charset;
	},


	refresh: function(aFilterLimit){
		const STATUS_NEW       = 5;
		const STATUS_UNREAD    = 4;
		const STATUS_SUBSCRIBE = 3;
		const STATUS_NONE      = 2;
		const STATUS_DOWN      = 1;

			// スレッドの URL
		var baseUrlSpec;
		var categoryPath;
		var threadUrlSpec;
		switch(this.type){
			case this._b2rService.BOARD_TYPE_2CH:
			case this._b2rService.BOARD_TYPE_BE2CH:
				baseUrlSpec = this.url.resolve("../");
				categoryPath = this.url.spec.substring(baseUrlSpec.length);
				threadUrlSpec = baseUrlSpec + "test/read.cgi/" + categoryPath;
				break;
			case this._b2rService.BOARD_TYPE_JBBS:
				baseUrlSpec = this.url.resolve("../../");
				categoryPath = this.url.spec.substring(baseUrlSpec.length);
				threadUrlSpec = baseUrlSpec + "bbs/read.cgi/" + categoryPath;
				break;
			case this._b2rService.BOARD_TYPE_MACHI:
				categoryPath = this.url.directory.replace(/\//g, "");
				baseUrlSpec = this.url.resolve("../");
				threadUrlSpec = baseUrlSpec + "bbs/read.cgi?BBS=" + categoryPath;
				break;
		}


		this._items = new Array();
		this._lastItems = null;

		var b2rStorageService = XPC.getService("@bbs2ch.sourceforge.jp/b2r-storage-service;1", "b2rIStorageService");
		var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");

		var boardID = this._b2rService.threadUtils.getBoardID(this.url);

		var database = b2rStorageService.database;

		var subscribedOnly = "";
		if(aFilterLimit==0){
			aFilterLimit = 2000;
			subscribedOnly = "AND td.line_count > 1";
		}

		var sql;
		if(aFilterLimit == -1){
			sql = <>
				SELECT
				    1 AS status,
				    0 AS number,
				    td.dat_id AS dat_id,
				    td.title AS title,
				    0 AS line_count,
				    td.line_count AS read,
				    0 AS unread,
				    0 AS force,
				    STRFTIME(?1, td.dat_id, 'unixepoch', 'localtime') AS make_date
				FROM thread_data AS td
				WHERE board_id=?2 AND dat_id IN (
				    SELECT dat_id FROM thread_data WHERE board_id=?2
				    EXCEPT
				    SELECT dat_id FROM board_subject WHERE board_id=?2
				)
				LIMIT ?3;
			</>.toString().replace(/\t/g, "");
		}else{
			sql = <>
				SELECT
				    IFNULL((td.line_count > 0), 0) + IFNULL((bs.line_count - td.line_count AND 1), 0) + 2 AS status,
				    bs.ordinal + 1 AS number,
				    bs.dat_id AS dat_id,
				    bs.title AS title,
				    bs.line_count AS line_count,
				    IFNULL(td.line_count, 0) AS read,
				    MAX(IFNULL(bs.line_count - td.line_count, 0), 0) AS unread,
				    bs.line_count / ((strftime('%s','now') - bs.dat_id) / 86400.0) AS force,
				    STRFTIME(?1, bs.dat_id, 'unixepoch', 'localtime') AS make_date
				FROM board_subject AS bs LEFT OUTER JOIN thread_data AS td
				ON bs.board_id=td.board_id AND bs.dat_id=td.dat_id
				WHERE bs.board_id=?2 {subscribedOnly}
				LIMIT ?3;
			</>.toString().replace(/\t/g, "");
		}

		var statement = database.createStatement(sql);

		database.beginTransaction();
		try{
			statement.bindStringParameter(0, pref.getCharPref("extensions.bbs2chreader.board_created_format"));
			statement.bindStringParameter(1, boardID);
			statement.bindInt32Parameter(2, aFilterLimit);
			var now = Date.now() / 1000;
			while(statement.executeStep()){
				let item = {};
				item.status = statement.getInt32(0);
				item.number = statement.getInt32(1);
				item.datID = statement.getString(2);
				item.id = "item-" + item.datID;
				item.title = statement.getString(3);
				item.count = statement.getInt32(4);
				item.read = statement.getInt32(5);
				item.unread = statement.getInt32(6);
				item.force = statement.getInt32(7)
				item.created = statement.getString(8);

				item.url = threadUrlSpec + item.datID + "/";
				if(this.type == this._b2rService.BOARD_TYPE_MACHI){
					item.url = threadUrlSpec + "&KEY=" + item.datID;
				}
				this._items.push(item);
			}
		}catch(ex){
			Components.utils.reportError(ex);
		}finally{
			statement.reset();
			database.commitTransaction();
		}

	},


	search: function(aSearchString){
		if(!this._lastItems) this._lastItems = this.items.concat();

		var unicodeNormalizer = XPC.createInstance("@mozilla.org/intl/unicodenormalizer;1", "nsIUnicodeNormalizer");
		var normalizedStr = {};

		var searchString = aSearchString.toLowerCase();
		unicodeNormalizer.NormalizeUnicodeNFKC(searchString, normalizedStr);
		searchString = normalizedStr.value;

		var resultItems = new Array();
		for(var i=0; i<this._lastItems.length; i++){
			var title = this._lastItems[i].title.toLowerCase();
			unicodeNormalizer.NormalizeUnicodeNFKC(title, normalizedStr);
			title = normalizedStr.value;
			if(title.indexOf(searchString) != -1)
					resultItems.push(this._lastItems[i]);
		}
		return this._items = resultItems;
	}


}