/*!
  \file
  \brief FileToArgs ̃eXg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TestFileToArgs.h"
#include "FileToArgs.h"


CPPUNIT_TEST_SUITE_REGISTRATION(FileToArgsTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(FileToArgsTest, "FileToArgsTest");

using namespace beego;


void FileToArgsTest::createTest(void) {

  FileToArgs fileArgs;
  fileArgs.load("args_sample.txt");

  CPPUNIT_ASSERT_EQUAL(2, fileArgs.argc);
  CPPUNIT_ASSERT_EQUAL(std::string("--port=/dev/ttyACM0"),
                       std::string(fileArgs.argv[1]));
}


void FileToArgsTest::matchTest(void) {
  // st@C sloader ɂƂ̃eXgǉ
  FileToArgs fileArgs;
  fileArgs.load("args_sample.txt", "sloader");

  CPPUNIT_ASSERT_EQUAL(2, fileArgs.argc);
  CPPUNIT_ASSERT_EQUAL(std::string("sloader"), std::string(fileArgs.argv[0]));
  CPPUNIT_ASSERT_EQUAL(std::string("--port=/dev/usb/ttyUSB0"),
                       std::string(fileArgs.argv[1]));
}


void FileToArgsTest::regexpTest(void) {
  // st@C Pgm ܂ރt@CɂƂ̃eXgǉ
  FileToArgs fileArgs;
  fileArgs.load("args_sample.txt", "pgm238CtrlSample");

  CPPUNIT_ASSERT_EQUAL(3, fileArgs.argc);
  CPPUNIT_ASSERT_EQUAL(std::string("pgm238CtrlSample"),
                       std::string(fileArgs.argv[0]));
  CPPUNIT_ASSERT_EQUAL(std::string("--port=/dev/ttyACM0"),
                       std::string(fileArgs.argv[1]));
  CPPUNIT_ASSERT_EQUAL(std::string("-b=4800"), std::string(fileArgs.argv[2]));
}
