#ifndef RING_BUFFER_H
#define RING_BUFFER_H

/*!
  \file
  \brief Oobt@

  \author Satofumi KAMIMURA

  $Id$
*/


/*!
  \brief Oobt@̊Ǘ
*/
typedef struct {
  unsigned char *buffer;
  int buffer_size;
  int first;
  int last;
} ringBuffer_t;


//#include "cpp_extern_macro.h"
//BEGIN_C_DECLS;

extern void ring_init(ringBuffer_t *ring,
                      unsigned char *buffer, const int shift_length);
extern void ring_clear(ringBuffer_t *ring);
extern int ring_size(ringBuffer_t *ring);
extern int ring_capacity(ringBuffer_t *ring);
extern int ring_putchar(ringBuffer_t *ring, const unsigned char ch);
extern int ring_getchar(ringBuffer_t *ring, unsigned char *ch);
extern int ring_write(ringBuffer_t *ring, const unsigned char *data, int size);
extern int ring_read(ringBuffer_t *ring, unsigned char *buffer, int size);

//END_C_DECLS;
#endif /* ! RING_BUFFER_H */
