! Hellow world program for SH7045F(Alpha Project)
! Satofumi KAMIMURA
! $I$

	.global start
	.text
! main rutine
	nop
start:
	bsr	bus_init
	nop

	bsr	sci_init
	nop

	! print "Hello.\r\n"
	bsr	put1ch
	mov	#'H', r0
	bsr	put1ch
	mov	#'e', r0
	bsr	put1ch
	mov	#'l', r0
	bsr	put1ch
	mov	#'l', r0
	bsr	put1ch
	mov	#'o', r0
	bsr	put1ch
	mov	#'.', r0
	bsr	put1ch
	mov	#'\r', r0
	bsr	put1ch
	mov	#'\n', r0

	! infinity loop
	nop
inf_loop:
	bra	inf_loop
	nop

! Put a character
	nop
put1ch:
	mov	r0, r3
	mov.l	SSR1, r4	! while (!(SSR & 0x80)) !
put1ch_begin:
	mov.b	@r4, r0
	and	#0x80, r0
	cmp/pl  r0
	bf	put1ch_begin

	mov.l	TDR1, r2	! TDR = r0
	mov.b	r3, @r2

!	mov.l	SSR1, r4	! SSR &= ~0x80
	mov.b	@r4, r0
	and	#~0x80, r0
	mov.b	r0, @r4

	rts
	nop

	.align 4
TDR1:		.long	0xffff81b3
!SSR1:		.long	0xffff81b4

	.text
! SCI1 Initialize
	nop
sci_init:
	mov.l	PACRL2, r2	! enable RxD1, TxD1
	mov.w	PACRL2_D, r0
	mov.w	r0, @r2

	mov.l	SMR1, r2	! 115200bps, 8bit, 1stop bit, no parity
	mov	#0, r0
	mov.b	r0, @r2

	mov.l	BRR1, r2	! set BBR
	mov	#7, r0
	mov.b	r0, @r2

	! wait 1bit time

	mov.l	SCR1, r2	! TE = 1, RE = 1
	mov	#0x30, r0
	mov.b	r0, @r2

	mov.l	SSR1, r2	! SSR = 0x80
	mov.b	@r2, r0
	mov	#0x80, r0
	mov.b	r0, @r2

	rts
	nop

	.align 4
PACRL2:		.long	0xffff838e
SMR1:		.long	0xffff81b0
BRR1:		.long	0xffff81b1
SCR1:		.long	0xffff81b2
SSR1:		.long	0xffff81b4

	.align 2
PACRL2_D:	.word	0x0140

	! Bus initialize
bus_init:
	mov.l	BCR1,r2
	mov.w	BCR1_D, r0	! CS0 16
	mov.w	r0, @r2

	mov.l	BCR2,r2
	mov.w	BCR2_D, r0	! CS0~CS3 1 idle-cycle
	mov.w	r0, @r2

	mov.l	WCR1,r2
	mov.w	WCR1_D,r0
	mov.w	r0, @r2

	mov.l	PACRH,r2
	mov.w	PACRH_D, r0	! WRHH WRHL PA21~16
	mov.w	r0, @r2

	mov.l	PACRL1,r2
	mov.w	PACRL1_D, r0	! CK RD WRH WRL CS1 CS0 PA9,8
	mov.w	r0, @r2

!	mov.l	PACRL2, r2	! enable RxD1, TxD1
!	mov.w	PACRL2_D, r0
!	mov.w	r0, @r2

	mov.l	PBCR1,r2
	mov.w	PBCR1_D, r0
	mov.w	r0, @r2		! A21/A20

	mov.l	PBCR2,r2
	mov.w	PBCR2_D, r0 	! A19-A16
	mov.w	r0,@r2

	mov.l	PCCR,r2
	mov.w	PCCR_D, r0 	! A15-A0
	mov.w	r0,@r2

	mov.l	PDCRH1,r2
	mov.w	PDCRH1_D,r0 	! D31-D24
	mov.w	r0,@r2

	mov.l	PDCRH2,r2
	mov.w	PDCRH2_D,r0 	! D23-D16
	mov.w	r0,@r2

	mov.l	PDCRL,r2
	mov.w	PDCRL_D,r0 	! D0-D7
	mov.w	r0,@r2

	rts
	nop

	.align	4
BCR1:		.long	0xffff8620
BCR2:		.long	0xffff8622
WCR1:		.long	0xffff8624
PACRH:		.long	0xffff8388
PACRL1:		.long	0xffff838c
!PACRL2:		.long	0xffff838e
PBCR1:		.long	0xffff8398
PBCR2:		.long	0xffff839a
PCCR:		.long	0xffff839c
PDCRH1:		.long	0xffff83a8
PDCRH2:		.long	0xffff83aa
PDCRL:		.long	0xffff83ac
PECR1:		.long	0xffff83b8

	.align 2
BCR1_D:		.word	0x20ff
BCR2_D:		.word	0x0000
WCR1_D:		.word	0x0000
PACRH_D:	.word	0x5000
PACRL1_D:	.word	0x5550
!PACRL2_D:	.word	0x0140
PBCR1_D:	.word	0x000a
PBCR2_D:	.word	0xa005
PCCR_D:		.word	0xffff
PDCRH1_D:	.word	0x5555
PDCRH2_D:	.word	0x5555
PDCRL_D:	.word	0xffff
PECR1_D:	.word	0x0000
