/*!
  \file
  \brief Pb̕\

  \author Satofumi KAMIMURA

  $Id$
*/

#include "sci_put.h"
#include "imask_ctrl.h"
#include "timer_ctrl.h"


enum {
  SCI_PORT = SCI_1,
  TIMER_PORT = TIMER_0,
};

static void timer_handler(void) {
  static int msec = 0;
  static int sec = 0;

  ++msec;
  if (msec >= 1000) {
    ++sec;
    msec = 0;
    sci_putchar(SCI_PORT, '.');
  }
  if (sec >= 10) {
    timer_stop(TIMER_PORT);
    sci_puts(SCI_PORT, "stop\r\n");
  }
}


void __main(void) {}
int main(void) {

  sci_init(SCI_PORT, 6);
  imask_set(0);

  sci_puts(SCI_PORT, "start\r\n");

  timer_init(TIMER_PORT, 4, 1000, timer_handler);
  timer_start(TIMER_PORT);

  while (1)
    ;
}
