/*!
  \file
  \brief WDT ̓Tv

  \author Satofumi KAMIMURA

  $Id$
*/

#include "wdt_ctrl.h"
#include "sci_put.h"
#include "timer_ctrl.h"
#include "imask_ctrl.h"

enum {
  SCI_PORT = SCI_1,
  TIMER_PORT = TIMER_0,
};


static void timer_handler(void) {
  static int msec = 0;
  static int sec = 0;
  static int wdt_msec = 0;

  // Qbȏo߂AWDT  touch Ȃ
  ++msec;
  if (msec > 1000) {
    ++sec;
    msec = 0;
    sci_putchar(SCI_PORT, '.');
  }
  if (sec >= 2) {
    return;
  }

  ++wdt_msec;
  if (wdt_msec > 70) {
    wdt_touch();
  }
}


void __main(void) {}
int main(void) {

  sci_init(SCI_PORT, 6);
  imask_set(0);
  timer_init(TIMER_PORT, 4, 1000, timer_handler);

  sci_puts(SCI_PORT, "wdt sample\r\n");
  timer_start(TIMER_PORT);
  wdt_start(WDT_73_MSEC);

  while (1)
    ;
}
